/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.general;

import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;

public class MACParameters
extends Module {
    public MACParameters(DicomObject dcmobj) {
        super(dcmobj);
    }

    public MACParameters() {
        super((DicomObject)new BasicDicomObject());
    }

    public static MACParameters[] toMACParameters(DicomElement sq) {
        if (sq == null || !sq.hasItems()) {
            return null;
        }
        MACParameters[] a = new MACParameters[sq.countItems()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new MACParameters(sq.getDicomObject(i));
        }
        return a;
    }

    public int getMACIDNumber() {
        return this.dcmobj.getInt(0x4000005);
    }

    public void setMACIDNumber(int i) {
        this.dcmobj.putInt(0x4000005, VR.US, i);
    }

    public String getMACCalculationTransferSyntaxUID() {
        return this.dcmobj.getString(0x4000010);
    }

    public void setMACCalculationTransferSyntaxUID(String s) {
        this.dcmobj.putString(0x4000010, VR.UI, s);
    }

    public String getMACAlgorithm() {
        return this.dcmobj.getString(67108885);
    }

    public void setMACAlgorithm(String s) {
        this.dcmobj.putString(67108885, VR.CS, s);
    }

    public int[] getDataElementsSigned() {
        return this.dcmobj.getInts(0x4000020);
    }

    public void setDataElementsSigned(int[] ints) {
        this.dcmobj.putInts(0x4000020, VR.AT, ints);
    }
}

