/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.general;

import java.util.Date;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.module.general.CodingSchemeIdentification;
import org.dcm4che2.iod.module.general.ContributingEquipment;
import org.dcm4che2.iod.module.general.DigitalSignatures;
import org.dcm4che2.iod.module.general.EncryptedAttributes;
import org.dcm4che2.iod.module.general.HL7StructuredDocumentReference;
import org.dcm4che2.iod.module.general.MACParameters;

public class SOPCommonModule
extends Module {
    public SOPCommonModule(DicomObject dcmobj) {
        super(dcmobj);
    }

    public SOPCommonModule() {
        super((DicomObject)new BasicDicomObject());
    }

    public String getSOPClassUID() {
        return this.dcmobj.getString(524310);
    }

    public void setSOPClassUID(String uid) {
        this.dcmobj.putString(524310, VR.UI, uid);
    }

    public String getSOPInstanceUID() {
        return this.dcmobj.getString(524312);
    }

    public void setSOPInstanceUID(String uid) {
        this.dcmobj.putString(524312, VR.UI, uid);
    }

    public String[] getSpecificCharacterSet() {
        return this.dcmobj.getStrings(524293);
    }

    public void setSpecificCharacterSet(String[] ss) {
        this.dcmobj.putStrings(524293, VR.CS, ss);
    }

    public Date getInstanceCreationDateTime() {
        return this.dcmobj.getDate(524306, 524307);
    }

    public void setInstanceCreationDateTime(Date d) {
        this.dcmobj.putDate(524306, VR.DA, d);
        this.dcmobj.putDate(524307, VR.TM, d);
    }

    public String getInstanceCreatorUID() {
        return this.dcmobj.getString(524308);
    }

    public void setInstanceCreatorUID(String s) {
        this.dcmobj.putString(524308, VR.UI, s);
    }

    public String getRelatedGeneralSOPClassUID() {
        return this.dcmobj.getString(524314);
    }

    public void setRelatedGeneralSOPClassUID(String s) {
        this.dcmobj.putString(524314, VR.UI, s);
    }

    public String getOriginalSpecializedSOPClassUID() {
        return this.dcmobj.getString(524315);
    }

    public void setOriginalSpecializedSOPClassUID(String s) {
        this.dcmobj.putString(524315, VR.UI, s);
    }

    public CodingSchemeIdentification[] getCodingSchemeIdentifications() {
        return CodingSchemeIdentification.toCodingSchemeIdentifications(this.dcmobj.get(524560));
    }

    public void setCodingSchemeIdentifications(CodingSchemeIdentification[] ids) {
        this.updateSequence(524560, ids);
    }

    public String getTimezoneOffsetFromUTC() {
        return this.dcmobj.getString(524801);
    }

    public void setTimezoneOffsetFromUTC(String s) {
        this.dcmobj.putString(524801, VR.SH, s);
    }

    public ContributingEquipment[] getContributingEquipments() {
        return ContributingEquipment.toContributingEquipments(this.dcmobj.get(1613825));
    }

    public void setContributingEquipments(ContributingEquipment[] codes) {
        this.updateSequence(1613825, codes);
    }

    public String getInstanceNumber() {
        return this.dcmobj.getString(2097171);
    }

    public void setInstanceNumber(String s) {
        this.dcmobj.putString(2097171, VR.IS, s);
    }

    public String getSOPInstanceStatus() {
        return this.dcmobj.getString(0x1000410);
    }

    public void setSOPInstanceStatus(String s) {
        this.dcmobj.putString(0x1000410, VR.CS, s);
    }

    public Date getSOPAuthorizationDateTime() {
        return this.dcmobj.getDate(16778272);
    }

    public void setSOPAuthorizationDateTime(Date d) {
        this.dcmobj.putDate(16778272, VR.DT, d);
    }

    public String getSOPAuthorizationComment() {
        return this.dcmobj.getString(16778276);
    }

    public void setSOPAuthorizationComment(String s) {
        this.dcmobj.putString(16778276, VR.LT, s);
    }

    public String getAuthorizationEquipmentCertificationNumber() {
        return this.dcmobj.getString(16778278);
    }

    public void setAuthorizationEquipmentCertificationNumber(String s) {
        this.dcmobj.putString(16778278, VR.LO, s);
    }

    public MACParameters[] getMACParameters() {
        return MACParameters.toMACParameters(this.dcmobj.get(1342046209));
    }

    public void setMACParameters(MACParameters[] mac) {
        this.updateSequence(1342046209, mac);
    }

    public DigitalSignatures[] getDigitalSignatures() {
        return DigitalSignatures.toDigitalSignatures(this.dcmobj.get(-327686));
    }

    public void setDigitalSignatures(DigitalSignatures[] signatures) {
        this.updateSequence(-327686, signatures);
    }

    public EncryptedAttributes[] getEncryptedAttributes() {
        return EncryptedAttributes.toEncryptedAttributes(this.dcmobj.get(0x4000500));
    }

    public void setEncryptedAttributes(EncryptedAttributes[] attrs) {
        this.updateSequence(0x4000500, attrs);
    }

    public HL7StructuredDocumentReference[] getHL7StructuredDocumentReferences() {
        return HL7StructuredDocumentReference.toHL7StructuredDocumentReferences(this.dcmobj.get(4236176));
    }

    public void setHL7StructuredDocumentReferences(HL7StructuredDocumentReference[] hl7srref) {
        this.updateSequence(4236176, hl7srref);
    }
}

