/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.lut;

import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.value.PixelRepresentation;

public class Lut
extends Module {
    public Lut(DicomObject dcmobj) {
        super(dcmobj);
    }

    public static Lut[] toLUTs(DicomElement sq) {
        if (sq == null || !sq.hasItems()) {
            return null;
        }
        Lut[] a = new Lut[sq.countItems()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new Lut(sq.getDicomObject(i));
        }
        return a;
    }

    public int[] getLUTDescriptor() {
        return this.dcmobj.getInts(2633730);
    }

    public void setLUTDescriptor(int[] ints) {
        this.dcmobj.putInts(2633730, PixelRepresentation.isSigned(this.dcmobj.getParent()) ? VR.SS : VR.US, ints);
    }

    public int getNumberOfEntries() {
        int ret = this.getLUTDescriptor()[0];
        if (ret == 0) {
            return 65536;
        }
        return ret;
    }

    public int getFirstStoredPixel() {
        return this.getLUTDescriptor()[1];
    }

    public int getBytesPerEntry() {
        byte[] lutData = this.getLUTData();
        return lutData.length / this.getNumberOfEntries();
    }

    public String getLUTExplanation() {
        return this.dcmobj.getString(2633731);
    }

    public void setLUTExplanation(String lo) {
        this.dcmobj.putString(2633731, VR.LO, lo);
    }

    public byte[] getLUTData() {
        return this.dcmobj.getBytes(2633734);
    }

    public void setLUTData(byte[] ow) {
        this.dcmobj.putBytes(2633734, VR.OW, ow);
    }
}

