/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.macro;

import java.util.Date;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.module.macro.Code;

public class ContentItem
extends Module {
    public ContentItem(DicomObject dcmobj) {
        super(dcmobj);
    }

    public ContentItem() {
        super((DicomObject)new BasicDicomObject());
    }

    public static ContentItem[] toContentItems(DicomElement sq) {
        if (sq == null || !sq.hasItems()) {
            return null;
        }
        ContentItem[] a = new ContentItem[sq.countItems()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new ContentItem(sq.getDicomObject(i));
        }
        return a;
    }

    public String getValueType() {
        return this.dcmobj.getString(0x40A040);
    }

    public void setValueType(String s) {
        this.dcmobj.putString(0x40A040, VR.CS, s);
    }

    public Code getConceptNameCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(4235331);
        return item != null ? new Code(item) : null;
    }

    public void setConceptNameCode(Code code) {
        this.updateSequence(4235331, code);
    }

    public Date getDateTime() {
        return this.dcmobj.getDate(4235552);
    }

    public void setDateTime(Date d) {
        this.dcmobj.putDate(4235552, VR.DT, d);
    }

    public Date getDate() {
        return this.dcmobj.getDate(4235553);
    }

    public void setDate(Date d) {
        this.dcmobj.putDate(4235553, VR.DA, d);
    }

    public Date getTime() {
        return this.dcmobj.getDate(4235554);
    }

    public void setTime(Date d) {
        this.dcmobj.putDate(4235554, VR.TM, d);
    }

    public String getPersonName() {
        return this.dcmobj.getString(4235555);
    }

    public void setPersonName(String s) {
        this.dcmobj.putString(4235555, VR.PN, s);
    }

    public String getUID() {
        return this.dcmobj.getString(4235556);
    }

    public void setUID(String s) {
        this.dcmobj.putString(4235556, VR.UI, s);
    }

    public String getTextValue() {
        return this.dcmobj.getString(4235616);
    }

    public void setTextValue(String s) {
        this.dcmobj.putString(4235616, VR.UT, s);
    }

    public Code getConceptCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(4235624);
        return item != null ? new Code(item) : null;
    }

    public void setConceptCode(Code code) {
        this.updateSequence(4235624, code);
    }

    public float getNumericValue() {
        return this.dcmobj.getFloat(4236042);
    }

    public void setNumericValue(float f) {
        this.dcmobj.putFloat(4236042, VR.DS, f);
    }

    public Code getMeasurementUnitsCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(4196586);
        return item != null ? new Code(item) : null;
    }

    public void setMeasurementUnitsCode(Code code) {
        this.updateSequence(4196586, code);
    }
}

