/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.macro;

import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.module.macro.Code;

public class PersonIdentification
extends Module {
    public PersonIdentification(DicomObject dcmobj) {
        super(dcmobj);
    }

    public PersonIdentification() {
        this((DicomObject)new BasicDicomObject());
    }

    public static PersonIdentification[] toPersonIdentifications(DicomElement sq) {
        if (sq == null || !sq.hasItems()) {
            return null;
        }
        PersonIdentification[] a = new PersonIdentification[sq.countItems()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new PersonIdentification(sq.getDicomObject(i));
        }
        return a;
    }

    public Code getPersonIdentificationCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(0x401101);
        return item != null ? new Code(item) : null;
    }

    public void setPersonIdentificationCode(Code code) {
        this.updateSequence(0x401101, code);
    }

    public String getPersonAddress() {
        return this.dcmobj.getString(4198658);
    }

    public void setPersonAddress(String s) {
        this.dcmobj.putString(4198658, VR.ST, s);
    }

    public String[] getPersonTelephoneNumbers() {
        return this.dcmobj.getStrings(4198659);
    }

    public void setPersonTelephoneNumbers(String[] ss) {
        this.dcmobj.putStrings(4198659, VR.LO, ss);
    }

    public String getInstitutionName() {
        return this.dcmobj.getString(524416);
    }

    public void setInstitutionName(String s) {
        this.dcmobj.putString(524416, VR.LO, s);
    }

    public String getInstitutionAddress() {
        return this.dcmobj.getString(524417);
    }

    public void setInstitutionAddress(String s) {
        this.dcmobj.putString(524417, VR.ST, s);
    }

    public Code getInstitutionCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(524418);
        return item != null ? new Code(item) : null;
    }

    public void setInstitutionCode(Code code) {
        this.updateSequence(524418, code);
    }
}

