/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.pr;

import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.iod.module.Module;

public class GraphicObject
extends Module {
    public static final String POINT = "POINT";
    public static final String POLYLINE = "POLYLINE";
    public static final String INTERPOLATED = "INTERPOLATED";
    public static final String CIRCLE = "CIRCLE";
    public static final String ELLIPSE = "ELLIPSE";

    public GraphicObject(DicomObject dcmobj) {
        super(dcmobj);
    }

    public static GraphicObject[] toGraphicObjects(DicomElement sq) {
        if (sq == null || !sq.hasItems()) {
            return null;
        }
        GraphicObject[] a = new GraphicObject[sq.countItems()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new GraphicObject(sq.getDicomObject(i));
        }
        return a;
    }

    public String getGraphicType() {
        return this.dcmobj.getString(7340067);
    }

    public boolean getGraphicFilled() {
        String grFill = this.dcmobj.getString(7340068);
        if (grFill == null) {
            return false;
        }
        return grFill.equalsIgnoreCase("Y");
    }

    public String getGraphicAnnotationUnits() {
        return this.dcmobj.getString(0x700005);
    }

    public int getGraphicDimensions() {
        return this.dcmobj.getInt(0x700020);
    }

    public int getNumberOfGraphicPoints() {
        return this.dcmobj.getInt(7340065);
    }

    public float[] getGraphicData() {
        return this.dcmobj.getFloats(0x700022);
    }
}

