/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.sr;

import java.util.Date;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.module.macro.Code;
import org.dcm4che2.iod.module.macro.SOPInstanceReference;
import org.dcm4che2.iod.module.sr.MeasuredValue;
import org.dcm4che2.iod.module.sr.SRDocumentContent;

public class SRDocumentContentModule
extends Module {
    public SRDocumentContentModule(DicomObject dcmobj) {
        super(dcmobj);
    }

    public String getValueType() {
        return this.dcmobj.getString(0x40A040);
    }

    public void setValueType(String s) {
        this.dcmobj.putString(0x40A040, VR.CS, s);
    }

    public Code getConceptNameCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(4235331);
        return item != null ? new Code(item) : null;
    }

    public void setConceptNameCode(Code code) {
        this.updateSequence(4235331, code);
    }

    public Date getDateTime() {
        return this.dcmobj.getDate(4235552);
    }

    public void setDateTime(Date d) {
        this.dcmobj.putDate(4235552, VR.DT, d);
    }

    public Date getDate() {
        return this.dcmobj.getDate(4235553);
    }

    public void setDate(Date d) {
        this.dcmobj.putDate(4235553, VR.DA, d);
    }

    public Date getTime() {
        return this.dcmobj.getDate(4235554);
    }

    public void setTime(Date d) {
        this.dcmobj.putDate(4235554, VR.TM, d);
    }

    public String getPersonName() {
        return this.dcmobj.getString(4235555);
    }

    public void setPersonName(String s) {
        this.dcmobj.putString(4235555, VR.PN, s);
    }

    public String getUID() {
        return this.dcmobj.getString(4235556);
    }

    public void setUID(String s) {
        this.dcmobj.putString(4235556, VR.UI, s);
    }

    public String getTextValue() {
        return this.dcmobj.getString(4235616);
    }

    public void setTextValue(String s) {
        this.dcmobj.putString(4235616, VR.UT, s);
    }

    public MeasuredValue getMeasuredValue() {
        DicomObject item = this.dcmobj.getNestedDicomObject(4236032);
        return item != null ? new MeasuredValue(item) : null;
    }

    public void setMeasuredValue(MeasuredValue value) {
        this.updateSequence(4236032, value);
    }

    public Code getNumericValueQualifierCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(4236033);
        return item != null ? new Code(item) : null;
    }

    public void setNumericValueQualifierCode(Code code) {
        this.updateSequence(4236033, code);
    }

    public Code getConceptCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(4235624);
        return item != null ? new Code(item) : null;
    }

    public void setConceptCode(Code code) {
        this.updateSequence(4235624, code);
    }

    public SOPInstanceReference getReferencedSOPInstance() {
        DicomObject item = this.dcmobj.getNestedDicomObject(4235624);
        return item != null ? new SOPInstanceReference(item) : null;
    }

    public void setReferencedSOPInstance(SOPInstanceReference ref) {
        this.updateSequence(4235624, ref);
    }

    public SRDocumentContent[] getContent() {
        return SRDocumentContent.toSRDocumentContent(this.dcmobj.get(4237104));
    }

    public void setContent(SRDocumentContent[] codes) {
        this.updateSequence(4237104, codes);
    }

    public String getContinuityOfContent() {
        return this.dcmobj.getString(4235344);
    }

    public void setContinuityOfContent(String s) {
        this.dcmobj.putString(4235344, VR.CS, s);
    }

    public Date getObservationDateTime() {
        return this.dcmobj.getDate(4235314);
    }

    public void setObservationDateTime(Date d) {
        this.dcmobj.putDate(4235314, VR.DT, d);
    }
}

