/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.module.sr;

import java.util.Date;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.VR;
import org.dcm4che2.iod.module.Module;
import org.dcm4che2.iod.module.macro.Code;

public class VerifyingObserver
extends Module {
    public VerifyingObserver(DicomObject dcmobj) {
        super(dcmobj);
    }

    public VerifyingObserver() {
        this((DicomObject)new BasicDicomObject());
    }

    public static VerifyingObserver[] toVerifyingObservers(DicomElement sq) {
        if (sq == null || !sq.hasItems()) {
            return null;
        }
        VerifyingObserver[] a = new VerifyingObserver[sq.countItems()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = new VerifyingObserver(sq.getDicomObject(i));
        }
        return a;
    }

    public String getVerifyingObserverName() {
        return this.dcmobj.getString(4235381);
    }

    public void setVerifyingObserverName(String s) {
        this.dcmobj.putString(4235381, VR.PN, s);
    }

    public Code getVerifyingObserverIdentificationCode() {
        DicomObject item = this.dcmobj.getNestedDicomObject(4235400);
        return item != null ? new Code(item) : null;
    }

    public void setVerifyingObserverIdentificationCode(Code code) {
        this.updateSequence(4235400, code);
    }

    public String getVerifyingOrganization() {
        return this.dcmobj.getString(4235303);
    }

    public void setVerifyingOrganization(String s) {
        this.dcmobj.putString(4235303, VR.LO, s);
    }

    public Date getVerificationDateTime() {
        return this.dcmobj.getDate(4235312);
    }

    public void setVerificationDateTime(Date dt) {
        this.dcmobj.putDate(4235312, VR.DT, dt);
    }
}

