/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.iod.validation;

import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomElement;
import org.dcm4che2.data.DicomObject;

public class ValidationResult {
    private DicomObject missingAttributes;
    private DicomObject missingValue;
    private DicomObject invalidValue;

    public void logMissingAttribute(int tag) {
        if (this.missingAttributes == null) {
            this.missingAttributes = new BasicDicomObject();
        }
        this.missingAttributes.putNull(tag, null);
    }

    public void logMissingValue(int tag) {
        if (this.missingValue == null) {
            this.missingValue = new BasicDicomObject();
        }
        this.missingValue.putNull(tag, null);
    }

    public void logInvalidValue(int tag, DicomObject testObj) {
        if (this.invalidValue == null) {
            this.invalidValue = new BasicDicomObject();
        }
        DicomElement e = testObj.get(tag);
        this.invalidValue.putBytes(tag, e.vr(), e.getBytes());
    }

    public void clear() {
        this.missingAttributes = null;
        this.missingValue = null;
        this.invalidValue = null;
    }

    public boolean isValid() {
        return this.missingAttributes == null && this.missingValue == null && this.invalidValue == null;
    }

    public DicomObject getMissingAttributes() {
        return this.missingAttributes;
    }

    public DicomObject getMissingValues() {
        return this.missingValue;
    }

    public DicomObject getInvalidValues() {
        return this.invalidValue;
    }
}

