/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class InitialContextFactory {
    private static Properties props = null;
    private static Properties securityProperties = null;

    public static InitialContext getInitialContext() throws NamingException {
        InitialContext jndiContext;
        if (props == null) {
            jndiContext = new InitialContext();
        } else if (securityProperties != null) {
            Properties combinedProps = new Properties();
            combinedProps.putAll((Map<?, ?>)props);
            combinedProps.putAll((Map<?, ?>)securityProperties);
            jndiContext = new InitialContext(combinedProps);
        } else {
            jndiContext = new InitialContext(props);
        }
        return jndiContext;
    }

    public static void setProperties(Properties properties) {
        props = properties;
    }

    public static void setSecurity(String user, String password) {
        if (props != null) {
            securityProperties = new Properties();
            securityProperties.put("java.naming.security.principal", user);
            securityProperties.put("java.naming.security.credentials", password);
            securityProperties.put("java.naming.factory.initial", "org.jboss.security.jndi.JndiLoginInitialContextFactory");
        }
    }
}

