/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import java.util.LinkedList;
import javax.ejb.EJBException;
import org.jboss.ejb3.AbstractPool;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.logging.Logger;

public class StrictMaxPool
extends AbstractPool {
    public static final int DEFAULT_MAX_SIZE = 30;
    public static final long DEFAULT_TIMEOUT = Long.MAX_VALUE;
    private FIFOSemaphore strictMaxSize;
    private long strictTimeout;
    protected LinkedList pool = new LinkedList();
    protected int maxSize = 30;
    Logger log = Logger.getLogger(StrictMaxPool.class);

    public void initialize(Container container, Class contextClass, Class beanClass, int maxSize, long timeout) {
        super.initialize(container, contextClass, beanClass, maxSize, timeout);
        this.maxSize = maxSize;
        this.strictMaxSize = new FIFOSemaphore((long)maxSize);
        this.strictTimeout = timeout;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        this.strictMaxSize = new FIFOSemaphore((long)maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanContext get() {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Get instance " + this + "#" + this.pool.size() + "#" + this.container.getBeanClass()));
        }
        try {
            boolean acquired = this.strictMaxSize.attempt(this.strictTimeout);
            if (trace) {
                this.log.trace((Object)("Acquired(" + acquired + ") strictMaxSize semaphore, remaining=" + this.strictMaxSize.permits()));
            }
            if (!acquired) {
                throw new EJBException("Failed to acquire the pool semaphore, strictTimeout=" + this.strictTimeout);
            }
        }
        catch (InterruptedException e) {
            throw new EJBException("Pool strictMaxSize semaphore was interrupted");
        }
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            if (!this.pool.isEmpty()) {
                return (BeanContext)this.pool.removeFirst();
            }
        }
        return this.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanContext get(Class[] initTypes, Object[] initValues) {
        boolean trace = this.log.isTraceEnabled();
        if (trace) {
            this.log.trace((Object)("Get instance " + this + "#" + this.pool.size() + "#" + this.container.getBeanClass()));
        }
        try {
            boolean acquired = this.strictMaxSize.attempt(this.strictTimeout);
            if (trace) {
                this.log.trace((Object)("Acquired(" + acquired + ") strictMaxSize semaphore, remaining=" + this.strictMaxSize.permits()));
            }
            if (!acquired) {
                throw new EJBException("Failed to acquire the pool semaphore, strictTimeout=" + this.strictTimeout);
            }
        }
        catch (InterruptedException e) {
            throw new EJBException("Pool strictMaxSize semaphore was interrupted");
        }
        LinkedList linkedList = this.pool;
        synchronized (linkedList) {
            if (!this.pool.isEmpty()) {
                return (BeanContext)this.pool.removeFirst();
            }
        }
        return this.create(initTypes, initValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(BeanContext ctx) {
        if (this.log.isTraceEnabled()) {
            String msg = this.pool.size() + "/" + this.maxSize + " Free instance:" + this + "#" + this.container.getBeanClass();
            this.log.trace((Object)msg);
        }
        try {
            boolean removeIt = false;
            LinkedList linkedList = this.pool;
            synchronized (linkedList) {
                if (this.pool.size() < this.maxSize) {
                    this.pool.addFirst(ctx);
                } else {
                    removeIt = true;
                }
            }
            if (removeIt) {
                this.remove(ctx);
            }
            this.strictMaxSize.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void discard(BeanContext ctx) {
        if (this.log.isTraceEnabled()) {
            String msg = "Discard instance:" + this + "#" + ctx + "#" + this.container.getBeanClass();
            this.log.trace((Object)msg);
        }
        this.strictMaxSize.release();
        super.discard(ctx);
    }

    protected void destroy() throws Exception {
        this.freeAll();
        this.container = null;
    }

    private void freeAll() {
        LinkedList clone = (LinkedList)this.pool.clone();
        for (int i = 0; i < clone.size(); ++i) {
            BeanContext bc = (BeanContext)clone.get(i);
            this.discard(bc);
        }
        this.pool.clear();
    }
}

