/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.tree;

import javax.ejb.EJBException;
import javax.ejb.EJBNoSuchObjectException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.annotation.ejb.cache.tree.CacheConfig;
import org.jboss.aop.Advisor;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.TreeCacheMBean;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.Pool;
import org.jboss.ejb3.cache.ClusteredStatefulCache;
import org.jboss.ejb3.cache.tree.PassivationTreeCache;
import org.jboss.ejb3.cache.tree.StatefulEvictionPolicy;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;

public class StatefulTreeCache
implements ClusteredStatefulCache {
    private Pool pool;
    private PassivationTreeCache cache;
    private String cacheNode;
    private StatefulEvictionPolicy eviction;

    public StatefulBeanContext create() {
        StatefulBeanContext ctx = null;
        try {
            ctx = (StatefulBeanContext)this.pool.get();
            this.cache.put(this.cacheNode + "/" + ctx.getId(), "bean", ctx);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return ctx;
    }

    public StatefulBeanContext create(Class[] initTypes, Object[] initValues) {
        StatefulBeanContext ctx = null;
        try {
            ctx = (StatefulBeanContext)this.pool.get(initTypes, initValues);
            this.cache.put(this.cacheNode + "/" + ctx.getId(), "bean", ctx);
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return ctx;
    }

    public StatefulBeanContext get(Object key) throws EJBException {
        StatefulBeanContext entry = null;
        try {
            Object obj = this.cache.get(this.cacheNode + "/" + key, "bean");
            entry = (StatefulBeanContext)obj;
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
        if (entry == null) {
            throw new EJBNoSuchObjectException("Could not find Stateful bean: " + key);
        }
        entry.inUse = true;
        entry.lastUsed = System.currentTimeMillis();
        return entry;
    }

    public void remove(Object key) {
        BeanContext ctx = null;
        try {
            this.cache.remove(this.cacheNode + "/" + key);
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
        if (ctx != null) {
            this.pool.remove(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(StatefulBeanContext ctx) {
        StatefulBeanContext statefulBeanContext = ctx;
        synchronized (statefulBeanContext) {
            ctx.inUse = false;
            ctx.lastUsed = System.currentTimeMillis();
            if (ctx.markedForPassivation) {
                try {
                    Fqn fqn = Fqn.fromString((String)(this.cacheNode + "/" + ctx.getId()));
                    this.eviction.passivate(fqn, ctx);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void replicate(StatefulBeanContext ctx) {
        try {
            this.cache.put(this.cacheNode + "/" + ctx.getId(), "bean", ctx);
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
    }

    public void initialize(Container container) throws Exception {
        Advisor advisor = (Advisor)container;
        this.pool = container.getPool();
        CacheConfig config = (CacheConfig)advisor.resolveAnnotation(CacheConfig.class);
        MBeanServer server = MBeanServerLocator.locateJBoss();
        ObjectName cacheON = new ObjectName(config.name());
        TreeCacheMBean mbean = (TreeCacheMBean)MBeanProxyExt.create(TreeCacheMBean.class, (ObjectName)cacheON, (MBeanServer)server);
        this.cache = (PassivationTreeCache)mbean.getInstance();
        this.cacheNode = "/" + container.getEjbName();
        this.eviction = (StatefulEvictionPolicy)this.cache.getEvictionPolicy();
        this.eviction.createRegion(this.cacheNode, config.maxSize(), config.idleTimeoutSeconds());
    }

    public void start() {
    }

    public void stop() {
    }
}

