/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.annotation.ejb.DefaultActivationSpecs;
import org.jboss.aop.AspectManager;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.util.MethodHashing;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.mdb.MessagingContainer;
import org.jboss.logging.Logger;
import org.jboss.mx.util.ObjectNameConverter;

public class MDB
extends MessagingContainer {
    private static final Logger log = Logger.getLogger(MDB.class);
    protected Class messagingType = null;
    protected static final String DEFAULT_DESTINATION_TYPE = "javax.jms.Topic";

    public MDB(String ejbName, AspectManager manager, ClassLoader cl, String beanClassName, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment) {
        super(ejbName, manager, cl, beanClassName, ctxProperties, interceptorRepository, deployment);
    }

    public Class getMessagingType() {
        if (this.messagingType == null) {
            MessageDriven annotation = (MessageDriven)this.resolveAnnotation(MessageDriven.class);
            this.messagingType = annotation.messageListenerInterface();
            if (this.messagingType.getName().equals(Object.class.getName())) {
                ArrayList<Class> list = ProxyFactoryHelper.getBusinessInterfaces(this.clazz);
                if (list.size() > 1 || list.size() == 0) {
                    throw new RuntimeException("unable to determine messagingType interface for MDB");
                }
                this.messagingType = list.get(0);
            }
        }
        return this.messagingType;
    }

    public MethodInfo getMethodInfo(Method method) {
        long hash = MethodHashing.calculateHash((Method)method);
        MethodInfo info = (MethodInfo)this.methodInterceptors.get(hash);
        return info;
    }

    public Map getActivationConfigProperties() {
        HashMap result = new HashMap();
        MessageDriven mdAnnotation = (MessageDriven)this.resolveAnnotation(MessageDriven.class);
        for (ActivationConfigProperty property : mdAnnotation.activationConfig()) {
            this.addActivationSpecProperty(result, property);
        }
        DefaultActivationSpecs defaultSpecsAnnotation = (DefaultActivationSpecs)this.resolveAnnotation(DefaultActivationSpecs.class);
        if (defaultSpecsAnnotation != null) {
            for (ActivationConfigProperty property : defaultSpecsAnnotation.value()) {
                this.addActivationSpecProperty(result, property);
            }
        }
        return result;
    }

    public void start() throws Exception {
        super.start();
    }

    public ObjectName getJmxName() {
        ObjectName jmxName = null;
        String jndiName = ProxyFactoryHelper.getLocalJndiName(this);
        String name = "jboss.j2ee:service=EJB,jndiName=" + jndiName;
        try {
            jmxName = ObjectNameConverter.convert((String)name);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create ObjectName, msg=" + e.getMessage());
        }
        return jmxName;
    }

    protected void populateActivationSpec() {
        DefaultActivationSpecs defaultSpecs = (DefaultActivationSpecs)this.resolveAnnotation(DefaultActivationSpecs.class);
        if (defaultSpecs != null) {
            this.activationSpec.merge(defaultSpecs.value());
        }
        MessageDriven md = (MessageDriven)this.resolveAnnotation(MessageDriven.class);
        this.activationSpec.merge(md.activationConfig());
    }
}

