/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.service;

import java.lang.reflect.InvocationTargetException;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.remoting.RemoteProxyFactory;
import org.jboss.ejb3.service.BaseServiceProxyFactory;
import org.jboss.ejb3.service.ServiceRemoteProxy;
import org.jboss.remoting.InvokerLocator;

public class ServiceRemoteProxyFactory
extends BaseServiceProxyFactory
implements RemoteProxyFactory {
    private RemoteBinding binding;
    private InvokerLocator locator;

    public void setRemoteBinding(RemoteBinding binding) {
        this.binding = binding;
    }

    protected Class[] getInterfaces() {
        Class[] remoteInterfaces = ProxyFactoryHelper.getRemoteInterfaces(this.container);
        Class[] interfaces = new Class[remoteInterfaces.length + 1];
        System.arraycopy(remoteInterfaces, 0, interfaces, 0, remoteInterfaces.length);
        interfaces[remoteInterfaces.length] = JBossProxy.class;
        return interfaces;
    }

    protected void initializeJndiName() {
        this.jndiName = ProxyFactoryHelper.getRemoteJndiName(this.container, this.binding);
    }

    public void start() throws Exception {
        String clientBindUrl = ProxyFactoryHelper.getClientBindUrl(this.binding);
        this.locator = new InvokerLocator(clientBindUrl);
        super.start();
    }

    public Object createProxy() {
        try {
            String containerId = this.container.getObjectName().getCanonicalName();
            String stackName = "ServiceClientInterceptors";
            if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
                stackName = this.binding.interceptorStack();
            }
            AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
            Object[] args = new Object[]{new ServiceRemoteProxy(containerId, stack.createInterceptors((Advisor)this.container, null), this.locator)};
            return this.proxyConstructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }
}

