/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.Handle;
import javax.ejb.Timer;
import javax.ejb.TimerService;
import javax.naming.NamingException;
import org.jboss.annotation.ejb.LocalBinding;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.annotation.ejb.RemoteBindings;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aspects.asynch.FutureHolder;
import org.jboss.ejb.AllowedOperationsAssociation;
import org.jboss.ejb.AllowedOperationsFlags;
import org.jboss.ejb3.BeanContext;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.ProxyUtils;
import org.jboss.ejb3.SessionContainer;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.stateless.StatelessBeanContext;
import org.jboss.ejb3.stateless.StatelessLocalProxyFactory;
import org.jboss.ejb3.stateless.StatelessRemoteProxyFactory;
import org.jboss.ejb3.timerservice.TimedObjectInvoker;
import org.jboss.ejb3.timerservice.TimerServiceFactory;
import org.jboss.logging.Logger;
import org.jboss.proxy.ejb.handle.HomeHandleImpl;
import org.jboss.proxy.ejb.handle.StatelessHandleImpl;

public class StatelessContainer
extends SessionContainer
implements TimedObjectInvoker {
    private static final Logger log = Logger.getLogger(StatelessContainer.class);
    protected TimerService timerService;

    public StatelessContainer(ClassLoader cl, String beanClassName, String ejbName, AspectManager manager, Hashtable ctxProperties, InterceptorInfoRepository interceptorRepository, Ejb3Deployment deployment) {
        super(cl, beanClassName, ejbName, manager, ctxProperties, interceptorRepository, deployment);
        this.beanContextClass = StatelessBeanContext.class;
    }

    public Object createSession(Class[] initTypes, Object[] initArgs) {
        if (initTypes != null && initTypes.length > 0 || initArgs != null && initArgs.length > 0) {
            throw new IllegalArgumentException("stateless bean create method must take no arguments (EJB3 4.5)");
        }
        return null;
    }

    public void start() throws Exception {
        try {
            super.start();
            this.timerService = TimerServiceFactory.getInstance().createTimerService(this.getObjectName(), this);
            TimerServiceFactory.getInstance().restoreTimerService(this.timerService);
        }
        catch (Exception e) {
            try {
                this.stop();
            }
            catch (Exception ignore) {
                log.debug((Object)"Failed to cleanup after start() failure", (Throwable)ignore);
            }
            throw e;
        }
    }

    public void stop() throws Exception {
        if (this.timerService != null) {
            TimerServiceFactory.getInstance().removeTimerService(this.timerService);
        }
        super.stop();
    }

    public TimerService getTimerService() {
        return this.timerService;
    }

    public TimerService getTimerService(Object pKey) {
        assert (this.timerService != null) : "Timer Service not yet initialized";
        return this.timerService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callTimeout(Timer timer) throws Exception {
        Method timeout = this.callbackHandler.getTimeoutCallback();
        if (timeout == null) {
            throw new EJBException("No method has been annotated with @Timeout");
        }
        Object[] args = new Object[]{timer};
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            AllowedOperationsAssociation.pushInMethodFlag((int)AllowedOperationsFlags.IN_EJB_TIMEOUT);
            try {
                MethodInfo info = (MethodInfo)this.methodInterceptors.get(this.callbackHandler.getTimeoutCalllbackHash());
                Interceptor[] aspects = info.getInterceptors();
                EJBContainerInvocation nextInvocation = new EJBContainerInvocation(info, aspects);
                nextInvocation.setAdvisor((Advisor)this);
                nextInvocation.setArguments(args);
                nextInvocation.invokeNext();
            }
            catch (Throwable throwable) {
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new RuntimeException(throwable);
            }
            finally {
                AllowedOperationsAssociation.popInMethodFlag();
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    public Object localInvoke(Method method, Object[] args) throws Throwable {
        return this.localInvoke(method, args, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object localInvoke(Method method, Object[] args, FutureHolder provider) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            MethodInfo info;
            block9: {
                Object object;
                long hash = MethodHashing.calculateHash((Method)method);
                info = (MethodInfo)this.methodInterceptors.get(hash);
                if (info == null) {
                    throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
                }
                Method unadvisedMethod = info.getUnadvisedMethod();
                try {
                    this.invokedMethod.push(new SessionContainer.InvokedMethod(true, unadvisedMethod));
                    if (unadvisedMethod == null || !this.isHomeMethod(unadvisedMethod)) break block9;
                    object = this.invokeLocalHomeMethod(info, args);
                    this.invokedMethod.pop();
                }
                catch (Throwable throwable) {
                    this.invokedMethod.pop();
                    throw throwable;
                }
                return object;
            }
            Interceptor[] aspects = info.getInterceptors();
            EJBContainerInvocation nextInvocation = new EJBContainerInvocation(info, aspects);
            nextInvocation.setAdvisor((Advisor)this);
            nextInvocation.setArguments(args);
            ProxyUtils.addLocalAsynchronousInfo(nextInvocation, provider);
            Object object = nextInvocation.invokeNext();
            this.invokedMethod.pop();
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InvocationResponse dynamicInvoke(Object target, Invocation invocation) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            InvocationResponse response;
            Object rtn;
            Map responseContext;
            block13: {
                Thread.currentThread().setContextClassLoader(this.classloader);
                MethodInvocation si = (MethodInvocation)invocation;
                MethodInfo info = (MethodInfo)this.methodInterceptors.get(si.getMethodHash());
                if (info == null) {
                    throw new RuntimeException("Could not resolve beanClass method from proxy call");
                }
                Method unadvisedMethod = info.getUnadvisedMethod();
                try {
                    this.invokedMethod.push(new SessionContainer.InvokedMethod(false, unadvisedMethod));
                    responseContext = null;
                    rtn = null;
                    if (unadvisedMethod != null && this.isHomeMethod(unadvisedMethod)) {
                        rtn = this.invokeHomeMethod(info, si);
                        break block13;
                    }
                    if (info != null && unadvisedMethod != null && this.isEJBObjectMethod(unadvisedMethod)) {
                        rtn = this.invokeEJBObjectMethod(info, si);
                        break block13;
                    }
                    EJBContainerInvocation newSi = null;
                    Interceptor[] aspects = info.getInterceptors();
                    newSi = new EJBContainerInvocation(info, aspects);
                    newSi.setArguments(si.getArguments());
                    newSi.setMetaData(si.getMetaData());
                    newSi.setAdvisor((Advisor)this);
                    try {
                        rtn = newSi.invokeNext();
                        responseContext = newSi.getResponseContextInfo();
                    }
                    catch (Throwable throwable) {
                        responseContext = newSi.getResponseContextInfo();
                        InvocationResponse invocationResponse = StatelessContainer.marshallException(invocation, throwable, responseContext);
                        this.invokedMethod.pop();
                        Thread.currentThread().setContextClassLoader(oldLoader);
                        return invocationResponse;
                    }
                }
                catch (Throwable throwable) {
                    this.invokedMethod.pop();
                    throw throwable;
                }
            }
            InvocationResponse invocationResponse = response = StatelessContainer.marshallResponse(invocation, rtn, responseContext);
            this.invokedMethod.pop();
            return invocationResponse;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    protected Object invokeEJBObjectMethod(MethodInfo info, MethodInvocation invocation) throws Throwable {
        Method unadvisedMethod = info.getUnadvisedMethod();
        if (unadvisedMethod.getName().equals("getHandle")) {
            StatelessHandleImpl handle = null;
            RemoteBinding remoteBindingAnnotation = (RemoteBinding)this.resolveAnnotation(RemoteBinding.class);
            if (remoteBindingAnnotation != null) {
                handle = new StatelessHandleImpl(remoteBindingAnnotation.jndiBinding());
            }
            return handle;
        }
        if (unadvisedMethod.getName().equals("remove")) {
            return null;
        }
        if (unadvisedMethod.getName().equals("getEJBHome")) {
            HomeHandleImpl homeHandle = null;
            RemoteBinding remoteBindingAnnotation = (RemoteBinding)this.resolveAnnotation(RemoteBinding.class);
            if (remoteBindingAnnotation != null) {
                homeHandle = new HomeHandleImpl(remoteBindingAnnotation.jndiBinding() + "Home");
            }
            return homeHandle.getEJBHome();
        }
        if (unadvisedMethod.getName().equals("getPrimaryKey")) {
            return null;
        }
        if (unadvisedMethod.getName().equals("isIdentical")) {
            return false;
        }
        return null;
    }

    private Object invokeLocalHomeMethod(MethodInfo info, Object[] args) throws Exception {
        Method unadvisedMethod = info.getUnadvisedMethod();
        if (unadvisedMethod.getName().equals("create")) {
            LocalBinding binding = (LocalBinding)this.resolveAnnotation(LocalBinding.class);
            StatelessLocalProxyFactory factory = new StatelessLocalProxyFactory();
            factory.setContainer(this);
            factory.init();
            Object proxy = factory.createProxy();
            return proxy;
        }
        return null;
    }

    protected Object invokeHomeMethod(MethodInfo info, MethodInvocation invocation) throws Throwable {
        Method unadvisedMethod = info.getUnadvisedMethod();
        if (unadvisedMethod.getName().equals("create")) {
            RemoteBinding binding = null;
            RemoteBindings bindings = (RemoteBindings)this.resolveAnnotation(RemoteBindings.class);
            binding = bindings != null ? bindings.value()[0] : (RemoteBinding)this.resolveAnnotation(RemoteBinding.class);
            StatelessRemoteProxyFactory factory = new StatelessRemoteProxyFactory();
            factory.setContainer(this);
            factory.setRemoteBinding(binding);
            factory.init();
            return factory.createProxy();
        }
        return null;
    }

    public Object getBusinessObject(BeanContext ctx, Class intf) {
        try {
            String jndiName = ProxyFactoryHelper.getJndiName(this, intf);
            if (jndiName == null) {
                throw new IllegalStateException("Cannot find BusinessObject for interface: " + intf.getName());
            }
            return this.getInitialContext().lookup(ProxyFactoryHelper.getJndiName(this, intf));
        }
        catch (NamingException e) {
            throw new RuntimeException("failed to invoke getBusinessObject", e);
        }
    }

    protected void removeHandle(Handle handle) {
        throw new RuntimeException("NYI");
    }
}

