/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.timerservice.quartz;

import java.io.Serializable;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;
import javax.management.ObjectName;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.timerservice.TimedObjectInvoker;
import org.jboss.ejb3.timerservice.quartz.QuartzTimerServiceFactory;
import org.jboss.ejb3.timerservice.quartz.TimerImpl;
import org.jboss.logging.Logger;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class PersistentTimer
implements Serializable,
TimerHandle {
    private static final Logger log = Logger.getLogger(PersistentTimer.class);
    private static final long serialVersionUID = 1L;
    private String triggerName;
    private String triggerGroup;
    private ObjectName objectName;
    private Serializable info;

    protected PersistentTimer(Trigger trigger, ObjectName objectName, Serializable info) {
        assert (trigger != null);
        assert (objectName != null);
        this.triggerName = trigger.getName();
        this.triggerGroup = trigger.getGroup();
        this.objectName = objectName;
        this.info = info;
    }

    protected TimedObjectInvoker getTimedObjectInvoker() {
        TimedObjectInvoker invoker = (TimedObjectInvoker)((Object)Ejb3Registry.getContainer(this.objectName.getCanonicalName()));
        assert (invoker != null);
        return invoker;
    }

    public Timer getTimer() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        try {
            Scheduler scheduler = QuartzTimerServiceFactory.getScheduler();
            Trigger trigger = scheduler.getTrigger(this.triggerName, this.triggerGroup);
            if (trigger == null) {
                throw new NoSuchObjectLocalException("can't find trigger '" + this.triggerName + "' in group '" + this.triggerGroup + "'");
            }
            return new TimerImpl(scheduler, trigger, this.info);
        }
        catch (SchedulerException e) {
            log.error((Object)"getTimer failed", (Throwable)e);
            throw new EJBException((Exception)((Object)e));
        }
    }
}

