/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.blockmodel;

import edu.uci.ics.jung.algorithms.blockmodel.EquivalenceRelation;
import edu.uci.ics.jung.graph.DirectedEdge;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.SparseVertex;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.utils.PredicateUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MultiHashMap;
import org.apache.commons.collections.MultiMap;

public class GraphCollapser {
    protected static GraphCollapser instance = null;

    public static GraphCollapser getInstance() {
        if (instance == null) {
            instance = new GraphCollapser();
        }
        return instance;
    }

    protected GraphCollapser() {
    }

    public Graph getCollapsedGraph(EquivalenceRelation equivalence) {
        Graph g = equivalence.getGraph();
        Graph copy = (Graph)g.copy();
        HashMap superVertices = new HashMap();
        this.replaceEquivalencesWithCollapsedVertices(equivalence, copy, superVertices);
        HashSet<CollapsedVertex> coveredCV = new HashSet<CollapsedVertex>();
        Iterator iter = superVertices.values().iterator();
        while (iter.hasNext()) {
            CollapsedVertex cv = (CollapsedVertex)iter.next();
            MultiMap vertices_to_edges = this.findEdgesAndVerticesConnectedToRootSet(cv.getRootSet());
            this.collapseVerticesIntoSuperVertices(equivalence, superVertices, vertices_to_edges);
            this.createEdgesCorrespondingToMap(copy, cv, vertices_to_edges, coveredCV);
            coveredCV.add(cv);
        }
        return copy;
    }

    protected void createEdgesCorrespondingToMap(Graph copy, CollapsedVertex cv, MultiMap vertices_to_edges, Set coveredCV) {
        Iterator iter = vertices_to_edges.keySet().iterator();
        while (iter.hasNext()) {
            Vertex edgeDestination = (Vertex)iter.next();
            if (coveredCV.contains(edgeDestination)) continue;
            HashSet relevantEdges = new HashSet((Collection)vertices_to_edges.get((Object)edgeDestination));
            if (!this.shouldAddEdge(edgeDestination = (Vertex)edgeDestination.getEqualVertex(copy), cv.getRootSet(), relevantEdges)) continue;
            if (PredicateUtils.enforcesEdgeConstraint(copy, Graph.DIRECTED_EDGE)) {
                this.createDirectedEdges(copy, cv, edgeDestination, relevantEdges);
                continue;
            }
            if (PredicateUtils.enforcesEdgeConstraint(copy, Graph.UNDIRECTED_EDGE)) {
                this.createUndirectedEdge(copy, cv, edgeDestination, relevantEdges);
                continue;
            }
            throw new IllegalArgumentException("Mixed (directed/undirected) graphs not currently supported");
        }
    }

    protected void collapseVerticesIntoSuperVertices(EquivalenceRelation er, Map superVertices, MultiMap vertices_to_edges) {
        HashSet vertices = new HashSet(vertices_to_edges.keySet());
        Iterator destinations = vertices.iterator();
        while (destinations.hasNext()) {
            Vertex dest = (Vertex)destinations.next();
            Set destSet = er.getEquivalenceRelationContaining(dest);
            if (destSet == null) continue;
            CollapsedVertex superV = (CollapsedVertex)superVertices.get(destSet);
            this.replaceWith(vertices_to_edges, dest, superV);
        }
    }

    protected void replaceWith(MultiMap m, Vertex dest, CollapsedVertex superV) {
        Collection c = (Collection)m.get((Object)dest);
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            m.put((Object)superV, iter.next());
        }
        m.remove((Object)dest);
    }

    protected void replaceEquivalencesWithCollapsedVertices(EquivalenceRelation er, Graph copy, Map superVertices) {
        Iterator iter = er.getAllEquivalences();
        while (iter.hasNext()) {
            Set rootSet = (Set)iter.next();
            CollapsedVertex superVertex = this.createCollapsedVertex(copy, rootSet);
            Iterator iter2 = rootSet.iterator();
            while (iter2.hasNext()) {
                Vertex v = (Vertex)iter2.next();
                copy.removeVertex((Vertex)v.getEqualVertex(copy));
            }
            this.annotateVertex(superVertex, rootSet);
            superVertices.put(rootSet, superVertex);
        }
    }

    public Graph getCollapsedGraph(Graph g, Set rootSet) {
        Graph copy = (Graph)g.copy();
        Iterator iter = rootSet.iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            copy.removeVertex((Vertex)v.getEqualVertex(copy));
        }
        CollapsedVertex superVertex = this.createCollapsedVertex(copy, rootSet);
        this.annotateVertex(superVertex, rootSet);
        MultiMap vertices_to_edges = this.findEdgesAndVerticesConnectedToRootSet(superVertex.getRootSet());
        Iterator iter2 = vertices_to_edges.keySet().iterator();
        while (iter2.hasNext()) {
            Vertex opposite = (Vertex)iter2.next();
            opposite = (Vertex)opposite.getEqualVertex(copy);
            HashSet relevantEdges = new HashSet((Collection)vertices_to_edges.get((Object)opposite));
            if (!this.shouldAddEdge(opposite, superVertex.getRootSet(), relevantEdges)) continue;
            if (PredicateUtils.enforcesEdgeConstraint(g, Graph.DIRECTED_EDGE)) {
                this.createDirectedEdges(copy, superVertex, opposite, relevantEdges);
                continue;
            }
            if (PredicateUtils.enforcesEdgeConstraint(g, Graph.UNDIRECTED_EDGE)) {
                this.createUndirectedEdge(copy, superVertex, opposite, relevantEdges);
                continue;
            }
            throw new IllegalArgumentException("Mixed (directed/undirected graphs not currently supported");
        }
        return copy;
    }

    protected void annotateVertex(CollapsedVertex superVertex, Set rootSet) {
    }

    protected void annotateEdge(CollapsedEdge newEdge, Collection edgesFromWhichWeMightDeriveData) {
    }

    protected CollapsedVertex createCollapsedVertex(Graph g, Set rootSet) {
        return (CollapsedVertex)g.addVertex(new CollapsedSparseVertex(rootSet));
    }

    protected void createUndirectedEdge(Graph g, CollapsedVertex superVertex, Vertex opposite, Set relevantEdges) {
        CollapsedEdge newEdge = (CollapsedEdge)g.addEdge(new UndirectedCollapsedEdge(opposite, superVertex, relevantEdges));
        this.annotateEdge(newEdge, relevantEdges);
    }

    protected void createDirectedEdges(Graph graph, CollapsedVertex superVertex, Vertex opposite, Set relevantEdges) {
        CollapsedEdge newEdge;
        HashSet<DirectedEdge> oppositeToSup = new HashSet<DirectedEdge>();
        HashSet<DirectedEdge> supToOpposite = new HashSet<DirectedEdge>();
        Iterator iterator = relevantEdges.iterator();
        while (iterator.hasNext()) {
            DirectedEdge de = (DirectedEdge)iterator.next();
            if (superVertex.getRootSet().contains(de.getSource())) {
                supToOpposite.add(de);
                continue;
            }
            oppositeToSup.add(de);
        }
        if (oppositeToSup.size() > 0) {
            newEdge = (CollapsedEdge)graph.addEdge(new DirectedCollapsedEdge(opposite, superVertex, oppositeToSup));
            this.annotateEdge(newEdge, oppositeToSup);
        }
        if (supToOpposite.size() > 0) {
            newEdge = (CollapsedEdge)graph.addEdge(new DirectedCollapsedEdge(superVertex, opposite, supToOpposite));
            this.annotateEdge(newEdge, supToOpposite);
        }
    }

    protected MultiMap findEdgesAndVerticesConnectedToRootSet(Set rootSet) {
        MultiHashMap vertices_to_edges = new MultiHashMap();
        Iterator iter = rootSet.iterator();
        while (iter.hasNext()) {
            Vertex v = (Vertex)iter.next();
            Iterator iterator = v.getIncidentEdges().iterator();
            while (iterator.hasNext()) {
                Edge e = (Edge)iterator.next();
                Vertex other = e.getOpposite(v);
                if (rootSet.contains(other)) continue;
                vertices_to_edges.put((Object)other, (Object)e);
            }
        }
        return vertices_to_edges;
    }

    protected boolean shouldAddEdge(Vertex opposite, Set rootSet, Collection edges) {
        return true;
    }

    public static class DirectedCollapsedEdge
    extends DirectedSparseEdge
    implements CollapsedEdge {
        private Set relevantEdges;

        public DirectedCollapsedEdge(Vertex opposite, Vertex superVertex, Set relevantEdges) {
            super(opposite, superVertex);
            this.relevantEdges = relevantEdges;
        }

        public Set getRelevantEdges() {
            return this.relevantEdges;
        }
    }

    public static class UndirectedCollapsedEdge
    extends UndirectedSparseEdge
    implements CollapsedEdge {
        private Set relevantEdges;

        public UndirectedCollapsedEdge(Vertex opposite, Vertex superVertex, Set relevantEdges) {
            super(opposite, superVertex);
            this.relevantEdges = relevantEdges;
        }

        public Set getRelevantEdges() {
            return this.relevantEdges;
        }
    }

    public static interface CollapsedEdge
    extends Edge {
        public Set getRelevantEdges();
    }

    public static class CollapsedSparseVertex
    extends SparseVertex
    implements CollapsedVertex {
        private Set rootSet;

        public CollapsedSparseVertex(Set rootSet) {
            this.rootSet = rootSet;
        }

        public String toString() {
            return super.toString() + ":" + this.rootSet;
        }

        public Set getRootSet() {
            return this.rootSet;
        }
    }

    public static interface CollapsedVertex
    extends Vertex {
        public Set getRootSet();
    }
}

