/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import edu.uci.ics.jung.algorithms.shortestpath.DijkstraDistance;
import edu.uci.ics.jung.algorithms.shortestpath.ShortestPath;
import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.NumberEdgeValue;
import edu.uci.ics.jung.utils.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DijkstraShortestPath
extends DijkstraDistance
implements ShortestPath {
    public DijkstraShortestPath(ArchetypeGraph g, NumberEdgeValue nev, boolean cached) {
        super(g, nev, cached);
    }

    public DijkstraShortestPath(ArchetypeGraph g, NumberEdgeValue nev) {
        super(g, nev);
    }

    public DijkstraShortestPath(ArchetypeGraph g) {
        super(g);
    }

    public DijkstraShortestPath(ArchetypeGraph g, boolean cached) {
        super(g, cached);
    }

    protected DijkstraDistance.SourceData getSourceData(ArchetypeVertex source) {
        SourcePathData sd = (SourcePathData)this.sourceMap.get(source);
        if (sd == null) {
            sd = new SourcePathData(source);
        }
        return sd;
    }

    public Edge getIncomingEdge(Vertex source, Vertex target) {
        if (source.getGraph() != this.g) {
            throw new IllegalArgumentException("Specified source vertex " + source + " is not part of graph " + this.g);
        }
        if (target.getGraph() != this.g) {
            throw new IllegalArgumentException("Specified target vertex " + target + " is not part of graph " + this.g);
        }
        HashSet<Vertex> targets = new HashSet<Vertex>();
        targets.add(target);
        this.singleSourceShortestPath(source, targets, this.g.numVertices());
        LinkedHashMap incomingEdgeMap = ((SourcePathData)this.sourceMap.get((Object)source)).incomingEdges;
        Edge incomingEdge = (Edge)incomingEdgeMap.get(target);
        if (!this.cached) {
            this.reset(source);
        }
        return incomingEdge;
    }

    public Map getIncomingEdgeMap(Vertex source) {
        return this.getIncomingEdgeMap(source, this.g.numVertices());
    }

    public List getPath(Vertex source, Vertex target) {
        LinkedList<Edge> path = new LinkedList<Edge>();
        HashSet<Vertex> targets = new HashSet<Vertex>();
        targets.add(target);
        this.singleSourceShortestPath(source, targets, this.g.numVertices());
        LinkedHashMap incomingEdges = ((SourcePathData)this.sourceMap.get((Object)source)).incomingEdges;
        if (incomingEdges.isEmpty() || incomingEdges.get(target) == null) {
            return path;
        }
        Vertex current = target;
        while (current != source) {
            Edge incoming = (Edge)incomingEdges.get(current);
            path.addFirst(incoming);
            current = incoming.getOpposite(current);
        }
        return path;
    }

    public LinkedHashMap getIncomingEdgeMap(Vertex source, int numDests) {
        if (source.getGraph() != this.g) {
            throw new IllegalArgumentException("Specified source vertex " + source + " is not part of graph " + this.g);
        }
        if (numDests < 1 || numDests > this.g.numVertices()) {
            throw new IllegalArgumentException("numDests must be >= 1 and <= g.numVertices()");
        }
        this.singleSourceShortestPath(source, null, numDests);
        LinkedHashMap incomingEdgeMap = ((SourcePathData)this.sourceMap.get((Object)source)).incomingEdges;
        if (!this.cached) {
            this.reset(source);
        }
        return incomingEdgeMap;
    }

    protected class SourcePathData
    extends DijkstraDistance.SourceData {
        public Map tentativeIncomingEdges;
        public LinkedHashMap incomingEdges = new LinkedHashMap();

        public SourcePathData(ArchetypeVertex source) {
            super(source);
            this.tentativeIncomingEdges = new HashMap();
        }

        public void update(ArchetypeVertex dest, ArchetypeEdge tentative_edge, double new_dist) {
            super.update(dest, tentative_edge, new_dist);
            this.tentativeIncomingEdges.put(dest, tentative_edge);
        }

        public Pair getNextVertex() {
            Pair p = super.getNextVertex();
            ArchetypeVertex v = (ArchetypeVertex)p.getFirst();
            Edge incoming = (Edge)this.tentativeIncomingEdges.remove(v);
            this.incomingEdges.put(v, incoming);
            return p;
        }

        public void createRecord(ArchetypeVertex w, ArchetypeEdge e, double new_dist) {
            super.createRecord(w, e, new_dist);
            this.tentativeIncomingEdges.put(w, e);
        }
    }
}

