/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.transformation;

import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.DirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.DirectedSparseGraph;
import edu.uci.ics.jung.graph.impl.UndirectedSparseEdge;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.utils.TypedVertexGenerator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DirectionTransformer {
    public static UndirectedGraph toUndirected(Graph graph) {
        return DirectionTransformer.toUndirected(graph, true);
    }

    public static UndirectedGraph toUndirected(Graph graph, boolean copy) {
        UndirectedSparseGraph uGraph = new UndirectedSparseGraph();
        uGraph.importUserData(graph);
        Map vertex_map = DirectionTransformer.convertVertices(graph, uGraph, copy);
        Iterator eIt = graph.getEdges().iterator();
        while (eIt.hasNext()) {
            Vertex uv2;
            Edge e = (Edge)eIt.next();
            Vertex dv1 = (Vertex)e.getEndpoints().getFirst();
            Vertex dv2 = (Vertex)e.getEndpoints().getSecond();
            Vertex uv1 = (Vertex)vertex_map.get(dv1);
            if (uv1.isNeighborOf(uv2 = (Vertex)vertex_map.get(dv2))) continue;
            Edge uEdge = uGraph.addEdge(new UndirectedSparseEdge(uv1, uv2));
            uEdge.importUserData(e);
        }
        return uGraph;
    }

    protected static Map convertVertices(Graph old, Graph transformed, boolean copy) {
        TypedVertexGenerator vg = new TypedVertexGenerator(transformed);
        HashMap<Vertex, Vertex> vertex_map = new HashMap<Vertex, Vertex>();
        Iterator iter = old.getVertices().iterator();
        while (iter.hasNext()) {
            Vertex v_t;
            Vertex v = (Vertex)iter.next();
            if (copy) {
                v_t = (Vertex)v.copy(transformed);
            } else {
                v_t = transformed.addVertex(vg.create());
                v_t.importUserData(v);
            }
            vertex_map.put(v, v_t);
        }
        return vertex_map;
    }

    public static DirectedGraph toDirected(Graph graph) {
        return DirectionTransformer.toDirected(graph, true);
    }

    public static DirectedGraph toDirected(Graph graph, boolean copy) {
        DirectedSparseGraph dGraph = new DirectedSparseGraph();
        dGraph.importUserData(graph);
        Map vertex_map = DirectionTransformer.convertVertices(graph, dGraph, copy);
        Iterator eIt = graph.getEdges().iterator();
        while (eIt.hasNext()) {
            Edge dEdge;
            Edge e = (Edge)eIt.next();
            Vertex uv1 = (Vertex)e.getEndpoints().getFirst();
            Vertex uv2 = (Vertex)e.getEndpoints().getSecond();
            Vertex dv1 = (Vertex)vertex_map.get(uv1);
            Vertex dv2 = (Vertex)vertex_map.get(uv2);
            if (uv1.isPredecessorOf(uv2) && !dv1.isPredecessorOf(dv2)) {
                dEdge = dGraph.addEdge(new DirectedSparseEdge(dv1, dv2));
                dEdge.importUserData(e);
            }
            if (!uv2.isPredecessorOf(uv1) || dv2.isPredecessorOf(dv1)) continue;
            dEdge = dGraph.addEdge(new DirectedSparseEdge(dv2, dv1));
            dEdge.importUserData(e);
        }
        return dGraph;
    }
}

