/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.graph.ArchetypeEdge;
import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.ArchetypeVertex;
import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Hyperedge;
import edu.uci.ics.jung.graph.Hypervertex;
import edu.uci.ics.jung.graph.impl.AbstractHyperUnitBPG;
import edu.uci.ics.jung.graph.impl.BipartiteEdge;
import edu.uci.ics.jung.graph.impl.BipartiteGraph;
import edu.uci.ics.jung.graph.impl.BipartiteVertex;
import edu.uci.ics.jung.graph.impl.HypergraphBPG;
import edu.uci.ics.jung.graph.impl.HypervertexBPG;
import java.util.Set;

public class HyperedgeBPG
extends AbstractHyperUnitBPG
implements Hyperedge {
    public HyperedgeBPG() {
    }

    HyperedgeBPG(BipartiteVertex bpv, HypergraphBPG hypergraphBPG) {
        super(bpv, hypergraphBPG);
    }

    public Set getIncidentElements() {
        return this.getIncidentVertices();
    }

    public Set getIncidentVertices() {
        return this.graph.translateUnderlyingVertices(this.vertex.getNeighbors());
    }

    public ArchetypeEdge getEqualEdge(ArchetypeGraph g) {
        HypergraphBPG bpg = (HypergraphBPG)g;
        return bpg.getEdgeCorrespondingTo(this.underlying_vertex());
    }

    public ArchetypeEdge getEquivalentEdge(ArchetypeGraph g) {
        return this.getEqualEdge(g);
    }

    public int numVertices() {
        return this.vertex.degree();
    }

    public boolean isIncident(ArchetypeVertex v) {
        HypervertexBPG hv = (HypervertexBPG)v;
        return this.vertex.isNeighborOf(hv.underlying_vertex());
    }

    public ArchetypeEdge copy(ArchetypeGraph g) {
        HypergraphBPG hg = (HypergraphBPG)g;
        HyperedgeBPG he = new HyperedgeBPG();
        hg.addEdge(he);
        he.importUserData(this);
        return he;
    }

    public boolean connectVertex(Hypervertex hv3_x) {
        BipartiteVertex v2;
        HypervertexBPG hv3 = (HypervertexBPG)hv3_x;
        BipartiteGraph bpg = (BipartiteGraph)hv3.underlying_vertex().getGraph();
        BipartiteVertex v1 = hv3.underlying_vertex();
        if (v1.isNeighborOf(v2 = this.underlying_vertex())) {
            return false;
        }
        bpg.addBipartiteEdge(new BipartiteEdge(v1, v2));
        return true;
    }

    public boolean disconnectVertex(Hypervertex v) {
        BipartiteVertex v2;
        HypervertexBPG hv3 = (HypervertexBPG)v;
        BipartiteGraph bpg = (BipartiteGraph)hv3.underlying_vertex().getGraph();
        BipartiteVertex v1 = hv3.underlying_vertex();
        Edge e = v1.findEdge(v2 = this.underlying_vertex());
        if (e != null) {
            bpg.removeEdge(e);
            return true;
        }
        return false;
    }
}

