/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import edu.uci.ics.jung.graph.Hyperedge;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.Hypervertex;
import edu.uci.ics.jung.graph.impl.SetHyperedge;
import edu.uci.ics.jung.graph.impl.SetHypergraph;
import edu.uci.ics.jung.graph.impl.SetHypervertex;
import edu.uci.ics.jung.utils.UserData;
import edu.uci.ics.jung.utils.UserDataContainer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;

public class HypergraphReader {
    public static final Object LABEL = "edu.ics.uci.jung.io.HypergraphReader.LABEL";
    protected boolean verbose = false;
    protected boolean as_list;
    protected boolean edge_first;
    protected UserDataContainer.CopyAction copy_action;

    public HypergraphReader(boolean as_list, boolean edge_first, UserDataContainer.CopyAction copy_action) {
        this.as_list = as_list;
        this.edge_first = edge_first;
        this.copy_action = copy_action;
    }

    public HypergraphReader() {
        this(false, false, UserData.SHARED);
    }

    public Hypergraph load(Reader reader) throws IOException {
        String curLine;
        SetHypergraph h = new SetHypergraph();
        BufferedReader br = new BufferedReader(reader);
        HashMap<String, Hypervertex> vertex_names = new HashMap<String, Hypervertex>();
        HashMap<String, Hyperedge> edge_names = new HashMap<String, Hyperedge>();
        while (br.ready() && (curLine = br.readLine()) != null && !curLine.equals("end_of_file")) {
            int i;
            if (curLine.trim().length() == 0) continue;
            String[] parts = this.as_list ? curLine.trim().split("\\s+") : curLine.trim().split("\\s+", 2);
            if (this.edge_first) {
                Hyperedge e = (Hyperedge)edge_names.get(parts[0]);
                if (e == null) {
                    e = new SetHyperedge();
                    h.addEdge(e);
                    edge_names.put(parts[0], e);
                    e.addUserDatum(LABEL, parts[0], this.copy_action);
                }
                for (i = 1; i < parts.length; ++i) {
                    Hypervertex v = (Hypervertex)vertex_names.get(parts[i]);
                    if (v == null) {
                        v = new SetHypervertex();
                        h.addVertex(v);
                        vertex_names.put(parts[i], v);
                        v.addUserDatum(LABEL, parts[i], this.copy_action);
                    }
                    if (!e.isIncident(v)) {
                        e.connectVertex(v);
                        continue;
                    }
                    if (!this.verbose) continue;
                    System.out.println("duplicate line: " + curLine);
                }
                continue;
            }
            Hypervertex v = (Hypervertex)vertex_names.get(parts[0]);
            if (v == null) {
                v = new SetHypervertex();
                h.addVertex(v);
                vertex_names.put(parts[0], v);
                v.addUserDatum(LABEL, parts[0], this.copy_action);
            }
            for (i = 1; i < parts.length; ++i) {
                Hyperedge e = (Hyperedge)edge_names.get(parts[i]);
                if (e == null) {
                    e = new SetHyperedge();
                    h.addEdge(e);
                    edge_names.put(parts[i], e);
                    e.addUserDatum(LABEL, parts[i], this.copy_action);
                }
                if (!e.isIncident(v)) {
                    e.connectVertex(v);
                    continue;
                }
                if (!this.verbose) continue;
                System.out.println("duplicate line: " + curLine);
            }
        }
        return h;
    }

    public void setVerboseMode(boolean b) {
        this.verbose = b;
    }
}

