/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.random.generators;

import edu.uci.ics.jung.graph.ArchetypeGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.decorators.Indexer;
import edu.uci.ics.jung.graph.impl.UndirectedSparseGraph;
import edu.uci.ics.jung.random.generators.GraphGenerator;
import edu.uci.ics.jung.utils.GraphUtils;

public class Lattice1DGenerator
implements GraphGenerator {
    private int mNumNodes;
    private boolean mIsToroidal;

    public Lattice1DGenerator(int numNodes, boolean isToroidal) {
        if (numNodes < 1) {
            throw new IllegalArgumentException("Lattice size must be at least 1.");
        }
        this.mNumNodes = numNodes;
        this.mIsToroidal = isToroidal;
    }

    public ArchetypeGraph generateGraph() {
        UndirectedSparseGraph g = new UndirectedSparseGraph();
        GraphUtils.addVertices((Graph)g, this.mNumNodes);
        int upI = 0;
        Indexer id = Indexer.getIndexer(g);
        for (int i = 0; i < this.mNumNodes; ++i) {
            for (int s = 1; s <= 1; ++s) {
                Vertex ithVertex = (Vertex)id.getVertex(i);
                upI = this.upIndex(i, s);
                if (i == this.mNumNodes - 1 && (i != this.mNumNodes - 1 || !this.mIsToroidal)) continue;
                GraphUtils.addEdge(g, ithVertex, (Vertex)id.getVertex(upI));
            }
        }
        return g;
    }

    protected int downIndex(int currentIndex, int numSteps) {
        if (currentIndex - numSteps < 0) {
            return this.mNumNodes - 1 + (currentIndex - numSteps);
        }
        return currentIndex + numSteps;
    }

    protected int upIndex(int currentIndex, int numSteps) {
        if (currentIndex + numSteps > this.mNumNodes - 1) {
            return numSteps - (this.mNumNodes - currentIndex);
        }
        return currentIndex + numSteps;
    }
}

