/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.visualization.GraphLabelRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class DefaultGraphLabelRenderer
extends JLabel
implements GraphLabelRenderer,
Serializable {
    protected static Border noFocusBorder = new EmptyBorder(0, 0, 0, 0);
    protected Color pickedVertexLabelColor = Color.black;
    protected Color pickedEdgeLabelColor = Color.black;
    protected boolean rotateEdgeLabels;

    public DefaultGraphLabelRenderer(Color pickedVertexLabelColor, Color pickedEdgeLabelColor) {
        this(pickedVertexLabelColor, pickedEdgeLabelColor, true);
    }

    public DefaultGraphLabelRenderer(Color pickedVertexLabelColor, Color pickedEdgeLabelColor, boolean rotateEdgeLabels) {
        this.pickedVertexLabelColor = pickedVertexLabelColor;
        this.pickedEdgeLabelColor = pickedEdgeLabelColor;
        this.rotateEdgeLabels = rotateEdgeLabels;
        this.setOpaque(true);
        this.setBorder(noFocusBorder);
    }

    public boolean isRotateEdgeLabels() {
        return this.rotateEdgeLabels;
    }

    public void setRotateEdgeLabels(boolean rotateEdgeLabels) {
        this.rotateEdgeLabels = rotateEdgeLabels;
    }

    public void setForeground(Color c) {
        super.setForeground(c);
    }

    public void setBackground(Color c) {
        super.setBackground(c);
    }

    public void updateUI() {
        super.updateUI();
        this.setForeground(null);
        this.setBackground(null);
    }

    public Component getGraphLabelRendererComponent(JComponent vv, Object value, boolean isSelected, Vertex vertex) {
        super.setForeground(vv.getForeground());
        if (isSelected) {
            this.setForeground(this.pickedVertexLabelColor);
        }
        super.setBackground(vv.getBackground());
        this.setFont(vv.getFont());
        this.setIcon(null);
        this.setBorder(noFocusBorder);
        this.setValue(value);
        return this;
    }

    public Component getGraphLabelRendererComponent(JComponent vv, Object value, boolean isSelected, Edge edge) {
        super.setForeground(vv.getForeground());
        if (isSelected) {
            this.setForeground(this.pickedEdgeLabelColor);
        }
        super.setBackground(vv.getBackground());
        this.setFont(vv.getFont());
        this.setIcon(null);
        this.setBorder(noFocusBorder);
        this.setValue(value);
        return this;
    }

    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long tm, int x, int y, int width, int height) {
    }

    public void repaint(Rectangle r) {
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName == "text") {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    protected void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }
}

