/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.control;

import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.TranslatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.HyperbolicTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;

public class HyperbolicTranslatingGraphMousePlugin
extends TranslatingGraphMousePlugin
implements MouseListener,
MouseMotionListener {
    protected boolean dragOnLens;
    protected boolean dragOnEdge;
    protected double edgeOffset;

    public HyperbolicTranslatingGraphMousePlugin() {
        this(16);
    }

    public HyperbolicTranslatingGraphMousePlugin(int modifiers) {
        super(modifiers);
    }

    public void mousePressed(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            vv.setCursor(Cursor.getPredefinedCursor(13));
            this.testViewCenter(vv.getLayoutTransformer(), e.getPoint());
            this.testViewCenter(vv.getViewTransformer(), e.getPoint());
            vv.repaint();
        }
        super.mousePressed(e);
    }

    private void setViewCenter(MutableTransformer transformer, Point2D point) {
        if (transformer instanceof HyperbolicTransformer) {
            HyperbolicTransformer ht = (HyperbolicTransformer)transformer;
            ht.setViewCenter(point);
        }
    }

    private void setViewRadius(MutableTransformer transformer, Point2D point) {
        if (transformer instanceof HyperbolicTransformer) {
            HyperbolicTransformer ht = (HyperbolicTransformer)transformer;
            double distanceFromCenter = ht.getDistanceFromCenter(point);
            ht.setViewRadius(distanceFromCenter + this.edgeOffset);
        }
    }

    private void testViewCenter(MutableTransformer transformer, Point2D point) {
        if (transformer instanceof HyperbolicTransformer) {
            HyperbolicTransformer ht = (HyperbolicTransformer)transformer;
            double distanceFromCenter = ht.getDistanceFromCenter(point);
            if (distanceFromCenter < 10.0) {
                ht.setViewCenter(point);
                this.dragOnLens = true;
            } else if (Math.abs(distanceFromCenter - ht.getViewRadius()) < 10.0) {
                this.edgeOffset = ht.getViewRadius() - distanceFromCenter;
                ht.setViewRadius(distanceFromCenter + this.edgeOffset);
                this.dragOnEdge = true;
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.dragOnLens = false;
        this.dragOnEdge = false;
        this.edgeOffset = 0.0;
    }

    public void mouseDragged(MouseEvent e) {
        VisualizationViewer vv = (VisualizationViewer)e.getSource();
        boolean accepted = this.checkModifiers(e);
        if (accepted) {
            MutableTransformer modelTransformer = vv.getLayoutTransformer();
            vv.setCursor(Cursor.getPredefinedCursor(13));
            if (this.dragOnLens) {
                this.setViewCenter(modelTransformer, vv.inverseViewTransform(e.getPoint()));
                this.setViewCenter(vv.getViewTransformer(), e.getPoint());
                e.consume();
                vv.repaint();
            } else if (this.dragOnEdge) {
                this.setViewRadius(modelTransformer, e.getPoint());
                this.setViewRadius(vv.getViewTransformer(), e.getPoint());
                e.consume();
                vv.repaint();
            } else {
                super.mouseDragged(e);
            }
        }
    }
}

