/*
 * Decompiled with CFR 0.152.
 */
package samples.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.decorators.DefaultToolTipFunction;
import edu.uci.ics.jung.graph.decorators.EdgeShape;
import edu.uci.ics.jung.graph.decorators.PickableEdgePaintFunction;
import edu.uci.ics.jung.utils.TestGraphs;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.FRLayout;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.PickedState;
import edu.uci.ics.jung.visualization.PluggableRenderer;
import edu.uci.ics.jung.visualization.Renderer;
import edu.uci.ics.jung.visualization.ShapePickSupport;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.transform.HyperbolicLayoutLensSupport;
import edu.uci.ics.jung.visualization.transform.HyperbolicLensSupport;
import edu.uci.ics.jung.visualization.transform.shape.HyperbolicViewLensSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class HyperbolicLensDemo
extends JApplet {
    Graph graph = TestGraphs.getOneComponentGraph();
    VisualizationViewer vv;
    HyperbolicLensSupport viewSupport;
    HyperbolicLensSupport layoutSupport;

    public HyperbolicLensDemo() {
        PluggableRenderer pr = new PluggableRenderer();
        FRLayout layout = new FRLayout(this.graph);
        layout.setMaxIterations(1000);
        Dimension preferredSize = new Dimension(400, 400);
        DefaultVisualizationModel visualizationModel = new DefaultVisualizationModel(layout, preferredSize);
        this.vv = new VisualizationViewer(visualizationModel, (Renderer)pr, preferredSize);
        this.vv.setPickSupport(new ShapePickSupport());
        pr.setEdgeShapeFunction(new EdgeShape.QuadCurve());
        PickedState ps = this.vv.getPickedState();
        pr.setEdgePaintFunction(new PickableEdgePaintFunction(ps, Color.black, Color.red));
        this.vv.setBackground(Color.white);
        this.vv.setToolTipFunction(new DefaultToolTipFunction());
        Container content = this.getContentPane();
        GraphZoomScrollPane gzsp = new GraphZoomScrollPane(this.vv);
        content.add(gzsp);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        this.viewSupport = new HyperbolicViewLensSupport(this.vv);
        this.layoutSupport = new HyperbolicLayoutLensSupport(this.vv);
        this.layoutSupport.getHyperbolicTransformer().setEllipse(this.viewSupport.getHyperbolicTransformer().getEllipse());
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(HyperbolicLensDemo.this.vv, 1.1f, HyperbolicLensDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(HyperbolicLensDemo.this.vv, 0.9f, HyperbolicLensDemo.this.vv.getCenter());
            }
        });
        ButtonGroup radio = new ButtonGroup();
        JRadioButton normal = new JRadioButton("None");
        normal.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (HyperbolicLensDemo.this.viewSupport != null) {
                        HyperbolicLensDemo.this.viewSupport.deactivate();
                    }
                    if (HyperbolicLensDemo.this.layoutSupport != null) {
                        HyperbolicLensDemo.this.layoutSupport.deactivate();
                    }
                }
            }
        });
        JRadioButton hyperView = new JRadioButton("In View");
        hyperView.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HyperbolicLensDemo.this.viewSupport.activate(e.getStateChange() == 1);
            }
        });
        JRadioButton hyperModel = new JRadioButton("In Layout");
        hyperModel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HyperbolicLensDemo.this.layoutSupport.activate(e.getStateChange() == 1);
            }
        });
        radio.add(normal);
        radio.add(hyperModel);
        radio.add(hyperView);
        normal.setSelected(true);
        graphMouse.addItemListener(this.layoutSupport.getHyperbolicGraphMouse().getModeListener());
        graphMouse.addItemListener(this.viewSupport.getHyperbolicGraphMouse().getModeListener());
        JMenuBar menubar = new JMenuBar();
        menubar.add(graphMouse.getModeMenu());
        gzsp.setCorner(menubar);
        JPanel controls = new JPanel();
        JPanel zoomControls = new JPanel(new GridLayout(2, 1));
        zoomControls.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel hyperControls = new JPanel(new GridLayout(2, 2));
        hyperControls.setBorder(BorderFactory.createTitledBorder("Hyperbolic Lens"));
        zoomControls.add(plus);
        zoomControls.add(minus);
        hyperControls.add(normal);
        hyperControls.add(hyperModel);
        hyperControls.add(hyperView);
        controls.add(zoomControls);
        controls.add(hyperControls);
        content.add((Component)controls, "South");
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new HyperbolicLensDemo());
        f.pack();
        f.setVisible(true);
    }
}

