/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.settings;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.PluginExtension;

public class ExtAppExtension
extends PluginExtension
implements ItemListener {
    private static final long serialVersionUID = 1L;
    private JTextField fileName;
    private JButton chooseFile;
    private JLabel fileNameLabel;
    private JFileChooser fileChooser;
    private static final int LINUX = 0;
    private static final int WINDOWS = 1;
    private static final int OTHER = 2;
    private int OS = 0;
    private String defaultWindows;
    private String defaultLinux;
    private String fileExt;

    public ExtAppExtension(String desc, String fileExt, String defaultWindows, String defaultLinux) {
        super(desc);
        this.fileExt = fileExt;
        this.defaultWindows = defaultWindows;
        this.defaultLinux = defaultLinux;
        String system = System.getProperty("os.name").toLowerCase();
        this.OS = system.startsWith("linux") ? 0 : (system.startsWith("win") ? 1 : 2);
        this.chooseFile = new JButton(new AbstractAction("..."){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                ExtAppExtension.this.fileChooser = new JFileChooser(ExtAppExtension.this.fileName.getText());
                ExtAppExtension.this.fileChooser.setFileSelectionMode(0);
                ExtAppExtension.this.fileChooser.showOpenDialog(ExtAppExtension.this.getParent());
                if (ExtAppExtension.this.fileChooser.getSelectedFile() != null) {
                    ExtAppExtension.this.fileName.setText(ExtAppExtension.this.fileChooser.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.fileNameLabel = new JLabel(String.valueOf(Translatrix.getTranslationString((String)"extApp.chooseApp")) + ":");
        this.fileName = new JTextField();
        this.fileName.setEditable(false);
        CellConstraints cc = new CellConstraints();
        FormLayout fileLayout = new FormLayout("55dlu, 2dlu, pref:grow, 2dlu, 40dlu, 2dlu, 20dlu, 2dlu, 30dlu", "pref, 2dlu, pref, 2dlu");
        this.setLayout((LayoutManager)fileLayout);
        JPanel fileChooserPanel = new JPanel(new BorderLayout());
        fileChooserPanel.add((Component)this.fileName, "Center");
        fileChooserPanel.add((Component)this.chooseFile, "East");
        this.add((Component)this.fileNameLabel, cc.xy(1, 3));
        this.add((Component)fileChooserPanel, cc.xyw(3, 3, 7));
    }

    protected void extensionAdded() {
        switch (this.OS) {
            case 0: {
                this.setStationary(this.fileExt, this.defaultLinux);
                break;
            }
            case 1: {
                this.setStationary(this.fileExt, this.defaultWindows);
                break;
            }
            default: {
                this.setStationary(this.fileExt, this.defaultLinux);
            }
        }
    }

    public void revertToDefaults() {
        this.setValue(this.fileExt, this.getDefault(this.fileExt));
        this.reflectSettings();
    }

    public void updateSettings() {
        this.setValue(this.fileExt, this.fileName.getText());
    }

    public void reflectSettings() {
        this.fileName.setText((String)this.getValue(this.fileExt));
    }

    public void itemStateChanged(ItemEvent e) {
    }
}

