/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.DefaultPersistenceDelegate;
import java.net.URL;
import java.util.Locale;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingsPlugin;

public class I18nPlugin
extends SettingsPlugin {
    private static final long serialVersionUID = 1L;
    private JPanel languagePanel;
    private JList listLanguages;
    private JLabel desc;
    private JLabel label;
    private FormLayout layout;
    private boolean listInsteadComboBox = false;
    private JComboBox cbLanguages;

    public I18nPlugin(String p_Name) {
        super(p_Name);
        this.buildPanel();
    }

    public I18nPlugin(String p_Name, boolean listInsteadComboBox) {
        super(p_Name);
        this.listInsteadComboBox = listInsteadComboBox;
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLabel(Translatrix.getTranslationString((String)"i18n.Label"));
        if (Translatrix.getLocale() != null) {
            this.setStationary("Locale", Translatrix.getLocale());
        } else {
            this.setStationary("Locale", Locale.getDefault());
        }
        this.layout = this.listInsteadComboBox ? new FormLayout("right:50dlu,5dlu,fill:60dlu:grow,5dlu", "center:pref,5dlu,pref,5dlu,60dlu,5dlu") : new FormLayout("right:50dlu,5dlu,fill:70dlu,5dlu:grow", "center:pref,5dlu,pref,5dlu");
        CellConstraints cc = new CellConstraints();
        this.languagePanel = this.createSubPanel(Translatrix.getTranslationString((String)"i18n.LanguageTitle"));
        this.languagePanel.setLayout((LayoutManager)this.layout);
        PanelBuilder pBuilder = new PanelBuilder(this.layout, this.languagePanel);
        this.desc = new JLabel();
        this.desc.setText(Translatrix.getTranslationString((String)"i18n.Description"));
        pBuilder.add((Component)this.desc, cc.xyw(1, 1, 3, "fill, center"));
        this.label = new JLabel();
        this.label.setText(Translatrix.getTranslationString((String)"i18n.LanguageLabel"));
        pBuilder.add((Component)this.label, cc.xy(1, 3));
        if (this.listInsteadComboBox) {
            this.listLanguages = new JList(Translatrix.getSupportedLocales());
            this.listLanguages.setSelectionMode(0);
            this.listLanguages.setSelectedIndex(0);
            this.listLanguages.setCellRenderer(new LocaleComboBoxRenderer());
            pBuilder.add((Component)new JScrollPane(this.listLanguages), cc.xywh(3, 3, 1, 3));
        } else {
            this.cbLanguages = new JComboBox(Translatrix.getSupportedLocales());
            this.cbLanguages.setRenderer(new LocaleComboBoxRenderer());
            this.cbLanguages.setSelectedIndex(0);
            pBuilder.add((Component)this.cbLanguages, cc.xy(3, 3));
        }
        this.addSubPanel(this.languagePanel);
        this.setIcon(I18nPlugin.getIconResource("icn_i18n"));
        if (this.listInsteadComboBox) {
            this.listLanguages.setSelectedValue((Locale)this.getDefault("Locale"), true);
        } else {
            this.cbLanguages.setSelectedItem((Locale)this.getDefault("Locale"));
        }
    }

    public void pluginAdded() {
        this.addPersistenceDelegate(Locale.class, new DefaultPersistenceDelegate(new String[]{"language", "country"}));
    }

    public void revertToDefaults() {
        if (this.listInsteadComboBox) {
            this.listLanguages.setSelectedValue((Locale)this.getDefault("Locale"), true);
        } else {
            this.cbLanguages.setSelectedItem((Locale)this.getDefault("Locale"));
        }
        this.reflectSettings();
        super.revertToDefaults();
    }

    public void updateSettings() {
        if (this.listInsteadComboBox) {
            this.setValue("Locale", (Locale)this.listLanguages.getSelectedValue());
        } else {
            Object item = this.cbLanguages.getSelectedItem();
            if (item != null) {
                this.setValue("Locale", (Locale)item);
            }
        }
        super.updateSettings();
    }

    public void reflectSettings() {
        super.reflectSettings();
        if (this.listInsteadComboBox) {
            this.listLanguages.setSelectedValue((Locale)this.getValue("Locale"), true);
        } else {
            this.cbLanguages.setSelectedItem((Locale)this.getValue("Locale"));
        }
    }

    public void relocalize() {
        super.relocalize();
        this.setLabel(Translatrix.getTranslationString((String)"i18n.Label"));
        this.setSubPanelTitle(this.languagePanel, Translatrix.getTranslationString((String)"i18n.LanguageTitle"));
        this.desc.setText(Translatrix.getTranslationString((String)"i18n.Description"));
        this.label.setText(Translatrix.getTranslationString((String)"i18n.LanguageLabel"));
    }

    public static ImageIcon getFlagIcon(Locale l) {
        URL imgURL = I18nPlugin.class.getResource("resources/icn_flag_" + l.getLanguage().toUpperCase() + ".gif");
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        return new ImageIcon(I18nPlugin.class.getResource("resources/icn_flag_default.gif"));
    }

    public class LocaleComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setBorder(new EmptyBorder(1, 5, 1, 1));
            try {
                this.setText(Translatrix.getTranslationString((String)("i18n.language_" + ((Locale)value).getLanguage().toUpperCase())));
                this.setIcon(I18nPlugin.getFlagIcon((Locale)value));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }
    }
}

