/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.SettingEvent;
import lu.tudor.santec.settings.SettingListener;
import lu.tudor.santec.settings.SettingsPlugin;

public class LookAndFeelPlugin
extends SettingsPlugin
implements SettingListener {
    private static final long serialVersionUID = 1L;
    private JPanel lnfPanel;
    private JList listLookAndFeel;
    private JLabel desc;
    private JLabel label;
    private FormLayout layout;
    String[] lookAndFeels;
    private Object[] windows;
    private static Logger logger = Logger.getLogger("lu.tudor.santec.settings.LookAndFeelPlugin");

    public LookAndFeelPlugin(String p_Name) {
        super(p_Name);
        UIManager.LookAndFeelInfo[] arr = UIManager.getInstalledLookAndFeels();
        this.lookAndFeels = new String[arr.length];
        int i = 0;
        while (i < arr.length) {
            this.lookAndFeels[i] = arr[i].getClassName();
            ++i;
        }
        this.buildPanel();
        this.relocalize();
    }

    public LookAndFeelPlugin(String p_Name, Object[] windows) {
        super(p_Name);
        UIManager.LookAndFeelInfo[] arr = UIManager.getInstalledLookAndFeels();
        this.lookAndFeels = new String[arr.length];
        int i = 0;
        while (i < arr.length) {
            this.lookAndFeels[i] = arr[i].getClassName();
            ++i;
        }
        this.windows = windows;
        this.buildPanel();
        this.relocalize();
    }

    private void buildPanel() {
        this.setLabel(Translatrix.getTranslationString((String)"lnf.Label"));
        UIManager.LookAndFeelInfo lnfi = new UIManager.LookAndFeelInfo(UIManager.getLookAndFeel().getName(), UIManager.getLookAndFeel().getClass().getName());
        this.setStationary("LookAndFeel", lnfi);
        this.layout = new FormLayout("right:50dlu,5dlu,fill:60dlu:grow,5dlu", "center:pref,5dlu,pref,5dlu,60dlu,5dlu");
        CellConstraints cc = new CellConstraints();
        this.lnfPanel = this.createSubPanel(Translatrix.getTranslationString((String)"lnf.Title"));
        this.lnfPanel.setLayout((LayoutManager)this.layout);
        PanelBuilder pBuilder = new PanelBuilder(this.layout, this.lnfPanel);
        this.desc = new JLabel("desc");
        pBuilder.add((Component)this.desc, cc.xyw(1, 1, 3, "fill, center"));
        this.label = new JLabel("label");
        pBuilder.add((Component)this.label, cc.xy(1, 3));
        this.listLookAndFeel = new JList<String>(this.lookAndFeels);
        this.listLookAndFeel.setSelectionMode(0);
        this.listLookAndFeel.setSelectedIndex(0);
        this.listLookAndFeel.setCellRenderer(new LnFComboBoxRenderer());
        pBuilder.add((Component)new JScrollPane(this.listLookAndFeel), cc.xywh(3, 3, 1, 3));
        this.addSubPanel(this.lnfPanel);
        this.setIcon(LookAndFeelPlugin.getIconResource("icn_looknfeel"));
        this.listLookAndFeel.setSelectedValue(this.getDefault("LookAndFeel"), true);
        this.setLabel(Translatrix.getTranslationString((String)"lnf.Label"));
    }

    public void pluginAdded() {
        this.m_Owner.addSettingListener(this);
    }

    public void revertToDefaults() {
        this.setSelectedItem(this.getDefault("LookAndFeel").toString());
        this.reflectSettings();
        super.revertToDefaults();
    }

    public void updateSettings() {
        this.setValue("LookAndFeel", this.listLookAndFeel.getSelectedValue());
        super.updateSettings();
    }

    public void reflectSettings() {
        super.reflectSettings();
        this.setSelectedItem(this.getValue("LookAndFeel").toString());
    }

    public void relocalize() {
        this.setLabel(Translatrix.getTranslationString((String)"lnf.Label"));
        this.setSubPanelTitle(this.lnfPanel, Translatrix.getTranslationString((String)"lnf.Title"));
        this.desc.setText(Translatrix.getTranslationString((String)"lnf.Description"));
        this.label.setText(Translatrix.getTranslationString((String)"lnf.LnFLabel"));
    }

    public void setLookAndFeel(String lookandFeel) {
        try {
            UIManager.setLookAndFeel(lookandFeel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < this.windows.length) {
            if (this.windows[i] instanceof JFrame) {
                SwingUtilities.updateComponentTreeUI((JFrame)this.windows[i]);
                ((JFrame)this.windows[i]).pack();
            } else if (this.windows[i] instanceof JDialog) {
                SwingUtilities.updateComponentTreeUI((JDialog)this.windows[i]);
                ((JDialog)this.windows[i]).pack();
            }
            ++i;
        }
        SwingUtilities.updateComponentTreeUI(this.m_Owner);
        this.m_Owner.pack();
        logger.info("set LookAndFeel to: " + lookandFeel);
    }

    private void setSelectedItem(String lnfi) {
        int i = 0;
        while (i < this.lookAndFeels.length) {
            if (this.lookAndFeels[i].equals(lnfi)) {
                this.listLookAndFeel.setSelectedIndex(i);
                return;
            }
            ++i;
        }
    }

    public void settingChanged(SettingEvent p_Event) {
        if (p_Event.getPluginName().equals(this.getName())) {
            if (this.windows != null) {
                this.setLookAndFeel(this.listLookAndFeel.getSelectedValue().toString());
            }
            logger.info("setting of LookAndFeel changed to: " + this.listLookAndFeel.getSelectedValue());
        }
    }

    public class LnFComboBoxRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setBorder(new EmptyBorder(1, 5, 1, 1));
            try {
                this.setText(value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }
    }
}

