/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.settings;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.l2fprod.common.swing.JButtonBar;
import com.l2fprod.common.swing.plaf.ButtonBarUI;
import com.l2fprod.common.swing.plaf.blue.BlueishButtonBarUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PersistenceDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.DatabasePlugin;
import lu.tudor.santec.settings.ExtAppExtension;
import lu.tudor.santec.settings.ExternalApplicationPlugin;
import lu.tudor.santec.settings.I18nPlugin;
import lu.tudor.santec.settings.InternalDBExtension;
import lu.tudor.santec.settings.LoggingPlugin;
import lu.tudor.santec.settings.LookAndFeelPlugin;
import lu.tudor.santec.settings.SettingEvent;
import lu.tudor.santec.settings.SettingListener;
import lu.tudor.santec.settings.SettingsPlugin;
import lu.tudor.santec.settings.StartScriptPlugin;

public class SettingsPanel
extends JDialog
implements ActionListener,
SettingListener,
Relocalizable {
    private static final long serialVersionUID = 1L;
    protected static Logger m_Logger = Logger.getLogger("lu.tudor.santec.settings.SettingsPanel");
    private EventListenerList m_SettingListeners = new EventListenerList();
    private LinkedHashMap m_Settings;
    private Vector m_Plugins = new Vector();
    private Hashtable m_PersistenceDelegates;
    private JScrollPane m_PluginScroller;
    private JButtonBar m_PluginBar;
    private ButtonGroup m_PluginGroup;
    private JPanel m_ButtonPanel;
    private JButton m_Apply;
    private JButton m_Okay;
    private JButton m_Cancel;
    private JButton m_Revert;
    private Component m_CurrentComponent;
    private double m_ButtonPanelHeight;
    private File m_SettingsFile;
    private SecretKey m_SecretKey;
    private String m_EncryptionPassword;
    private static final Dimension c_PreferredDimension = new Dimension(600, 400);
    private static final String c_PasswordPadding = "        ";
    private static final double c_PluginGap = 35.0;

    public SettingsPanel(Frame p_Owner) {
        super(p_Owner, Translatrix.getTranslationString((String)"SettingsPanelTitle"), true);
        this.m_Settings = new LinkedHashMap();
        this.m_PersistenceDelegates = new Hashtable();
        this.getContentPane().setLayout(new BorderLayout());
        this.setSize(c_PreferredDimension);
        this.m_PluginBar = new JButtonBar(1);
        this.m_PluginBar.setUI((ButtonBarUI)new BlueishButtonBarUI());
        this.m_PluginGroup = new ButtonGroup();
        this.m_PluginScroller = new JScrollPane((Component)this.m_PluginBar);
        this.m_PluginScroller.setHorizontalScrollBarPolicy(31);
        this.m_PluginScroller.setVerticalScrollBarPolicy(20);
        this.m_PluginScroller.getVerticalScrollBar().setUnitIncrement(10);
        this.getContentPane().add((Component)this.m_PluginScroller, "West");
        ButtonBarBuilder l_Builder = new ButtonBarBuilder();
        this.m_Revert = new JButton(Translatrix.getTranslationString((String)"RevertOption"));
        this.m_Revert.addActionListener(this);
        this.m_Cancel = new JButton(Translatrix.getTranslationString((String)"CancelOption"));
        this.m_Cancel.addActionListener(this);
        l_Builder.addGlue();
        l_Builder.addGridded((JComponent)this.m_Revert);
        l_Builder.addUnrelatedGap();
        l_Builder.addUnrelatedGap();
        l_Builder.addGridded((JComponent)this.m_Cancel);
        l_Builder.addRelatedGap();
        this.m_Apply = new JButton(Translatrix.getTranslationString((String)"ApplyOption"));
        this.m_Apply.addActionListener(this);
        l_Builder.addGridded((JComponent)this.m_Apply);
        l_Builder.addRelatedGap();
        this.m_Okay = new JButton(Translatrix.getTranslationString((String)"OkText"));
        this.m_Okay.addActionListener(this);
        l_Builder.addGridded((JComponent)this.m_Okay);
        this.m_ButtonPanel = l_Builder.getPanel();
        this.m_ButtonPanel.setBorder(Borders.DLU4_BORDER);
        this.getContentPane().add((Component)this.m_ButtonPanel, "South");
        this.m_ButtonPanelHeight = this.m_ButtonPanel.getPreferredSize().getHeight();
        this.m_SettingsFile = new File("settings.xml");
        this.m_EncryptionPassword = null;
        this.m_SecretKey = null;
        this.setDefaultCloseOperation(0);
        WindowListener closeWindowAction = new WindowListener(){

            public void windowClosing(WindowEvent e) {
                SettingsPanel.this.reflectSettings();
                SettingsPanel.this.setVisible(false);
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }
        };
        this.addWindowListener(closeWindowAction);
    }

    public void showComponent(Component p_Component) {
        if (this.m_CurrentComponent != null) {
            this.getContentPane().remove(this.m_CurrentComponent);
        }
        this.m_CurrentComponent = p_Component;
        this.getContentPane().add("Center", this.m_CurrentComponent);
        SettingsPlugin l_Plugin = (SettingsPlugin)p_Component;
        this.m_Revert.setEnabled(l_Plugin.hasDefaults());
        this.validate();
        this.repaint();
    }

    private Cipher getEncryptionCipher() {
        Cipher l_Cipher = null;
        try {
            if (this.m_SecretKey == null) {
                DESKeySpec l_KeySpecification = new DESKeySpec(this.m_EncryptionPassword.getBytes());
                SecretKeyFactory l_KeyFactory = SecretKeyFactory.getInstance("DES");
                this.m_SecretKey = l_KeyFactory.generateSecret(l_KeySpecification);
            }
            l_Cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            l_Cipher.init(1, this.m_SecretKey);
        }
        catch (Exception p_Exception) {
            m_Logger.log(Level.WARNING, "Generation of Encryption Cipher failed!", p_Exception);
        }
        return l_Cipher;
    }

    private Cipher getDecryptionCipher() {
        Cipher l_Cipher = null;
        try {
            if (this.m_SecretKey == null) {
                DESKeySpec l_KeySpecification = new DESKeySpec(this.m_EncryptionPassword.getBytes());
                SecretKeyFactory l_KeyFactory = SecretKeyFactory.getInstance("DES");
                this.m_SecretKey = l_KeyFactory.generateSecret(l_KeySpecification);
            }
            l_Cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
            l_Cipher.init(2, this.m_SecretKey);
        }
        catch (Exception p_Exception) {
            m_Logger.log(Level.WARNING, "Generation of Decryption Cipher failed!", p_Exception);
        }
        return l_Cipher;
    }

    public void addSettingListener(SettingListener p_Listener) {
        if (this.m_SettingListeners != null) {
            this.m_SettingListeners.add(SettingListener.class, p_Listener);
        }
    }

    public void removeSettingListener(SettingListener p_Listener) {
        if (this.m_SettingListeners != null) {
            this.m_SettingListeners.remove(SettingListener.class, p_Listener);
        }
    }

    public void fireSettingEvent(SettingEvent p_Event) {
        Object[] l_Listeners = this.m_SettingListeners.getListenerList();
        int l_Index = 0;
        while (l_Index < l_Listeners.length) {
            if (l_Listeners[l_Index] == SettingListener.class) {
                ((SettingListener)l_Listeners[l_Index + 1]).settingChanged(p_Event);
            }
            l_Index += 2;
        }
    }

    public void revertToDefaults() {
        SettingsPlugin l_Plugin = (SettingsPlugin)this.m_CurrentComponent;
        l_Plugin.revertToDefaults();
    }

    public void updateSettings() {
        int l_Index = 0;
        while (l_Index < this.m_Plugins.size()) {
            SettingsPlugin l_Plugin = (SettingsPlugin)this.m_Plugins.elementAt(l_Index);
            l_Plugin.updateSettings();
            ++l_Index;
        }
    }

    public synchronized void reflectSettings() {
        int l_Index = 0;
        while (l_Index < this.m_Plugins.size()) {
            SettingsPlugin l_Plugin = (SettingsPlugin)this.m_Plugins.elementAt(l_Index);
            l_Plugin.reflectSettings();
            ++l_Index;
        }
    }

    public void writeSettings(OutputStream p_SettingsStream) throws IOException {
        String l_ClassName = new String("");
        try {
            try {
                XMLEncoder l_Encoder = new XMLEncoder(p_SettingsStream);
                Enumeration l_Classes = this.m_PersistenceDelegates.keys();
                while (l_Classes.hasMoreElements()) {
                    l_ClassName = (String)l_Classes.nextElement();
                    PersistenceDelegate l_Delegate = (PersistenceDelegate)this.m_PersistenceDelegates.get(l_ClassName);
                    l_Encoder.setPersistenceDelegate(Class.forName(l_ClassName), l_Delegate);
                }
                try {
                    l_Encoder.writeObject(this.m_Settings);
                    l_Encoder.flush();
                }
                finally {
                    l_Encoder.close();
                }
            }
            catch (ClassNotFoundException p_Exception) {
                m_Logger.log(Level.WARNING, "Failed to set Persistence Delegate for Class " + l_ClassName + "!", p_Exception);
                p_SettingsStream.close();
            }
        }
        finally {
            p_SettingsStream.close();
        }
    }

    protected void readSettings(InputStream p_SettingsStream) throws IOException {
        try {
            XMLDecoder l_Decoder = new XMLDecoder(p_SettingsStream);
            try {
                try {
                    LinkedHashMap loadedSettings = (LinkedHashMap)l_Decoder.readObject();
                    for (String pluginName : loadedSettings.keySet()) {
                        this.m_Settings.put(pluginName, loadedSettings.get(pluginName));
                    }
                }
                catch (Exception e) {
                    m_Logger.log(Level.WARNING, "Reading of Settings failed, Settings File not Compatible", e);
                    l_Decoder.close();
                }
            }
            finally {
                l_Decoder.close();
            }
        }
        finally {
            p_SettingsStream.close();
        }
    }

    public void setEncryptionPassword(String p_Password) {
        if (p_Password != null) {
            if (p_Password.length() < 8) {
                p_Password = String.valueOf(p_Password) + c_PasswordPadding.substring(p_Password.length(), c_PasswordPadding.length());
            }
            this.m_EncryptionPassword = p_Password;
            this.m_SecretKey = null;
        }
    }

    public void addPlugin(SettingsPlugin p_Plugin) {
        if (p_Plugin == null) {
            return;
        }
        int l_PluginID = this.m_Plugins.size();
        p_Plugin.setOwner(this, l_PluginID);
        if (this.m_Settings.get(p_Plugin.getName()) == null) {
            this.m_Settings.put(p_Plugin.getName(), new Hashtable());
        }
        this.m_Plugins.add(p_Plugin);
        final SettingsPlugin l_Component = p_Plugin;
        Dimension l_PluginSize = p_Plugin.getPreferredSize();
        Dimension l_PreferredSize = this.getSize();
        if (l_PluginSize.getHeight() > l_PreferredSize.getHeight() - this.m_ButtonPanelHeight) {
            l_PreferredSize.setSize(l_PreferredSize.getWidth(), l_PluginSize.getHeight() + this.m_ButtonPanelHeight);
            this.setSize(l_PreferredSize);
        }
        AbstractAction l_Action = new AbstractAction(p_Plugin.getLabel(), p_Plugin.getIcon()){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent p_Event) {
                SettingsPanel.this.showComponent(l_Component);
            }
        };
        JToggleButton l_Button = new JToggleButton(l_Action);
        l_Button.setToolTipText(p_Plugin.getTooltip());
        this.m_PluginBar.add((Component)l_Button);
        this.m_PluginGroup.add(l_Button);
        Dimension l_ButtonSize = l_Button.getPreferredSize();
        l_PreferredSize = this.m_PluginBar.getPreferredSize();
        Dimension l_ScrollerSize = this.m_PluginScroller.getVerticalScrollBar().getMaximumSize();
        double l_Width = l_PreferredSize.getWidth();
        if (l_ButtonSize.getWidth() > l_Width) {
            l_Width = l_ButtonSize.getWidth() + l_ScrollerSize.getWidth() + 35.0;
        }
        double l_Height = l_PreferredSize.getHeight() + l_ButtonSize.getHeight();
        l_PreferredSize.setSize(l_Width, l_Height);
        this.m_PluginBar.setPreferredSize(l_PreferredSize);
        if (this.m_PluginGroup.getSelection() == null) {
            l_Button.setSelected(true);
            this.showComponent(l_Component);
        }
    }

    public void addPersistenceDelegate(Class p_Class, PersistenceDelegate p_Delegate) {
        if (p_Class != null && p_Delegate != null) {
            this.m_PersistenceDelegates.put(p_Class.getName(), p_Delegate);
        }
    }

    public void setValue(String p_PluginName, String p_Key, Object p_Value) {
        Hashtable l_Settings = null;
        l_Settings = (Hashtable)this.m_Settings.get(p_PluginName);
        if (l_Settings != null) {
            l_Settings.put(p_Key, p_Value);
        }
    }

    public Object getValue(String p_PluginName, String p_Key) {
        Object l_Value = null;
        l_Value = ((Hashtable)this.m_Settings.get(p_PluginName)).get(p_Key);
        return l_Value;
    }

    public void relocalize() {
        this.setTitle(Translatrix.getTranslationString((String)"SettingsPanelTitle"));
        int l_Index = 0;
        while (l_Index < this.m_Plugins.size()) {
            SettingsPlugin l_Plugin = (SettingsPlugin)this.m_Plugins.elementAt(l_Index);
            l_Plugin.relocalize();
            ((JToggleButton)this.m_PluginBar.getComponent(l_Index)).setText(l_Plugin.getLabel());
            ++l_Index;
        }
        if (this.m_Revert != null) {
            this.m_Revert.setText(Translatrix.getTranslationString((String)"RevertOption"));
        }
        if (this.m_Cancel != null) {
            this.m_Cancel.setText(Translatrix.getTranslationString((String)"CancelOption"));
        }
        if (this.m_Apply != null) {
            this.m_Apply.setText(Translatrix.getTranslationString((String)"ApplyOption"));
        }
        if (this.m_Okay != null) {
            this.m_Okay.setText(Translatrix.getTranslationString((String)"OkText"));
        }
    }

    public void actionPerformed(ActionEvent p_ActionEvent) {
        if (p_ActionEvent.getSource() instanceof JButton) {
            if (p_ActionEvent.getSource() == this.m_Revert) {
                this.revertToDefaults();
            }
            if (p_ActionEvent.getSource() == this.m_Okay) {
                this.updateSettings();
                this.saveSettings();
                this.setVisible(false);
            }
            if (p_ActionEvent.getSource() == this.m_Apply) {
                this.updateSettings();
                this.saveSettings();
            }
            if (p_ActionEvent.getSource() == this.m_Cancel) {
                this.reflectSettings();
                this.setVisible(false);
            }
        }
    }

    public void settingChanged(SettingEvent p_SettingEvent) {
        m_Logger.log(Level.INFO, "Setting " + p_SettingEvent.getSetting() + " changed in plugin " + p_SettingEvent.getPluginName());
    }

    public void setSettingsFile(File p_SettingsFile) {
        if (p_SettingsFile != null) {
            this.m_SettingsFile = p_SettingsFile;
        }
    }

    public synchronized void saveSettings() {
        try {
            FileOutputStream l_Stream = new FileOutputStream(this.m_SettingsFile);
            BufferedOutputStream l_BufferedStream = new BufferedOutputStream(l_Stream);
            this.writeSettings(l_BufferedStream);
        }
        catch (Exception p_Exception) {
            m_Logger.log(Level.WARNING, "Saving Settings failed", p_Exception);
        }
    }

    public synchronized void loadSettings() {
        if (this.m_SettingsFile != null && this.m_SettingsFile.isFile()) {
            try {
                FileInputStream l_Stream = new FileInputStream(this.m_SettingsFile);
                BufferedInputStream l_BufferedStream = new BufferedInputStream(l_Stream);
                this.readSettings(l_BufferedStream);
            }
            catch (Exception p_Exception) {
                m_Logger.log(Level.WARNING, "Loading Settings failed", p_Exception);
            }
        }
        this.reflectSettings();
    }

    public static void main(String[] args) throws Exception {
        UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        Translatrix.loadSupportedLocales((String)"lu.tudor.santec.settings.resources.supportedLocales");
        Translatrix.addBundle((String)"lu.tudor.santec.settings.resources.WidgetResources");
        SettingsPanel l_Panel = new SettingsPanel(null);
        I18nPlugin l_I18nPlugin = new I18nPlugin("i18n");
        I18nPlugin l_I18nListPlugin = new I18nPlugin("i18nList", true);
        DatabasePlugin l_DatabasePlugin = new DatabasePlugin("database");
        l_DatabasePlugin.addDatabaseDriver(DatabasePlugin.HSQLDB);
        l_DatabasePlugin.addDatabaseDriver(DatabasePlugin.MYSQL);
        l_DatabasePlugin.addDatabaseDriver(DatabasePlugin.POSTGRESQL);
        l_DatabasePlugin.loadDefaults(new File("DatabasePlugin.xml"));
        InternalDBExtension l_Extension = new InternalDBExtension();
        l_DatabasePlugin.addExtensionAt(l_Extension, 0);
        LoggingPlugin l_LoggingPlugin = new LoggingPlugin("logging");
        LookAndFeelPlugin l_LookAndFeelPlugin = new LookAndFeelPlugin("lnf");
        StartScriptPlugin l_StartSkriptPlugin = new StartScriptPlugin("script", "runSettings", "settings.jar", "");
        ExternalApplicationPlugin l_ExtAppPlugin = new ExternalApplicationPlugin("extapp");
        l_ExtAppPlugin.addExtension(new ExtAppExtension("Adobe PDF", "pdf", "acrord32", "acroread"));
        l_Panel.addPlugin(l_I18nPlugin);
        l_Panel.addPlugin(l_I18nListPlugin);
        l_Panel.addPlugin(l_DatabasePlugin);
        l_Panel.addPlugin(l_LoggingPlugin);
        l_Panel.addPlugin(l_LookAndFeelPlugin);
        l_Panel.addPlugin(l_StartSkriptPlugin);
        l_Panel.addPlugin(l_ExtAppPlugin);
        l_Panel.addSettingListener(l_Panel);
        l_Panel.loadSettings();
        l_Panel.setDefaultCloseOperation(3);
        l_Panel.setVisible(true);
    }
}

