/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.settings;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.beans.PersistenceDelegate;
import java.beans.XMLDecoder;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.settings.PluginExtension;
import lu.tudor.santec.settings.SettingEvent;
import lu.tudor.santec.settings.SettingsPanel;

public class SettingsPlugin
extends JPanel
implements Relocalizable {
    private static final long serialVersionUID = 1L;
    private static Logger m_Logger = Logger.getLogger("lu.tudor.santec.settings.SettingsPlugin");
    protected SettingsPanel m_Owner;
    private String m_Name;
    private Vector m_Extensions;
    private Vector m_SubPanels;
    private Hashtable m_Defaults;
    private Hashtable m_Stationaries;
    private JLabel m_Title;
    private JToggleButton m_Help;
    private ImageIcon m_Icon;
    private String m_Label;
    private String m_Tooltip;
    private JPanel m_Content;
    private JScrollPane m_ContentScroller;
    private boolean m_HasDefaults = false;
    private boolean m_ValuesChanged = false;
    private FormLayout m_ContentLayout;
    private CellConstraints m_Contraints = new CellConstraints();
    private static final Color c_TitleBackground = new Color(193, 210, 238);
    private static final EmptyBorder c_Padding = new EmptyBorder(5, 5, 5, 5);
    private static final int c_Inset = 5;

    public SettingsPlugin(String p_Name) {
        this.m_Name = p_Name;
        this.m_SubPanels = new Vector();
        this.m_Extensions = new Vector();
        this.m_Defaults = new Hashtable();
        this.m_Stationaries = new Hashtable();
        this.setLayout(new BorderLayout());
        this.m_Title = new JLabel();
        this.m_Title.setOpaque(true);
        this.m_Title.setBackground(c_TitleBackground);
        this.m_Title.setBorder(c_Padding);
        this.m_Title.setHorizontalAlignment(0);
        this.m_Title.setVerticalAlignment(0);
        Font l_Font = this.m_Title.getFont();
        Font l_TitleFont = l_Font.deriveFont(1, l_Font.getSize() + 2);
        this.m_Title.setFont(l_TitleFont);
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setOpaque(false);
        titlePanel.add((Component)this.m_Title, "Center");
        ImageIcon l_HelpIcon = SettingsPlugin.getIconResource("icn_help");
        this.m_Help = new JToggleButton(l_HelpIcon);
        this.m_Help.setEnabled(false);
        titlePanel.add((Component)this.m_Help, "East");
        this.add((Component)titlePanel, "North");
        this.m_ContentLayout = new FormLayout("3dlu, fill:10dlu:grow, 3dlu", "3dlu, ");
        this.m_Content = new JPanel((LayoutManager)this.m_ContentLayout);
        this.m_ContentScroller = new JScrollPane(this.m_Content);
        this.m_ContentScroller.setHorizontalScrollBarPolicy(31);
        this.m_ContentScroller.setVerticalScrollBarPolicy(22);
        this.add((Component)this.m_ContentScroller, "Center");
        this.m_Icon = SettingsPlugin.getIconResource("icn_Plugin");
        this.m_Label = Translatrix.getTranslationString((String)"PluginLabel");
        this.m_Tooltip = Translatrix.getTranslationString((String)"PluginTooltip");
    }

    protected static ImageIcon getIconResource(String p_IconName) {
        String l_IconPath = new String("resources/" + p_IconName + ".gif");
        URL l_Location = SettingsPlugin.class.getResource(l_IconPath);
        ImageIcon l_Icon = l_Location != null ? new ImageIcon(l_Location) : new ImageIcon(l_IconPath);
        if (l_Icon != null) {
            return l_Icon;
        }
        return new ImageIcon("");
    }

    public boolean loadDefaults(File p_DefaultsFile) {
        FileInputStream l_Stream = null;
        BufferedInputStream l_BufferedStream = null;
        XMLDecoder l_Decoder = null;
        boolean l_Success = false;
        if (p_DefaultsFile != null && p_DefaultsFile.isFile()) {
            try {
                l_Stream = new FileInputStream(p_DefaultsFile);
                l_BufferedStream = new BufferedInputStream(l_Stream);
                l_Decoder = new XMLDecoder(l_BufferedStream);
                try {
                    this.m_Defaults = (Hashtable)l_Decoder.readObject();
                }
                finally {
                    l_Decoder.close();
                }
                l_BufferedStream.close();
                l_Success = true;
            }
            catch (Exception p_Exception) {
                m_Logger.log(Level.WARNING, "Failed to load Defaults file " + p_DefaultsFile.toString() + "!", p_Exception);
            }
        }
        this.m_HasDefaults = l_Success;
        return l_Success;
    }

    protected JPanel createSubPanel(String p_PanelTitle) {
        JPanel l_Panel = new JPanel();
        l_Panel.setBorder(new TitledBorder(p_PanelTitle));
        return l_Panel;
    }

    protected void setSubPanelTitle(JPanel p_SubPanel, String p_PanelTitle) {
        if (p_SubPanel != null) {
            p_SubPanel.setBorder(new TitledBorder(p_PanelTitle));
        }
    }

    protected void addSubPanel(JPanel p_SubPanel) {
        if (p_SubPanel != null) {
            Dimension l_ContentSize = this.m_Content.getPreferredSize();
            Dimension l_SubPanelSize = p_SubPanel.getPreferredSize();
            int l_ContentWidth = (int)l_ContentSize.getWidth();
            int l_ContentHeight = (int)(l_ContentSize.getHeight() + l_SubPanelSize.getHeight() + 10.0);
            this.m_ContentLayout.appendRow(new RowSpec("pref"));
            this.m_Content.add((Component)p_SubPanel, this.m_Contraints.xy(2, this.m_ContentLayout.getRowCount()));
            this.m_ContentLayout.appendRow(new RowSpec("3dlu"));
            l_ContentSize = new Dimension(l_ContentWidth, l_ContentHeight);
            this.m_SubPanels.add(p_SubPanel);
        }
    }

    protected void addSubPanelAt(JPanel p_SubPanel, int p_Position) {
        if (p_SubPanel != null && p_Position >= 0 && p_Position < this.m_SubPanels.size()) {
            this.m_Content.removeAll();
            this.m_SubPanels.add(p_Position, p_SubPanel);
            this.m_ContentLayout.appendRow(new RowSpec("pref"));
            this.m_ContentLayout.appendRow(new RowSpec("3dlu"));
            int l_SubPanelIndex = 0;
            while (l_SubPanelIndex < this.m_SubPanels.size()) {
                JPanel l_SubPanel = (JPanel)this.m_SubPanels.elementAt(l_SubPanelIndex);
                this.m_Content.add((Component)l_SubPanel, this.m_Contraints.xy(2, l_SubPanelIndex * 2 + 2));
                ++l_SubPanelIndex;
            }
            Dimension l_ContentSize = this.m_Content.getPreferredSize();
            Dimension l_SubPanelSize = p_SubPanel.getPreferredSize();
            int l_ContentWidth = (int)l_ContentSize.getWidth();
            int l_ContentHeight = (int)(l_ContentSize.getHeight() + l_SubPanelSize.getHeight() + 10.0);
            l_ContentSize = new Dimension(l_ContentWidth, l_ContentHeight);
        }
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String p_Name) {
        if (p_Name != null) {
            this.m_Name = p_Name;
        }
    }

    public ImageIcon getIcon() {
        return this.m_Icon;
    }

    public void setIcon(ImageIcon p_Icon) {
        if (p_Icon != null) {
            this.m_Icon = p_Icon;
        }
    }

    public String getLabel() {
        return this.m_Label;
    }

    public void setLabel(String p_Label) {
        if (p_Label != null) {
            this.m_Label = p_Label;
            this.m_Title.setText(this.m_Label);
        }
    }

    public String getTooltip() {
        return this.m_Tooltip;
    }

    public void setTooltip(String p_Tooltip) {
        if (p_Tooltip != null) {
            this.m_Tooltip = p_Tooltip;
        }
    }

    public boolean hasDefaults() {
        return this.m_HasDefaults;
    }

    public boolean valuesChanged() {
        return this.m_ValuesChanged;
    }

    protected void resetValueChanged() {
        this.m_ValuesChanged = false;
    }

    public void pluginAdded() {
    }

    public void setOwner(SettingsPanel p_Owner, int p_PluginID) {
        if (p_Owner != null) {
            this.m_Owner = p_Owner;
            this.pluginAdded();
        }
    }

    protected void setValue(String p_Key, Object p_Value) {
        if (this.m_Owner != null) {
            Object l_SettingValue = this.getValue(p_Key);
            boolean l_ValueChanged = l_SettingValue == null ? true : !l_SettingValue.equals(p_Value);
            this.m_ValuesChanged |= l_ValueChanged;
            this.m_Owner.setValue(this.m_Name, p_Key, p_Value);
            if (l_ValueChanged) {
                SettingEvent l_Event = new SettingEvent(this, this.m_Name, p_Key);
                this.m_Owner.fireSettingEvent(l_Event);
            }
        }
    }

    public Object getValue(String p_Key) {
        Object l_Value = null;
        if (this.m_Owner != null && (l_Value = this.m_Owner.getValue(this.m_Name, p_Key)) == null && (l_Value = this.getDefault(p_Key)) == null) {
            l_Value = this.getStationary(p_Key);
        }
        return l_Value;
    }

    protected Object getDefault(String p_Key) {
        Object l_Default = null;
        if (this.m_Defaults.containsKey(p_Key)) {
            l_Default = this.m_Defaults.get(p_Key);
        }
        return l_Default;
    }

    protected Object getStationary(String p_Key) {
        Object l_Stationary = null;
        if (this.m_Stationaries.containsKey(p_Key)) {
            l_Stationary = this.m_Stationaries.get(p_Key);
        }
        return l_Stationary;
    }

    public void setStationary(String p_Key, Object p_Value) {
        this.m_Stationaries.put(p_Key, p_Value);
    }

    public void updateSettings() {
        int l_ExtensionIndex = 0;
        while (l_ExtensionIndex < this.m_Extensions.size()) {
            PluginExtension l_Extension = (PluginExtension)this.m_Extensions.elementAt(l_ExtensionIndex);
            l_Extension.updateSettings();
            ++l_ExtensionIndex;
        }
    }

    public void reflectSettings() {
        int l_ExtensionIndex = 0;
        while (l_ExtensionIndex < this.m_Extensions.size()) {
            PluginExtension l_Extension = (PluginExtension)this.m_Extensions.elementAt(l_ExtensionIndex);
            l_Extension.reflectSettings();
            ++l_ExtensionIndex;
        }
    }

    public void revertToDefaults() {
        int l_ExtensionIndex = 0;
        while (l_ExtensionIndex < this.m_Extensions.size()) {
            PluginExtension l_Extension = (PluginExtension)this.m_Extensions.elementAt(l_ExtensionIndex);
            l_Extension.revertToDefaults();
            ++l_ExtensionIndex;
        }
    }

    public void relocalize() {
        this.m_Label = Translatrix.getTranslationString((String)"PluginLabel");
        this.m_Tooltip = Translatrix.getTranslationString((String)"PluginTooltip");
        int l_ExtensionIndex = 0;
        while (l_ExtensionIndex < this.m_Extensions.size()) {
            PluginExtension l_Extension = (PluginExtension)this.m_Extensions.elementAt(l_ExtensionIndex);
            l_Extension.relocalize();
            ++l_ExtensionIndex;
        }
    }

    public void addExtension(PluginExtension p_Extension) {
        if (p_Extension != null) {
            this.m_Extensions.add(p_Extension);
            p_Extension.setOwner(this);
            this.addSubPanel(p_Extension);
        }
    }

    public void addExtensionAt(PluginExtension p_Extension, int p_Position) {
        if (p_Extension != null && p_Position >= 0 && p_Position < this.m_SubPanels.size()) {
            this.m_Extensions.add(p_Extension);
            p_Extension.setOwner(this);
            this.addSubPanelAt(p_Extension, p_Position);
        }
    }

    public void setSubPanelEnabled(int p_SubPanelID, boolean p_Enabled) {
        if (p_SubPanelID >= 0 && p_SubPanelID < this.m_SubPanels.size()) {
            JPanel l_SubPanel = (JPanel)this.m_SubPanels.elementAt(p_SubPanelID);
            int l_ComponentCount = l_SubPanel.getComponentCount();
            int l_ComponentID = 0;
            while (l_ComponentID < l_ComponentCount) {
                Component l_Component = l_SubPanel.getComponent(l_ComponentID);
                l_Component.setEnabled(p_Enabled);
                ++l_ComponentID;
            }
        }
    }

    public void addPersistenceDelegate(Class p_Class, PersistenceDelegate p_Delegate) {
        if (this.m_Owner != null) {
            this.m_Owner.addPersistenceDelegate(p_Class, p_Delegate);
        }
    }
}

