/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.i18n;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Translatrix {
    private static Locale m_Locale = Locale.getDefault();
    private static Hashtable<String, String> m_Translations = new Hashtable();
    private static Hashtable<String, String> m_Defaults = new Hashtable();
    private static List<String> m_Bundles = new ArrayList<String>();
    private static List<Locale> m_SupportedLocales = new ArrayList<Locale>();
    private static ClassLoader m_ClassLoader = Translatrix.class.getClassLoader();
    private static boolean m_DefaultWhenMissing = false;
    private static String c_Null = "NULL";
    private static Pattern c_KeyPattern = Pattern.compile("^language_(\\d)$", 2);
    private static Pattern c_LocalePattern = Pattern.compile("^([a-zA-Z]{2})_([a-zA-Z]{2})$", 2);
    private static Pattern c_PlaceHolderPattern = Pattern.compile("(\\$)(\\d+)", 2);

    private static boolean loadBundle(String p_Bundle, Locale p_Locale, ClassLoader p_Loader) {
        ResourceBundle l_Bundle = null;
        boolean l_LoadedSuccessfully = false;
        try {
            l_Bundle = p_Locale == null ? ResourceBundle.getBundle(p_Bundle) : ResourceBundle.getBundle(p_Bundle, p_Locale, p_Loader);
            if (l_Bundle != null) {
                Enumeration<String> l_Keys = l_Bundle.getKeys();
                while (l_Keys.hasMoreElements()) {
                    String l_Key = l_Keys.nextElement();
                    String l_Value = l_Bundle.getString(l_Key);
                    if (l_Value == null || l_Value.trim().length() <= 0) continue;
                    m_Translations.put(l_Key, l_Value);
                }
                l_LoadedSuccessfully = true;
            }
            Translatrix.loadDefaultBundle(p_Bundle);
        }
        catch (MissingResourceException p_Exception) {
            Translatrix.logException("MissingResourceException while loading language file", p_Exception);
        }
        return l_LoadedSuccessfully;
    }

    private static void loadDefaultBundle(String p_Bundle) {
        ResourceBundle l_Bundle = null;
        l_Bundle = ResourceBundle.getBundle(p_Bundle, new Locale("en", "US"));
        if (l_Bundle == null || !l_Bundle.getKeys().hasMoreElements()) {
            System.out.println("No default/en_US translations found at: " + p_Bundle + "_en_US.properties .... skipping");
            return;
        }
        if (l_Bundle != null) {
            Enumeration<String> l_Keys = l_Bundle.getKeys();
            while (l_Keys.hasMoreElements()) {
                String l_Key = l_Keys.nextElement();
                String l_Value = l_Bundle.getString(l_Key);
                if (l_Value == null || l_Value.trim().length() <= 0) continue;
                m_Defaults.put(l_Key, l_Value);
            }
        }
    }

    private static void logException(String p_Message, Exception p_Exception) {
        System.err.println(p_Message);
        p_Exception.printStackTrace(System.err);
    }

    private static boolean isSupportedLocale(Locale p_Locale) {
        boolean l_LocaleIsSupported = false;
        int l_LocaleID = 0;
        while (l_LocaleID < m_SupportedLocales.size()) {
            Locale l_Locale = m_SupportedLocales.get(l_LocaleID);
            if (p_Locale.equals(l_Locale)) {
                l_LocaleIsSupported = true;
            }
            ++l_LocaleID;
        }
        return l_LocaleIsSupported;
    }

    public static void setClassLoader(Class<?> p_Class) {
        if (p_Class != null) {
            m_ClassLoader = p_Class.getClassLoader();
        }
    }

    public static void setLocale(Locale p_Locale) {
        if (Translatrix.isSupportedLocale(p_Locale)) {
            m_Locale = p_Locale;
            m_Translations = new Hashtable();
            int l_BundleID = 0;
            while (l_BundleID < m_Bundles.size()) {
                String l_Bundle = m_Bundles.get(l_BundleID);
                Translatrix.loadBundle(l_Bundle, m_Locale, m_ClassLoader);
                ++l_BundleID;
            }
        } else {
            System.err.println("Unsupported Locale " + p_Locale.toString() + " specified in call to setLocale()");
        }
    }

    public static void setLocale(String p_Locale) {
        Matcher l_Matcher = c_LocalePattern.matcher(p_Locale);
        if (l_Matcher.matches()) {
            Translatrix.setLocale(new Locale(l_Matcher.group(1), l_Matcher.group(2)));
        }
    }

    public static Locale getLocale() {
        return m_Locale;
    }

    public static Locale getDefaultLocale() {
        if (m_SupportedLocales != null && m_SupportedLocales.size() > 0) {
            return m_SupportedLocales.get(0);
        }
        return Locale.getDefault();
    }

    public static void addBundle(String p_Bundle) {
        if (Translatrix.loadBundle(p_Bundle, m_Locale, m_ClassLoader)) {
            m_Bundles.add(p_Bundle);
        }
    }

    public static void loadSupportedLocales(String p_SupportedLocalesBundle) {
        ResourceBundle l_Bundle;
        try {
            l_Bundle = ResourceBundle.getBundle(p_SupportedLocalesBundle, Locale.getDefault(), m_ClassLoader);
        }
        catch (Exception p_Exception) {
            Translatrix.logException("Failed to load supportedLocales file", p_Exception);
            return;
        }
        if (l_Bundle != null) {
            Integer l_ID;
            Hashtable<Integer, Locale> l_Locales = new Hashtable<Integer, Locale>();
            Enumeration<String> l_Keys = l_Bundle.getKeys();
            while (l_Keys.hasMoreElements()) {
                String l_Key = l_Keys.nextElement();
                Matcher l_Matcher = c_KeyPattern.matcher(l_Key);
                if (!l_Matcher.matches()) continue;
                l_ID = new Integer(l_Matcher.group(1));
                l_Matcher = c_LocalePattern.matcher(l_Bundle.getString(l_Key));
                if (!l_Matcher.matches()) continue;
                l_Locales.put(l_ID, new Locale(l_Matcher.group(1), l_Matcher.group(2)));
            }
            if (l_Locales.size() > 0) {
                m_SupportedLocales = new ArrayList<Locale>();
                int l_Index = 0;
                while (l_Index < l_Locales.size()) {
                    l_ID = new Integer(l_Index);
                    if (l_Locales.containsKey(l_ID)) {
                        m_SupportedLocales.add((Locale)l_Locales.get(l_ID));
                    }
                    ++l_Index;
                }
            }
        }
    }

    public static List<Locale> getSupportedLocales() {
        return m_SupportedLocales;
    }

    public static List<String> getBundles() {
        return m_Bundles;
    }

    public static List<String> getTranslationKeys() {
        ArrayList<String> l_Keys = new ArrayList<String>();
        Enumeration<String> l_TranslationKeys = m_Translations.keys();
        while (l_TranslationKeys.hasMoreElements()) {
            l_Keys.add(l_TranslationKeys.nextElement());
        }
        return l_Keys;
    }

    public static boolean hasTranslationFor(String p_Key) {
        if (p_Key != null && m_Translations != null) {
            return m_Translations.containsKey(p_Key);
        }
        return false;
    }

    public static String getTranslationString(String p_Key) {
        String l_Translation = p_Key;
        if (p_Key == null) {
            return "null";
        }
        if (m_Translations != null) {
            l_Translation = m_Translations.get(p_Key);
            if ((l_Translation == null || l_Translation.trim().equals("")) && Translatrix.isDefaultWhenMissing()) {
                l_Translation = m_Defaults.get(p_Key);
            }
            if (l_Translation == null || l_Translation.trim().equals("")) {
                l_Translation = p_Key;
            }
        }
        return l_Translation;
    }

    public static String _(String p_Key) {
        return Translatrix.getTranslationString(p_Key);
    }

    public static String getTranslationString(String p_Key, String[] p_Filler) {
        String l_Translation = p_Key;
        if (p_Key == null) {
            return "null";
        }
        if (m_Translations != null) {
            l_Translation = Translatrix.getTranslationString(p_Key);
            if (l_Translation != null) {
                if (p_Filler != null && p_Filler.length > 0) {
                    StringBuffer l_Buffer = new StringBuffer();
                    Matcher l_Matcher = c_PlaceHolderPattern.matcher(l_Translation);
                    while (l_Matcher.find()) {
                        int l_Index = Integer.valueOf(l_Matcher.group(2));
                        if (l_Index < 0 || l_Index >= p_Filler.length) continue;
                        String l_Filler = p_Filler[l_Index] != null ? p_Filler[l_Index] : c_Null;
                        l_Matcher.appendReplacement(l_Buffer, l_Filler);
                    }
                    l_Matcher.appendTail(l_Buffer);
                    l_Translation = l_Buffer.toString();
                }
            } else {
                l_Translation = p_Key;
            }
        }
        return l_Translation;
    }

    public static String _(String p_Key, String[] p_Filler) {
        return Translatrix.getTranslationString(p_Key, p_Filler);
    }

    public static boolean isDefaultWhenMissing() {
        return m_DefaultWhenMissing;
    }

    public static void setDefaultWhenMissing(boolean defaultWhenMissing) {
        m_DefaultWhenMissing = defaultWhenMissing;
    }

    public static Hashtable<String, String> getTranslationsCopy() {
        return (Hashtable)m_Translations.clone();
    }
}

