/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.net.URL;
import java.util.List;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.autodetect.FontInfoFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontAdder {
    private final FontEventListener listener;
    private final FontResolver resolver;
    private final FontManager manager;

    public FontAdder(FontManager manager, FontResolver resolver, FontEventListener listener) {
        this.manager = manager;
        this.resolver = resolver;
        this.listener = listener;
    }

    public void add(List<URL> fontURLList, List<EmbedFontInfo> fontInfoList) {
        FontCache cache = this.manager.getFontCache();
        FontInfoFinder finder = new FontInfoFinder();
        finder.setEventListener(this.listener);
        for (URL fontURL : fontURLList) {
            EmbedFontInfo[] embedFontInfos = finder.find(fontURL, this.resolver, cache);
            if (embedFontInfos == null) continue;
            for (EmbedFontInfo fontInfo : embedFontInfos) {
                if (fontInfo == null) continue;
                fontInfoList.add(fontInfo);
            }
        }
    }
}

