/*
 * Decompiled with CFR 0.152.
 */
package tracing;

import java.awt.AWTEvent;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;

class TracingEventQueueThreadJMX
extends Thread {
    private long thresholdDelay;
    private Map<AWTEvent, Long> eventTimeMap;
    private ThreadMXBean threadBean;
    private boolean deadlocksOnly;

    public TracingEventQueueThreadJMX(long thresholdDelay, boolean deadlocksOnly) {
        this.thresholdDelay = thresholdDelay;
        this.deadlocksOnly = deadlocksOnly;
        this.eventTimeMap = new HashMap<AWTEvent, Long>();
        try {
            MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objName = new ObjectName("java.lang:type=Threading");
            Set<ObjectName> mbeans = mbeanServer.queryNames(objName, null);
            for (ObjectName name : mbeans) {
                this.threadBean = ManagementFactory.newPlatformMXBeanProxy(mbeanServer, name.toString(), ThreadMXBean.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized void eventDispatched(AWTEvent event) {
        this.eventTimeMap.put(event, System.currentTimeMillis());
    }

    public synchronized void eventProcessed(AWTEvent event) {
        this.checkEventTime(event, System.currentTimeMillis(), this.eventTimeMap.get(event));
        this.eventTimeMap.put(event, null);
    }

    private void checkEventTime(AWTEvent event, long currTime, long startTime) {
        StringBuffer sb = new StringBuffer();
        long currProcessingTime = currTime - startTime;
        if (currProcessingTime >= this.thresholdDelay) {
            sb.append("Event [" + event.hashCode() + "] " + event.getClass().getName() + " is taking too much time on EDT (" + currProcessingTime + ")\n");
            if (this.threadBean != null) {
                int n;
                long[] threadIds;
                long[] lArray = threadIds = this.threadBean.getAllThreadIds();
                int n2 = 0;
                int n3 = lArray.length;
                while (n2 < n3) {
                    long threadId = lArray[n2];
                    ThreadInfo threadInfo = this.threadBean.getThreadInfo(threadId, Integer.MAX_VALUE);
                    if (threadInfo.getThreadName().startsWith("AWT-EventQueue")) {
                        StackTraceElement[] stack;
                        sb.append(String.valueOf(threadInfo.getThreadName()) + " / " + (Object)((Object)threadInfo.getThreadState()) + "\n");
                        StackTraceElement[] stackTraceElementArray = stack = threadInfo.getStackTrace();
                        int n4 = 0;
                        n = stackTraceElementArray.length;
                        while (n4 < n) {
                            StackTraceElement stackEntry = stackTraceElementArray[n4];
                            sb.append("\t" + stackEntry.getClassName() + "." + stackEntry.getMethodName() + " [" + stackEntry.getLineNumber() + "]" + "\n");
                            ++n4;
                        }
                    }
                    ++n2;
                }
                long[] deadlockedThreads = this.threadBean.findMonitorDeadlockedThreads();
                if (deadlockedThreads == null && this.deadlocksOnly) {
                    sb = new StringBuffer();
                }
                if (deadlockedThreads != null && deadlockedThreads.length > 0) {
                    sb.append("Deadlocked threads:\n");
                    long[] lArray2 = deadlockedThreads;
                    n3 = 0;
                    int n5 = lArray2.length;
                    while (n3 < n5) {
                        StackTraceElement[] stack;
                        long threadId = lArray2[n3];
                        ThreadInfo threadInfo = this.threadBean.getThreadInfo(threadId, Integer.MAX_VALUE);
                        sb.append(String.valueOf(threadInfo.getThreadName()) + " / " + (Object)((Object)threadInfo.getThreadState()) + "\n");
                        StackTraceElement[] stackTraceElementArray = stack = threadInfo.getStackTrace();
                        n = 0;
                        int n6 = stackTraceElementArray.length;
                        while (n < n6) {
                            StackTraceElement stackEntry = stackTraceElementArray[n];
                            sb.append("\t" + stackEntry.getClassName() + "." + stackEntry.getMethodName() + " [" + stackEntry.getLineNumber() + "]" + "\n");
                            ++n;
                        }
                        ++n3;
                    }
                }
            }
            if (sb.length() > 0) {
                System.out.println("++++++++++++++++++++++++++++++++++++++++++++++");
                System.out.println(sb.toString());
                System.out.println("-----------------------------------------------------------------------------------------------");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            long currTime = System.currentTimeMillis();
            TracingEventQueueThreadJMX tracingEventQueueThreadJMX = this;
            synchronized (tracingEventQueueThreadJMX) {
                for (Map.Entry<AWTEvent, Long> entry : this.eventTimeMap.entrySet()) {
                    AWTEvent event = entry.getKey();
                    if (entry.getValue() == null) continue;
                    long startTime = entry.getValue();
                    this.checkEventTime(event, currTime, startTime);
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

