/*
 * Decompiled with CFR 0.152.
 */
package com.svcon.jdbf;

import com.svcon.jdbf.JDBFException;
import com.svcon.jdbf.JDBField;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;

public class DBFWriter {
    private BufferedOutputStream stream = null;
    private int recCount = 0;
    private JDBField[] fields = null;
    private String fileName = null;
    private String dbfEncoding = null;

    public DBFWriter(String string, JDBField[] jDBFieldArray) throws JDBFException {
        this.fileName = string;
        try {
            this.init(new FileOutputStream(string), jDBFieldArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JDBFException(fileNotFoundException);
        }
    }

    public DBFWriter(OutputStream outputStream, JDBField[] jDBFieldArray) throws JDBFException {
        this.init(outputStream, jDBFieldArray);
    }

    public DBFWriter(String string, JDBField[] jDBFieldArray, String string2) throws JDBFException {
        this.fileName = string;
        try {
            this.dbfEncoding = string2;
            this.init(new FileOutputStream(string), jDBFieldArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new JDBFException(fileNotFoundException);
        }
    }

    private void init(OutputStream outputStream, JDBField[] jDBFieldArray) throws JDBFException {
        this.fields = jDBFieldArray;
        try {
            this.stream = new BufferedOutputStream(outputStream);
            this.writeHeader();
            int n = 0;
            while (n < jDBFieldArray.length) {
                this.writeFieldHeader(jDBFieldArray[n]);
                ++n;
            }
            this.stream.write(13);
            this.stream.flush();
        }
        catch (Exception exception) {
            throw new JDBFException(exception);
        }
    }

    private void writeHeader() throws IOException {
        byte[] byArray = new byte[16];
        byArray[0] = 3;
        Calendar calendar = Calendar.getInstance();
        byArray[1] = (byte)(calendar.get(1) - 1900);
        byArray[2] = (byte)calendar.get(2);
        byArray[3] = (byte)calendar.get(5);
        byArray[4] = 0;
        byArray[5] = 0;
        byArray[6] = 0;
        byArray[7] = 0;
        int n = (this.fields.length + 1) * 32 + 1;
        byArray[8] = (byte)(n % 256);
        byArray[9] = (byte)(n / 256);
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.fields.length) {
            n2 += this.fields[n3].getLength();
            ++n3;
        }
        byArray[10] = (byte)(n2 % 256);
        byArray[11] = (byte)(n2 / 256);
        byArray[12] = 0;
        byArray[13] = 0;
        byArray[14] = 0;
        byArray[15] = 0;
        this.stream.write(byArray, 0, byArray.length);
        int n4 = 0;
        while (n4 < 16) {
            byArray[n4] = 0;
            ++n4;
        }
        this.stream.write(byArray, 0, byArray.length);
    }

    private void writeFieldHeader(JDBField jDBField) throws IOException {
        byte[] byArray = new byte[16];
        String string = jDBField.getName();
        int n = string.length();
        if (n > 10) {
            n = 10;
        }
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)string.charAt(n2);
            ++n2;
        }
        int n3 = n;
        while (n3 <= 10) {
            byArray[n3] = 0;
            ++n3;
        }
        byArray[11] = (byte)jDBField.getType();
        byArray[12] = 0;
        byArray[13] = 0;
        byArray[14] = 0;
        byArray[15] = 0;
        this.stream.write(byArray, 0, byArray.length);
        int n4 = 0;
        while (n4 < 16) {
            byArray[n4] = 0;
            ++n4;
        }
        byArray[0] = (byte)jDBField.getLength();
        byArray[1] = (byte)jDBField.getDecimalCount();
        this.stream.write(byArray, 0, byArray.length);
    }

    public void addRecord(Object[] objectArray) throws JDBFException {
        if (objectArray.length != this.fields.length) {
            throw new JDBFException("Error adding record: Wrong number of values. Expected " + this.fields.length + ", got " + objectArray.length + ".");
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.fields.length) {
            n += this.fields[n2].getLength();
            ++n2;
        }
        byte[] byArray = new byte[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.fields.length) {
            byte[] byArray2;
            String string = this.fields[n4].format(objectArray[n4]);
            try {
                byArray2 = this.dbfEncoding != null ? string.getBytes(this.dbfEncoding) : string.getBytes();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new JDBFException(unsupportedEncodingException);
            }
            int n5 = 0;
            while (n5 < this.fields[n4].getLength()) {
                byArray[n3 + n5] = byArray2[n5];
                ++n5;
            }
            n3 += this.fields[n4].getLength();
            ++n4;
        }
        try {
            this.stream.write(32);
            this.stream.write(byArray, 0, byArray.length);
            this.stream.flush();
        }
        catch (IOException iOException) {
            throw new JDBFException(iOException);
        }
        ++this.recCount;
    }

    public void close() throws JDBFException {
        try {
            this.stream.write(26);
            this.stream.close();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.fileName, "rw");
            randomAccessFile.seek(4L);
            byte[] byArray = new byte[]{(byte)(this.recCount % 256), (byte)(this.recCount / 256 % 256), (byte)(this.recCount / 65536 % 256), (byte)(this.recCount / 0x1000000 % 256)};
            randomAccessFile.write(byArray, 0, byArray.length);
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            throw new JDBFException(iOException);
        }
    }
}

