/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.widgets;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import lu.tudor.santec.i18n.Relocalizable;
import lu.tudor.santec.i18n.Translatrix;

public class AboutDialog
extends JFrame
implements ActionListener,
Relocalizable {
    private static final long serialVersionUID = 1L;
    private static final int c_PreferredWidth = 500;
    private static final int c_PreferredHeight = 400;
    protected final Font c_ProgramNameFont = new Font("Serif", 1, 24);
    protected final Font c_DefaultFont = new Font("Dialog", 0, 10);
    protected final Font c_VersionFont = new Font("Version", 1, 14);
    protected final Color c_CRPDarkBlue = new Color(12, 71, 140);
    protected final Color c_CRPLightBlue = new Color(210, 217, 235);
    protected final Color c_CRPRed = new Color(193, 54, 47);
    protected final Color c_DefaultColor = new Color(127, 127, 127);
    private JLabel m_CorporateHeader;
    private JLabel m_ProgramName;
    private JLabel m_ProgramLogo;
    private JLabel m_ProgramVersion;
    private JLabel m_Message;
    private JButton m_Dismisser;
    private JLabel m_CorporateFooter;

    public AboutDialog() {
        this.buildAboutPanel();
    }

    public AboutDialog(String p_Title) {
        super(p_Title);
        this.buildAboutPanel();
    }

    private void buildAboutPanel() {
        GridBagLayout l_Layout = new GridBagLayout();
        GridBagConstraints l_Constraints = new GridBagConstraints();
        this.setSize(500, 400);
        this.setResizable(false);
        this.getContentPane().setLayout(l_Layout);
        this.getContentPane().setBackground(Color.white);
        this.buildConstraint(l_Constraints, 0, 0, 3, 1, 100, 10, 0, 0);
        l_Constraints.fill = 0;
        l_Constraints.anchor = 11;
        this.m_CorporateHeader = new JLabel("", AboutDialog.getIconResource("icn_ciheader"), 0);
        l_Layout.setConstraints(this.m_CorporateHeader, l_Constraints);
        this.getContentPane().add(this.m_CorporateHeader);
        this.buildConstraint(l_Constraints, 0, 1, 1, 2, 33, 90, 10, 10);
        l_Constraints.fill = 0;
        l_Constraints.anchor = 10;
        this.m_ProgramLogo = new JLabel("", AboutDialog.getIconResource("icn_javalogo"), 0);
        l_Layout.setConstraints(this.m_ProgramLogo, l_Constraints);
        this.getContentPane().add(this.m_ProgramLogo);
        this.buildConstraint(l_Constraints, 1, 1, 1, 1, 55, 10, 10, 10);
        l_Constraints.fill = 0;
        l_Constraints.anchor = 13;
        this.m_ProgramName = new JLabel("ProgramName", null, 0);
        this.m_ProgramName.setFont(this.c_ProgramNameFont);
        this.m_ProgramName.setForeground(this.c_CRPDarkBlue);
        l_Layout.setConstraints(this.m_ProgramName, l_Constraints);
        this.getContentPane().add(this.m_ProgramName);
        this.buildConstraint(l_Constraints, 2, 1, 1, 1, 11, 10, 10, 10);
        l_Constraints.fill = 0;
        l_Constraints.anchor = 17;
        this.m_ProgramVersion = new JLabel("1.0.0", null, 0);
        this.m_ProgramVersion.setFont(this.c_VersionFont);
        this.m_ProgramVersion.setForeground(this.c_CRPDarkBlue);
        l_Layout.setConstraints(this.m_ProgramVersion, l_Constraints);
        this.getContentPane().add(this.m_ProgramVersion);
        this.buildConstraint(l_Constraints, 1, 2, 2, 1, 66, 90, 10, 10);
        l_Constraints.fill = 0;
        l_Constraints.anchor = 11;
        this.m_Message = new JLabel("Message", null, 0);
        this.m_Message.setFont(this.c_DefaultFont);
        this.m_Message.setForeground(this.c_DefaultColor);
        l_Layout.setConstraints(this.m_Message, l_Constraints);
        this.getContentPane().add(this.m_Message);
        this.buildConstraint(l_Constraints, 0, 3, 3, 1, 100, 5, 10, 10);
        l_Constraints.fill = 0;
        l_Constraints.anchor = 10;
        this.m_Dismisser = new JButton(Translatrix.getTranslationString((String)"CloseOption"));
        this.m_Dismisser.addActionListener(this);
        l_Layout.setConstraints(this.m_Dismisser, l_Constraints);
        this.getContentPane().add(this.m_Dismisser);
        this.buildConstraint(l_Constraints, 0, 4, 3, 1, 100, 10, 0, 0);
        l_Constraints.fill = 0;
        l_Constraints.anchor = 15;
        this.m_CorporateFooter = new JLabel("", AboutDialog.getIconResource("icn_cifooter"), 0);
        l_Layout.setConstraints(this.m_CorporateFooter, l_Constraints);
        this.getContentPane().add(this.m_CorporateFooter);
    }

    protected static ImageIcon getIconResource(String p_IconName) {
        String l_IconPath = new String("resources/" + p_IconName + ".gif");
        URL l_Location = AboutDialog.class.getResource(l_IconPath);
        if (l_Location != null) {
            return new ImageIcon(l_Location);
        }
        return new ImageIcon(l_IconPath);
    }

    public void buildConstraint(GridBagConstraints p_Constraints, int p_GridX, int p_GridY, int p_GridWidth, int p_GridHeight, int p_WeightX, int p_WeightY, int p_MarginX, int p_MarginY) {
        p_Constraints.gridx = p_GridX;
        p_Constraints.gridy = p_GridY;
        p_Constraints.gridwidth = p_GridWidth;
        p_Constraints.gridheight = p_GridHeight;
        p_Constraints.weightx = p_WeightX;
        p_Constraints.weighty = p_WeightY;
        p_Constraints.insets = new Insets(p_MarginY, p_MarginX, p_MarginY, p_MarginX);
    }

    public void actionPerformed(ActionEvent p_ActionEvent) {
        this.setVisible(false);
    }

    public void relocalize() {
        if (this.m_Dismisser != null) {
            this.m_Dismisser.setText(Translatrix.getTranslationString((String)"CloseOption"));
        }
    }

    public void setVisible(boolean p_Visibility) {
        if (p_Visibility) {
            Dimension l_ScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension l_DialogSize = this.getSize();
            this.setLocation((l_ScreenSize.width - l_DialogSize.width) / 2, (l_ScreenSize.height - l_DialogSize.height) / 2);
        }
        super.setVisible(p_Visibility);
    }

    public void setProgramName(String p_ProgramName) {
        this.m_ProgramName.setText(p_ProgramName);
    }

    public void setMessage(String p_Message) {
        this.m_Message.setText(p_Message);
    }

    public void setBody(String p_Body) {
        this.setMessage(p_Body);
    }

    public void setProgramLogo(ImageIcon p_ProgramLogo) {
        this.m_ProgramLogo.setIcon(p_ProgramLogo);
    }

    public void setProgramVersion(String p_ProgramVersion) {
        this.m_ProgramVersion.setText(p_ProgramVersion);
    }

    public void enableCorporateIdentity(boolean p_EnableIt) {
        this.m_CorporateHeader.setVisible(p_EnableIt);
        this.m_CorporateFooter.setVisible(p_EnableIt);
    }

    public static void main(String[] args) {
        AboutDialog l_About = new AboutDialog("About...");
        l_About.setProgramName("AboutDialog");
        l_About.setProgramVersion("1.0");
        l_About.setMessage("<html>This class displays a standard <b>About Box</b><br>for applications developed by Santec</html>");
        l_About.setVisible(true);
    }
}

