/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.widgets;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.BreakIterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.widgets.TriangleButton;

public class ExceptionDialog
extends JDialog
implements ActionListener {
    private ActionListener m_ActionListener;
    private JButton m_Okay;
    private JLabel m_Exception = new JLabel();
    private TriangleButton m_More;
    private JScrollPane m_Scroller;
    private JLabel m_Cause = new JLabel();
    private FontMetrics m_ExceptionMetrics;
    private static final int c_PreferredWidth = 400;

    public ExceptionDialog(JFrame p_Parent, String p_Title) {
        super(p_Parent, p_Title, true);
        this.m_Scroller = new JScrollPane(this.m_Cause, 20, 30);
        this.m_Scroller.setVisible(false);
        Font l_ExceptionFont = this.m_Exception.getFont();
        this.m_Cause.setFont(l_ExceptionFont.deriveFont((float)((double)l_ExceptionFont.getSize() * 0.75)));
        this.m_More = new TriangleButton(Translatrix.getTranslationString((String)"MoreButton"));
        this.m_More.addActionListener(this);
        this.m_More.setVisible(false);
        this.m_Okay = new JButton(Translatrix.getTranslationString((String)"OkayOption"));
        this.m_Okay.addActionListener(this);
        Object[] l_Content = new Object[]{this.m_Exception, this.m_More, this.m_Scroller};
        Object[] l_Options = new Object[]{this.m_Okay};
        JOptionPane l_OptionPane = new JOptionPane(l_Content, 2, 0, null, l_Options, l_Options[0]);
        this.setContentPane(l_OptionPane);
        Dimension l_DialogSize = this.getSize();
        l_DialogSize.width = 400;
        this.setSize(l_DialogSize);
    }

    private int nextWordStartAfter(int p_Position, String p_Message) {
        BreakIterator l_WordIterator = BreakIterator.getWordInstance();
        l_WordIterator.setText(p_Message);
        int l_Last = l_WordIterator.following(p_Position);
        int l_Current = l_WordIterator.next();
        while (l_Current != -1) {
            for (int p = l_Last; p < l_Current; ++p) {
                if (!Character.isLetter(p_Message.charAt(p))) continue;
                return l_Last;
            }
            l_Last = l_Current;
            l_Current = l_WordIterator.next();
        }
        return -1;
    }

    private String wrapMessage(String p_Message) {
        int l_Next;
        String l_Wrapped = new String("<html>");
        String l_Line = new String("");
        int l_Previous = 0;
        do {
            String l_Word;
            if ((l_Next = this.nextWordStartAfter(l_Previous, p_Message)) != -1) {
                l_Word = p_Message.substring(l_Previous, l_Next);
                if (this.m_ExceptionMetrics.stringWidth(l_Line + " " + l_Word) < 400) {
                    l_Line = l_Line + " " + l_Word;
                } else {
                    l_Wrapped = l_Wrapped + l_Line + "<br>";
                    l_Line = l_Word;
                }
                l_Previous = l_Next;
                continue;
            }
            l_Word = p_Message.substring(l_Previous);
            l_Wrapped = l_Wrapped + l_Line + " " + l_Word + "</HTML>";
        } while (l_Next != -1);
        return l_Wrapped;
    }

    public void addActionListener(ActionListener p_ActionListener) {
        this.m_ActionListener = p_ActionListener;
    }

    public void setException(Exception p_Exception) {
        this.m_ExceptionMetrics = this.getFontMetrics(this.m_Exception.getFont());
        this.m_Exception.setText(this.wrapMessage(p_Exception.getLocalizedMessage()));
        if (p_Exception.getCause() != null) {
            this.m_Cause.setText(p_Exception.getCause().toString());
            this.m_More.setVisible(true);
            this.pack();
        } else {
            this.m_Cause.setText(null);
            this.m_More.setVisible(false);
            this.m_Scroller.setVisible(false);
            this.pack();
        }
    }

    public void setVisible(boolean p_Visibility) {
        if (p_Visibility) {
            Dimension l_ScreenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension l_DialogSize = this.getSize();
            this.setLocation((l_ScreenSize.width - l_DialogSize.width) / 2, (l_ScreenSize.height - l_DialogSize.height) / 2);
        }
        super.setVisible(p_Visibility);
    }

    public void actionPerformed(ActionEvent p_ActionEvent) {
        if (p_ActionEvent.getSource() == this.m_Okay) {
            this.setVisible(false);
        }
        if (p_ActionEvent.getSource() == this.m_More) {
            Dimension l_ScrollerDimension = this.m_Scroller.getSize();
            l_ScrollerDimension.width = 400;
            if (l_ScrollerDimension.height == 0) {
                l_ScrollerDimension.height = 50;
            }
            this.m_Scroller.setSize(l_ScrollerDimension);
            this.m_Scroller.setPreferredSize(l_ScrollerDimension);
            this.m_Scroller.setVisible(this.m_More.isSelected());
            this.pack();
        }
    }

    public static void main(String[] args) {
        JFrame.setDefaultLookAndFeelDecorated(true);
        JFrame frame = new JFrame("ExceptionDialog");
        frame.setDefaultCloseOperation(3);
        ExceptionDialog l_ExceptionDialog = new ExceptionDialog(frame, "ExceptionDialog");
        Exception l_Exception = new Exception("This a test Exception message for testing the Exception Dialog.This dialog automatically wraps the displayed text message. Furthermore, if the specified exception has a its cause attribute set, a 'More Details...'button will allow you to see the cause of the exception!");
        l_ExceptionDialog.setException(l_Exception);
        l_ExceptionDialog.pack();
        l_ExceptionDialog.setVisible(true);
    }
}

