/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.widgets.gui;

import com.toedter.calendar.JDateChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedHashMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import lu.tudor.santec.i18n.Translatrix;
import lu.tudor.santec.widgets.gui.DateChooserFactory;

public class DateTimeChooser
extends JPanel
implements ChangeListener,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    public static final int DATE_TIME = 1;
    public static final int HOUR_BOX = 2;
    public static final int DAY_BOX = 3;
    public static final String TIME_CHANGED = "time_changed";
    private JDateChooser dateChooser;
    private JSpinner timeSpinner;
    private SpinnerDateModel timeModel;
    private int type = 1;
    private JComboBox hourBox;
    private JComboBox weekdayBox;
    private LinkedHashMap<String, Integer> weekdayHash;

    public DateTimeChooser() {
        this("HH:mm:ss", 1);
    }

    public DateTimeChooser(String format, int type) {
        this(format, type, 30);
    }

    public DateTimeChooser(String format, int type, int minOffset) {
        this.type = type;
        if (1 == type) {
            this.initDateTimeChooser(format);
        }
        if (2 == type) {
            this.initHourBox(minOffset);
        }
        if (3 == type) {
            this.initDayBox();
        }
    }

    private void initDayBox() {
        this.setLayout(new BorderLayout());
        SimpleDateFormat weekdayFormat = new SimpleDateFormat("EEEE", Translatrix.getLocale());
        GregorianCalendar c = new GregorianCalendar(Translatrix.getLocale());
        c.set(7, c.getFirstDayOfWeek());
        this.weekdayHash = new LinkedHashMap();
        for (int i = 0; i < 7; ++i) {
            this.weekdayHash.put(weekdayFormat.format(c.getTime()), c.get(7));
            ((Calendar)c).roll(7, true);
        }
        this.weekdayBox = new JComboBox<Object>(this.weekdayHash.keySet().toArray());
        try {
            this.weekdayBox.setSelectedIndex(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.add((Component)this.weekdayBox, "Center");
    }

    private void initHourBox(int minOffset) {
        this.setLayout(new BorderLayout());
        final DateFormat formater = DateFormat.getTimeInstance(3, Translatrix.getLocale());
        this.hourBox = new JComboBox<Date>(DateTimeChooser.createDateList(30));
        this.hourBox.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof Date) {
                    return super.getListCellRendererComponent((JList<?>)list, formater.format(value), index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        try {
            this.hourBox.setSelectedIndex(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.add((Component)this.hourBox, "Center");
    }

    private void initDateTimeChooser(String format) {
        this.setLayout(new BorderLayout(5, 2));
        this.dateChooser = DateChooserFactory.createShort();
        this.timeModel = new SpinnerDateModel();
        this.timeSpinner = new JSpinner(this.timeModel);
        JSpinner.DateEditor endeditor = new JSpinner.DateEditor(this.timeSpinner, format);
        this.timeSpinner.setEditor(endeditor);
        this.add((Component)this.dateChooser, "Center");
        this.add((Component)this.timeSpinner, "East");
        this.timeModel.addChangeListener(this);
        this.dateChooser.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void setDate(Date date) {
        if (date == null) {
            return;
        }
        if (1 == this.type) {
            try {
                this.dateChooser.setDate(date);
                this.timeModel.setValue(date);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (2 == this.type) {
            Date old = null;
            for (int i = 0; i < this.hourBox.getItemCount(); ++i) {
                if (this.getTimeOfDay(date) < this.getTimeOfDay((Date)this.hourBox.getItemAt(i))) continue;
                old = (Date)this.hourBox.getItemAt(i);
            }
            if (old != null) {
                this.hourBox.setSelectedItem(old);
            } else {
                try {
                    this.hourBox.setSelectedIndex(0);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (3 == this.type) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int day = cal.get(7);
            for (String s : this.weekdayHash.keySet()) {
                if (day != this.weekdayHash.get(s)) continue;
                this.weekdayBox.setSelectedItem(s);
                return;
            }
            try {
                this.weekdayBox.setSelectedIndex(0);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public Date getDate() {
        if (1 == this.type) {
            GregorianCalendar date = new GregorianCalendar();
            date.setTime(this.dateChooser.getDate());
            GregorianCalendar time = new GregorianCalendar();
            time.setTime(this.timeModel.getDate());
            date.set(11, time.get(11));
            date.set(12, time.get(12));
            date.set(13, time.get(13));
            return date.getTime();
        }
        if (2 == this.type) {
            return (Date)this.hourBox.getSelectedItem();
        }
        if (3 == this.type) {
            String s = (String)this.weekdayBox.getSelectedItem();
            Calendar cal = Calendar.getInstance();
            cal.set(7, this.weekdayHash.get(s));
            return cal.getTime();
        }
        return null;
    }

    private void fireChange() {
        this.firePropertyChange(TIME_CHANGED, this.getDate(), new Date());
    }

    public void stateChanged(ChangeEvent e) {
        this.fireChange();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("date".equals(evt.getPropertyName())) {
            this.fireChange();
        }
    }

    private long getTimeOfDay(Date d) {
        Calendar c = Calendar.getInstance();
        c.setTime(d);
        long r = c.get(11) * 60;
        return r += (long)c.get(12);
    }

    public static Date[] createDateList(int minOffset) {
        if (minOffset < 0) {
            minOffset = 0;
        }
        if (minOffset > 60) {
            minOffset = 60;
        }
        try {
            Calendar cal = Calendar.getInstance();
            cal.set(5, 0);
            cal.set(2, 0);
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            int capacity = 1440 / minOffset;
            Date[] dates = new Date[capacity];
            int limit = 60 / minOffset;
            int count = 1;
            for (int i = 0; i < capacity; ++i) {
                dates[i] = cal.getTime();
                cal.roll(12, minOffset);
                if (count == limit) {
                    cal.roll(11, 1);
                    count = 0;
                }
                ++count;
            }
            return dates;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

