/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.widgets.gui.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import lu.tudor.santec.i18n.Translatrix;

public class FormInputComponent
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton button;
    private Vector<ActionListener> listeners = new Vector();

    public FormInputComponent(String title, Component comp) {
        this(title, comp, null);
    }

    public FormInputComponent(String title, Component comp, String buttonLabel) {
        this(title, comp, buttonLabel, null);
    }

    public FormInputComponent(String title, Component comp, String buttonLabel, Icon buttonIcon) {
        this.setLayout(new BorderLayout(10, 0));
        this.add((Component)new JLabel(Translatrix.getTranslationString((String)title) + ":"), "West");
        this.add(comp, "Center");
        if (buttonLabel != null || buttonIcon != null) {
            this.button = new JButton();
            if (buttonLabel != null) {
                this.button.setText(Translatrix.getTranslationString((String)buttonLabel));
            }
            if (buttonIcon != null) {
                this.button.setIcon(buttonIcon);
            }
            this.add((Component)this.button, "East");
            this.button.addActionListener(this);
        }
    }

    public void addActionListener(ActionListener l) {
        this.listeners.add(l);
    }

    public void actionPerformed(ActionEvent e) {
        ActionEvent event = new ActionEvent(this, 1001, "button fired");
        for (ActionListener l : this.listeners) {
            l.actionPerformed(event);
        }
    }

    public void enablePanel(boolean b) {
        this.enableSubPanel(this, b);
    }

    private void enableSubPanel(JComponent parent, boolean b) {
        parent.setEnabled(b);
        if (parent.getComponents() != null) {
            for (Component sc : parent.getComponents()) {
                sc.setEnabled(b);
                if (!(sc instanceof JComponent)) continue;
                this.enableSubPanel((JComponent)sc, b);
            }
        }
    }

    public JButton getButton() {
        return this.button;
    }
}

