/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.widgets.gui.form;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class FormPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final boolean GROW = true;
    public static final boolean NO_GROW = false;
    private FormLayout layout = new FormLayout("3dlu,right:pref,5dlu,left:pref:grow,3dlu", "3dlu");
    private CellConstraints cc = new CellConstraints();
    private int row = 2;
    private int defaultWidth = 300;

    public FormPanel() {
        this.setLayout((LayoutManager)this.layout);
    }

    public FormPanel(String text, JComponent comp) {
        this();
        this.addLine(text, comp);
    }

    public FormPanel(String text, JComponent comp, boolean opaque) {
        this();
        this.setOpaque(opaque);
        this.addLine(text, comp);
    }

    public void setDefaultWidth(int cols) {
        this.defaultWidth = cols;
    }

    public void addLine(JComponent component) {
        this.addLine(component, false);
    }

    public void addLine(JComponent component, boolean grow) {
        if (grow) {
            this.layout.appendRow(new RowSpec("top:pref:grow"));
        } else {
            this.layout.appendRow(new RowSpec("top:pref"));
        }
        this.add((Component)component, this.cc.xyw(2, this.row, 3));
        this.layout.appendRow(new RowSpec("3dlu"));
        this.row += 2;
    }

    public void addLine(JComponent component, int pref) {
        this.addLine(component, pref, false);
    }

    public void addLine(JComponent component, int pref, boolean grow) {
        if (grow) {
            this.layout.appendRow(new RowSpec("top:" + pref + ":grow"));
        } else {
            this.layout.appendRow(new RowSpec("top:" + pref));
        }
        this.add((Component)component, this.cc.xyw(2, this.row, 3));
        this.layout.appendRow(new RowSpec("3dlu"));
        this.row += 2;
    }

    public void addLine(String name, JComponent component) {
        this.layout.appendRow(new RowSpec("top:pref"));
        this.add((Component)new JLabel(name + ":"), this.cc.xy(2, this.row));
        this.add((Component)component, this.cc.xy(4, this.row));
        this.layout.appendRow(new RowSpec("3dlu"));
        this.row += 2;
    }

    public void addLine(String name, String content) {
        JLabel contentLabel = new JLabel(content);
        int rows = 1;
        if (content == null) {
            contentLabel.setText("");
        } else {
            rows = content.length() / 50;
        }
        if (rows == 0) {
            rows = 1;
        }
        contentLabel.setPreferredSize(new Dimension(this.defaultWidth, rows * 20));
        this.addLine(name, contentLabel);
        contentLabel.setBackground(Color.WHITE);
        contentLabel.setOpaque(true);
        contentLabel.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        contentLabel.setVerticalAlignment(1);
    }

    public JLabel addTextBlock(String text) {
        JLabel l = new JLabel(text);
        l.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY));
        this.layout.appendRow(new RowSpec("top:pref"));
        this.add((Component)l, this.cc.xyw(2, this.row, 3));
        this.layout.appendRow(new RowSpec("3dlu"));
        this.row += 2;
        return l;
    }

    public void addGap() {
        this.layout.appendRow(new RowSpec("3dlu"));
        ++this.row;
    }

    public void addSeparator() {
        this.layout.appendRow(new RowSpec("center:5dlu"));
        this.add((Component)new JSeparator(), this.cc.xyw(2, this.row, 3));
        ++this.row;
    }
}

