/*
 * Decompiled with CFR 0.152.
 */
package lu.tudor.santec.widgets.gui.table;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;

public class TableColumnListener
implements MouseListener,
TableColumnModelListener {
    private JTable table;
    private boolean mousePressed;
    private boolean marginChanged;

    public TableColumnListener(JTable table) {
        this.table = table;
        this.table.getTableHeader().addMouseListener(this);
        this.table.getColumnModel().addColumnModelListener(this);
    }

    public void mousePressed(MouseEvent e) {
        this.mousePressed = true;
    }

    public void mouseReleased(MouseEvent e) {
        this.mousePressed = false;
        if (this.marginChanged) {
            Integer[] columnMargins = new Integer[this.table.getColumnCount()];
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                columnMargins[i] = this.table.getColumnModel().getColumn(i).getWidth();
            }
            this.columnsChanged(columnMargins);
        }
    }

    public void columnMarginChanged(ChangeEvent e) {
        if (this.mousePressed) {
            this.marginChanged = true;
        }
    }

    public void columnsChanged(Integer[] columnMargins) {
        System.out.println("columnsChanged in " + this.getClass().getSimpleName() + " not implemented yet!");
    }

    public void columnAdded(TableColumnModelEvent e) {
    }

    public void columnMoved(TableColumnModelEvent e) {
    }

    public void columnRemoved(TableColumnModelEvent e) {
    }

    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

