/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import java.util.Vector;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.common.ReflectException;
import loci.common.ReflectedUniverse;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.IFormatWriter;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import loci.formats.MissingLibraryException;
import loci.formats.meta.DummyMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.services.OMEXMLService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FormatTools {
    public static final int INT8 = 0;
    public static final int UINT8 = 1;
    public static final int INT16 = 2;
    public static final int UINT16 = 3;
    public static final int INT32 = 4;
    public static final int UINT32 = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    private static final String[] pixelTypes = FormatTools.makePixelTypes();
    public static final String CHANNEL = "Channel";
    public static final String SPECTRA = "Spectra";
    public static final String LIFETIME = "Lifetime";
    public static final String POLARIZATION = "Polarization";
    public static final String PHASE = "Phase";
    public static final String FREQUENCY = "Frequency";
    public static final int MUST_GROUP = 0;
    public static final int CAN_GROUP = 1;
    public static final int CANNOT_GROUP = 2;
    public static final String SERIES_NUM = "%s";
    public static final String SERIES_NAME = "%n";
    public static final String CHANNEL_NUM = "%c";
    public static final String CHANNEL_NAME = "%w";
    public static final String Z_NUM = "%z";
    public static final String T_NUM = "%t";
    public static final String TIMESTAMP = "%A";
    @Deprecated
    public static final String SVN_REVISION = "3f142f7";
    public static final String VCS_REVISION = "3f142f7";
    public static final String DATE = "7 February 2013";
    public static final String VERSION = "4.4.6";
    public static final String HCS_DOMAIN = "High-Content Screening (HCS)";
    public static final String LM_DOMAIN = "Light Microscopy";
    public static final String EM_DOMAIN = "Electron Microscopy (EM)";
    public static final String SPM_DOMAIN = "Scanning Probe Microscopy (SPM)";
    public static final String SEM_DOMAIN = "Scanning Electron Microscopy (SEM)";
    public static final String FLIM_DOMAIN = "Fluorescence-Lifetime Imaging";
    public static final String MEDICAL_DOMAIN = "Medical Imaging";
    public static final String HISTOLOGY_DOMAIN = "Histology";
    public static final String GEL_DOMAIN = "Gel/Blot Imaging";
    public static final String ASTRONOMY_DOMAIN = "Astronomy";
    public static final String GRAPHICS_DOMAIN = "Graphics";
    public static final String UNKNOWN_DOMAIN = "Unknown";
    public static final String[] NON_GRAPHICS_DOMAINS = new String[]{"Light Microscopy", "Electron Microscopy (EM)", "Scanning Probe Microscopy (SPM)", "Scanning Electron Microscopy (SEM)", "Fluorescence-Lifetime Imaging", "Medical Imaging", "Histology", "Gel/Blot Imaging", "Astronomy", "High-Content Screening (HCS)", "Unknown"};
    public static final String[] NON_HCS_DOMAINS = new String[]{"Light Microscopy", "Electron Microscopy (EM)", "Scanning Probe Microscopy (SPM)", "Scanning Electron Microscopy (SEM)", "Fluorescence-Lifetime Imaging", "Medical Imaging", "Histology", "Gel/Blot Imaging", "Astronomy", "Unknown"};
    public static final String[] NON_SPECIAL_DOMAINS = new String[]{"Light Microscopy", "Electron Microscopy (EM)", "Scanning Probe Microscopy (SPM)", "Scanning Electron Microscopy (SEM)", "Fluorescence-Lifetime Imaging", "Medical Imaging", "Histology", "Gel/Blot Imaging", "Astronomy", "Unknown"};
    public static final String[] ALL_DOMAINS = new String[]{"High-Content Screening (HCS)", "Light Microscopy", "Electron Microscopy (EM)", "Scanning Probe Microscopy (SPM)", "Scanning Electron Microscopy (SEM)", "Fluorescence-Lifetime Imaging", "Medical Imaging", "Histology", "Gel/Blot Imaging", "Astronomy", "Graphics", "Unknown"};
    public static final String URL_BIO_FORMATS = "http://www.openmicroscopy.org/site/products/bio-formats";
    public static final String URL_BIO_FORMATS_LIBRARIES = "http://www.openmicroscopy.org/site/support/bio-formats/developers/java-library.html";
    public static final String URL_OME_TIFF = "http://ome-xml.org/wiki/OmeTiff";

    static String[] makePixelTypes() {
        String[] pixelTypes = new String[]{"int8", "uint8", "int16", "uint16", "int32", "uint32", "float", "double"};
        return pixelTypes;
    }

    private FormatTools() {
    }

    public static int getIndex(IFormatReader reader, int z, int c, int t) {
        String order = reader.getDimensionOrder();
        int zSize = reader.getSizeZ();
        int cSize = reader.getEffectiveSizeC();
        int tSize = reader.getSizeT();
        int num = reader.getImageCount();
        return FormatTools.getIndex(order, zSize, cSize, tSize, num, z, c, t);
    }

    public static int getIndex(String order, int zSize, int cSize, int tSize, int num, int z, int c, int t) {
        int len0;
        int v2;
        int v1;
        int v0;
        if (order == null) {
            throw new IllegalArgumentException("Dimension order is null");
        }
        if (!order.startsWith("XY") && !order.startsWith("YX")) {
            throw new IllegalArgumentException("Invalid dimension order: " + order);
        }
        int iz = order.indexOf("Z") - 2;
        int ic = order.indexOf("C") - 2;
        int it = order.indexOf("T") - 2;
        if (iz < 0 || iz > 2 || ic < 0 || ic > 2 || it < 0 || it > 2) {
            throw new IllegalArgumentException("Invalid dimension order: " + order);
        }
        if (zSize <= 0) {
            throw new IllegalArgumentException("Invalid Z size: " + zSize);
        }
        if (z < 0 || z >= zSize) {
            throw new IllegalArgumentException("Invalid Z index: " + z + "/" + zSize);
        }
        if (cSize <= 0) {
            throw new IllegalArgumentException("Invalid C size: " + cSize);
        }
        if (c < 0 || c >= cSize) {
            throw new IllegalArgumentException("Invalid C index: " + c + "/" + cSize);
        }
        if (tSize <= 0) {
            throw new IllegalArgumentException("Invalid T size: " + tSize);
        }
        if (t < 0 || t >= tSize) {
            throw new IllegalArgumentException("Invalid T index: " + t + "/" + tSize);
        }
        if (num <= 0) {
            throw new IllegalArgumentException("Invalid image count: " + num);
        }
        if (num != zSize * cSize * tSize) {
            throw new IllegalArgumentException("ZCT size vs image count mismatch (sizeZ=" + zSize + ", sizeC=" + cSize + ", sizeT=" + tSize + ", total=" + num + ")");
        }
        int n = iz == 0 ? z : (v0 = ic == 0 ? c : t);
        int n2 = iz == 1 ? z : (v1 = ic == 1 ? c : t);
        int n3 = iz == 2 ? z : (v2 = ic == 2 ? c : t);
        int n4 = iz == 0 ? zSize : (len0 = ic == 0 ? cSize : tSize);
        int len1 = iz == 1 ? zSize : (ic == 1 ? cSize : tSize);
        return v0 + v1 * len0 + v2 * len0 * len1;
    }

    public static int[] getZCTCoords(IFormatReader reader, int index) {
        String order = reader.getDimensionOrder();
        int zSize = reader.getSizeZ();
        int cSize = reader.getEffectiveSizeC();
        int tSize = reader.getSizeT();
        int num = reader.getImageCount();
        return FormatTools.getZCTCoords(order, zSize, cSize, tSize, num, index);
    }

    public static int[] getZCTCoords(String order, int zSize, int cSize, int tSize, int num, int index) {
        int c;
        int z;
        int len0;
        if (order == null) {
            throw new IllegalArgumentException("Dimension order is null");
        }
        if (!order.startsWith("XY") && !order.startsWith("YX")) {
            throw new IllegalArgumentException("Invalid dimension order: " + order);
        }
        int iz = order.indexOf("Z") - 2;
        int ic = order.indexOf("C") - 2;
        int it = order.indexOf("T") - 2;
        if (iz < 0 || iz > 2 || ic < 0 || ic > 2 || it < 0 || it > 2) {
            throw new IllegalArgumentException("Invalid dimension order: " + order);
        }
        if (zSize <= 0) {
            throw new IllegalArgumentException("Invalid Z size: " + zSize);
        }
        if (cSize <= 0) {
            throw new IllegalArgumentException("Invalid C size: " + cSize);
        }
        if (tSize <= 0) {
            throw new IllegalArgumentException("Invalid T size: " + tSize);
        }
        if (num <= 0) {
            throw new IllegalArgumentException("Invalid image count: " + num);
        }
        if (num != zSize * cSize * tSize) {
            throw new IllegalArgumentException("ZCT size vs image count mismatch (sizeZ=" + zSize + ", sizeC=" + cSize + ", sizeT=" + tSize + ", total=" + num + ")");
        }
        if (index < 0 || index >= num) {
            throw new IllegalArgumentException("Invalid image index: " + index + "/" + num);
        }
        int n = iz == 0 ? zSize : (len0 = ic == 0 ? cSize : tSize);
        int len1 = iz == 1 ? zSize : (ic == 1 ? cSize : tSize);
        int v0 = index % len0;
        int v1 = index / len0 % len1;
        int v2 = index / len0 / len1;
        int n2 = iz == 0 ? v0 : (z = iz == 1 ? v1 : v2);
        int n3 = ic == 0 ? v0 : (c = ic == 1 ? v1 : v2);
        int t = it == 0 ? v0 : (it == 1 ? v1 : v2);
        return new int[]{z, c, t};
    }

    public static int getReorderedIndex(IFormatReader reader, String newOrder, int newIndex) throws FormatException {
        String origOrder = reader.getDimensionOrder();
        int zSize = reader.getSizeZ();
        int cSize = reader.getEffectiveSizeC();
        int tSize = reader.getSizeT();
        int num = reader.getImageCount();
        return FormatTools.getReorderedIndex(origOrder, newOrder, zSize, cSize, tSize, num, newIndex);
    }

    public static int getReorderedIndex(String origOrder, String newOrder, int zSize, int cSize, int tSize, int num, int newIndex) {
        int[] zct = FormatTools.getZCTCoords(newOrder, zSize, cSize, tSize, num, newIndex);
        return FormatTools.getIndex(origOrder, zSize, cSize, tSize, num, zct[0], zct[1], zct[2]);
    }

    public static int positionToRaster(int[] lengths, int[] pos) {
        int offset = 1;
        int raster = 0;
        for (int i = 0; i < pos.length; ++i) {
            raster += offset * pos[i];
            offset *= lengths[i];
        }
        return raster;
    }

    public static int[] rasterToPosition(int[] lengths, int raster) {
        return FormatTools.rasterToPosition(lengths, raster, new int[lengths.length]);
    }

    public static int[] rasterToPosition(int[] lengths, int raster, int[] pos) {
        int offset = 1;
        for (int i = 0; i < pos.length; ++i) {
            int offset1 = offset * lengths[i];
            int q = i < pos.length - 1 ? raster % offset1 : raster;
            pos[i] = q / offset;
            raster -= q;
            offset = offset1;
        }
        return pos;
    }

    public static int getRasterLength(int[] lengths) {
        int len = 1;
        for (int i = 0; i < lengths.length; ++i) {
            len *= lengths[i];
        }
        return len;
    }

    public static int pixelTypeFromString(String pixelTypeAsString) {
        String lowercaseTypeAsString = pixelTypeAsString.toLowerCase();
        for (int i = 0; i < pixelTypes.length; ++i) {
            if (!pixelTypes[i].equals(lowercaseTypeAsString)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unknown type: '" + pixelTypeAsString + "'");
    }

    public static String getPixelTypeString(int pixelType) {
        if (pixelType < 0 || pixelType >= pixelTypes.length) {
            throw new IllegalArgumentException("Unknown pixel type: " + pixelType);
        }
        return pixelTypes[pixelType];
    }

    public static int getBytesPerPixel(int pixelType) {
        switch (pixelType) {
            case 0: 
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Unknown pixel type: " + pixelType);
    }

    public static int getBytesPerPixel(String pixelType) {
        return FormatTools.getBytesPerPixel(FormatTools.pixelTypeFromString(pixelType));
    }

    public static boolean isFloatingPoint(int pixelType) {
        switch (pixelType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return false;
            }
            case 6: 
            case 7: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unknown pixel type: " + pixelType);
    }

    public static boolean isSigned(int pixelType) {
        switch (pixelType) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                return true;
            }
            case 1: 
            case 3: 
            case 5: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown pixel type: " + pixelType);
    }

    public static int pixelTypeFromBytes(int bytes, boolean signed, boolean fp) throws FormatException {
        switch (bytes) {
            case 1: {
                return signed ? 0 : 1;
            }
            case 2: {
                return signed ? 2 : 3;
            }
            case 4: {
                return fp ? 6 : (signed ? 4 : 5);
            }
            case 8: {
                return 7;
            }
        }
        throw new FormatException("Unsupported byte depth: " + bytes);
    }

    public static void assertId(String currentId, boolean notNull, int depth) {
        String header;
        String msg = null;
        if (currentId == null && notNull) {
            msg = "Current file should not be null; call setId(String) first";
        } else if (currentId != null && !notNull) {
            msg = "Current file should be null, but is '" + currentId + "'; call close() first";
        }
        if (msg == null) {
            return;
        }
        StackTraceElement[] ste = new Exception().getStackTrace();
        if (depth > 0 && ste.length > depth) {
            String c = ste[depth].getClassName();
            if (c.startsWith("loci.formats.")) {
                c = c.substring(c.lastIndexOf(".") + 1);
            }
            header = c + "." + ste[depth].getMethodName() + ": ";
        } else {
            header = "";
        }
        throw new IllegalStateException(header + msg);
    }

    public static void checkPlaneParameters(IFormatReader r, int no, int bufLength, int x, int y, int w, int h) throws FormatException {
        FormatTools.assertId(r.getCurrentFile(), true, 2);
        FormatTools.checkPlaneNumber(r, no);
        FormatTools.checkTileSize(r, x, y, w, h);
        if (bufLength >= 0) {
            FormatTools.checkBufferSize(r, bufLength, w, h);
        }
    }

    public static void checkPlaneNumber(IFormatReader r, int no) throws FormatException {
        int imageCount = r.getImageCount();
        if (no < 0 || no >= imageCount) {
            throw new FormatException("Invalid image number: " + no + " (series=" + r.getSeries() + ", imageCount=" + imageCount + ")");
        }
    }

    public static void checkTileSize(IFormatReader r, int x, int y, int w, int h) throws FormatException {
        int width = r.getSizeX();
        int height = r.getSizeY();
        if (x < 0 || y < 0 || w < 0 || h < 0 || x + w > width || y + h > height) {
            throw new FormatException("Invalid tile size: x=" + x + ", y=" + y + ", w=" + w + ", h=" + h);
        }
    }

    public static void checkBufferSize(IFormatReader r, int len) throws FormatException {
        FormatTools.checkBufferSize(r, len, r.getSizeX(), r.getSizeY());
    }

    public static void checkBufferSize(IFormatReader r, int len, int w, int h) throws FormatException {
        int size = FormatTools.getPlaneSize(r, w, h);
        if (size > len) {
            throw new FormatException("Buffer too small (got " + len + ", expected " + size + ").");
        }
    }

    public static boolean validStream(RandomAccessInputStream stream, int len, boolean littleEndian) throws IOException {
        stream.seek(0L);
        stream.order(littleEndian);
        return stream.length() >= (long)len;
    }

    public static int getPlaneSize(IFormatReader r) {
        return FormatTools.getPlaneSize(r, r.getSizeX(), r.getSizeY());
    }

    public static int getPlaneSize(IFormatReader r, int w, int h) {
        return w * h * r.getRGBChannelCount() * FormatTools.getBytesPerPixel(r.getPixelType());
    }

    public static String getFilename(int series, int image, IFormatReader r, String pattern) throws FormatException, IOException {
        Double deltaT;
        MetadataStore store = r.getMetadataStore();
        MetadataRetrieve retrieve = store instanceof MetadataRetrieve ? (MetadataRetrieve)((Object)store) : new DummyMetadata();
        String filename = pattern.replaceAll(SERIES_NUM, String.valueOf(series));
        String imageName = retrieve.getImageName(series);
        if (imageName == null) {
            imageName = "Series" + series;
        }
        imageName = imageName.replaceAll("/", "_");
        imageName = imageName.replaceAll("\\\\", "_");
        filename = filename.replaceAll(SERIES_NAME, imageName);
        r.setSeries(series);
        int[] coordinates = r.getZCTCoords(image);
        filename = filename.replaceAll(Z_NUM, String.valueOf(coordinates[0]));
        filename = filename.replaceAll(T_NUM, String.valueOf(coordinates[2]));
        filename = filename.replaceAll(CHANNEL_NUM, String.valueOf(coordinates[1]));
        String channelName = retrieve.getChannelName(series, coordinates[1]);
        if (channelName == null) {
            channelName = String.valueOf(coordinates[1]);
        }
        channelName = channelName.replaceAll("/", "_");
        channelName = channelName.replaceAll("\\\\", "_");
        filename = filename.replaceAll(CHANNEL_NAME, channelName);
        String date = (String)retrieve.getImageAcquisitionDate(series).getValue();
        long stamp = 0L;
        if (retrieve.getPlaneCount(series) > image && (deltaT = retrieve.getPlaneDeltaT(series, image)) != null) {
            stamp = (long)(deltaT * 1000.0);
        }
        stamp += DateTools.getTime(date, "yyyy-MM-dd'T'HH:mm:ss");
        date = DateTools.convertDate(stamp, 0);
        filename = filename.replaceAll(TIMESTAMP, date);
        return filename;
    }

    public static String[] getFilenames(String pattern, IFormatReader r) throws FormatException, IOException {
        Vector<String> filenames = new Vector<String>();
        String filename = null;
        for (int series = 0; series < r.getSeriesCount(); ++series) {
            r.setSeries(series);
            for (int image = 0; image < r.getImageCount(); ++image) {
                filename = FormatTools.getFilename(series, image, r, pattern);
                if (filenames.contains(filename)) continue;
                filenames.add(filename);
            }
        }
        return filenames.toArray(new String[0]);
    }

    public static int getImagesPerFile(String pattern, IFormatReader r) throws FormatException, IOException {
        String[] filenames = FormatTools.getFilenames(pattern, r);
        int totalPlanes = 0;
        for (int series = 0; series < r.getSeriesCount(); ++series) {
            r.setSeries(series);
            totalPlanes += r.getImageCount();
        }
        return totalPlanes / filenames.length;
    }

    public static IFormatReader getReader(IFormatReader r, Class<? extends IFormatReader> c) {
        IFormatReader[] underlying = r.getUnderlyingReaders();
        if (underlying != null) {
            int i;
            for (i = 0; i < underlying.length; ++i) {
                if (!underlying[i].getClass().isInstance(c)) continue;
                return underlying[i];
            }
            for (i = 0; i < underlying.length; ++i) {
                IFormatReader t = FormatTools.getReader(underlying[i], c);
                if (t == null) continue;
                return t;
            }
        }
        return null;
    }

    public static byte[] openThumbBytes(IFormatReader reader, int no) throws FormatException, IOException {
        ReflectedUniverse r = new ReflectedUniverse();
        byte[][] bytes = null;
        try {
            r.exec("import loci.formats.gui.AWTImageTools");
            int planeSize = FormatTools.getPlaneSize(reader);
            byte[] plane = null;
            if (planeSize < 0) {
                int width = reader.getThumbSizeX() * 4;
                int height = reader.getThumbSizeY() * 4;
                int x = (reader.getSizeX() - width) / 2;
                int y = (reader.getSizeY() - height) / 2;
                plane = reader.openBytes(no, x, y, width, height);
            } else {
                plane = reader.openBytes(no);
            }
            r.setVar("plane", plane);
            r.setVar("reader", reader);
            r.setVar("sizeX", reader.getSizeX());
            r.setVar("sizeY", reader.getSizeY());
            r.setVar("thumbSizeX", reader.getThumbSizeX());
            r.setVar("thumbSizeY", reader.getThumbSizeY());
            r.setVar("little", reader.isLittleEndian());
            r.exec("img = AWTImageTools.openImage(plane, reader, sizeX, sizeY)");
            r.exec("img = AWTImageTools.makeUnsigned(img)");
            r.exec("thumb = AWTImageTools.scale(img, thumbSizeX, thumbSizeY, false)");
            bytes = (byte[][])r.exec("AWTImageTools.getPixelBytes(thumb, little)");
        }
        catch (ReflectException exc) {
            throw new FormatException(exc);
        }
        if (bytes.length == 1) {
            return bytes[0];
        }
        int rgbChannelCount = reader.getRGBChannelCount();
        byte[] rtn = new byte[rgbChannelCount * bytes[0].length];
        for (int i = 0; i < rgbChannelCount; ++i) {
            System.arraycopy(bytes[i], 0, rtn, bytes[0].length * i, bytes[i].length);
        }
        return rtn;
    }

    public static void convert(String input, String output) throws FormatException, IOException {
        ImageReader reader = new ImageReader();
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = factory.getInstance(OMEXMLService.class);
            reader.setMetadataStore(service.createOMEXMLMetadata());
        }
        catch (DependencyException de) {
            throw new MissingLibraryException("ome-xml.jar is required to read OME-TIFF files.  Please download it from http://www.openmicroscopy.org/site/support/bio-formats/developers/java-library.html", de);
        }
        catch (ServiceException se) {
            throw new FormatException(se);
        }
        reader.setId(input);
        ImageWriter writer = new ImageWriter();
        FormatTools.convert(reader, writer, output);
    }

    public static void convert(IFormatReader input, IFormatWriter output, String outputFile) throws FormatException, IOException {
        MetadataStore store = input.getMetadataStore();
        MetadataRetrieve meta = null;
        try {
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = factory.getInstance(OMEXMLService.class);
            meta = service.asRetrieve(store);
        }
        catch (DependencyException de) {
            throw new MissingLibraryException("ome-xml.jar is required to read OME-TIFF files.  Please download it from http://www.openmicroscopy.org/site/support/bio-formats/developers/java-library.html", de);
        }
        output.setMetadataRetrieve(meta);
        output.setId(outputFile);
        for (int series = 0; series < input.getSeriesCount(); ++series) {
            input.setSeries(series);
            output.setSeries(series);
            byte[] buf = new byte[FormatTools.getPlaneSize(input)];
            for (int image = 0; image < input.getImageCount(); ++image) {
                input.openBytes(image, buf);
                output.saveBytes(image, buf);
            }
        }
        input.close();
        output.close();
    }

    public static long[] defaultMinMax(int pixelType) {
        long min = 0L;
        long max = 0L;
        switch (pixelType) {
            case 0: {
                min = -128L;
                max = 127L;
                break;
            }
            case 2: {
                min = -32768L;
                max = 32767L;
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                min = Integer.MIN_VALUE;
                max = Integer.MAX_VALUE;
                break;
            }
            case 1: {
                min = 0L;
                max = (long)Math.pow(2.0, 8.0) - 1L;
                break;
            }
            case 3: {
                min = 0L;
                max = (long)Math.pow(2.0, 16.0) - 1L;
                break;
            }
            case 5: {
                min = 0L;
                max = (long)Math.pow(2.0, 32.0) - 1L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid pixel type");
            }
        }
        long[] values = new long[]{min, max};
        return values;
    }
}

