/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.Timestamp;

public class BioRadGelReader
extends FormatReader {
    private static final int MAGIC_BYTES = 44975;
    private static final long PIXEL_OFFSET = 59654L;
    private static final long START_OFFSET = 160L;
    private static final long BASE_OFFSET = 352L;
    private long offset;
    private long diff;

    public BioRadGelReader() {
        super("Bio-Rad GEL", "1sc");
        this.domains = new String[]{"Gel/Blot Imaging"};
        this.suffixNecessary = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2;
        if (!FormatTools.validStream(stream, 2, false)) {
            return false;
        }
        return (stream.readShort() & 0xFFFF) == 44975;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int planeSize = FormatTools.getPlaneSize(this);
        if (59654L + (long)planeSize < this.in.length()) {
            if (this.diff < 0L) {
                this.in.seek(227793L);
            } else if (this.diff == 0L) {
                this.in.seek(59654L);
            } else if (this.in.length() - (long)planeSize > 61000L) {
                this.in.seek(59621L);
            } else {
                this.in.seek(this.in.length() - (long)planeSize);
            }
        } else {
            this.in.seek(this.in.length() - (long)planeSize);
        }
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        int pixel = bpp * this.getSizeC();
        this.in.skipBytes(pixel * this.getSizeX() * (this.getSizeY() - h - y));
        for (int row = h - 1; row >= 0; --row) {
            this.in.skipBytes(x * pixel);
            this.in.read(buf, row * w * pixel, w * pixel);
            this.in.skipBytes(pixel * (this.getSizeX() - w - x));
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        String check = this.in.readString(48);
        if (check.indexOf("Intel Format") != -1) {
            this.in.order(true);
        }
        this.in.seek(160L);
        boolean codeFound = false;
        int skip = 0;
        while (!codeFound) {
            short code = this.in.readShort();
            if (code == 129) {
                codeFound = true;
            }
            short length = this.in.readShort();
            this.in.skipBytes(2 + 2 * length);
            if (codeFound) {
                skip = (this.in.readShort() & 0xFFFF) - 32;
                continue;
            }
            if (length == 1) {
                this.in.skipBytes(12);
                continue;
            }
            if (length != 2) continue;
            this.in.skipBytes(10);
        }
        long baseFP = this.in.getFilePointer();
        this.diff = 352L - baseFP;
        skip = (int)((long)skip + this.diff);
        double physicalWidth = 0.0;
        double physicalHeight = 0.0;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM && baseFP + (long)skip - 8187L > 0L) {
            int space;
            this.in.seek(baseFP + (long)skip - 8187L);
            String scannerName = this.in.readCString();
            this.in.skipBytes(8);
            this.in.readCString();
            this.in.skipBytes(8);
            String imageArea = this.in.readCString();
            imageArea = imageArea.substring(imageArea.indexOf(":") + 1).trim();
            int xIndex = imageArea.indexOf("x");
            if (xIndex > 0 && (space = imageArea.indexOf(" ")) >= 0) {
                String width = imageArea.substring(1, space);
                int nextSpace = imageArea.indexOf(" ", xIndex + 2);
                if (nextSpace > xIndex) {
                    String height = imageArea.substring(xIndex + 1, nextSpace);
                    physicalWidth = Double.parseDouble(width.trim()) * 1000.0;
                    physicalHeight = Double.parseDouble(height.trim()) * 1000.0;
                }
            }
        }
        this.in.seek(baseFP + (long)skip - 298L);
        String date = this.in.readString(17);
        date = DateTools.formatDate(date, "dd-MMM-yyyy HH:mm");
        this.in.skipBytes(73);
        String scannerName = this.in.readCString();
        this.addGlobalMeta("Scanner name", scannerName);
        this.in.seek(baseFP + (long)skip);
        this.core[0].sizeX = this.in.readShort() & 0xFFFF;
        this.core[0].sizeY = this.in.readShort() & 0xFFFF;
        if ((long)(this.getSizeX() * this.getSizeY()) > this.in.length()) {
            this.in.order(true);
            this.in.seek(this.in.getFilePointer() - 4L);
            this.core[0].sizeX = this.in.readShort();
            this.core[0].sizeY = this.in.readShort();
        }
        this.in.skipBytes(2);
        short bpp = this.in.readShort();
        this.core[0].pixelType = FormatTools.pixelTypeFromBytes(bpp, false, false);
        this.offset = this.in.getFilePointer();
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].indexed = false;
        this.core[0].littleEndian = this.in.isLittleEndian();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (date != null) {
            store.setImageAcquisitionDate(new Timestamp(date), 0);
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            if (physicalWidth > 0.0) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(physicalWidth / (double)this.getSizeX()), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeX; got {}", (Object)physicalWidth);
            }
            if (physicalHeight > 0.0) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(physicalHeight / (double)this.getSizeY()), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeY; got {}", (Object)physicalHeight);
            }
        }
    }
}

