/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.DeltavisionReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetamorphReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataConverter;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import ome.xml.model.Image;
import ome.xml.model.Instrument;
import ome.xml.model.OME;
import ome.xml.model.primitives.NonNegativeInteger;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;

public class CellWorxReader
extends FormatReader {
    private static final String DATE_FORMAT = "EEE MMM dd HH:mm:ss yyyy";
    private boolean[][] fieldMap;
    private String[][][] wellFiles;
    private String[][] logFiles;
    private int fieldCount = 0;
    private boolean doChannels = false;
    private String plateLogFile;
    private String zMapFile;
    private String lastFile;
    private IFormatReader lastReader;

    public CellWorxReader() {
        super("CellWorx", new String[]{"pnl", "htd", "log"});
        this.domains = new String[]{"High-Content Screening (HCS)"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .htd file plus one or more .pnl or .tif files and optionally one or more .log files";
    }

    public boolean isThisType(String name, boolean open) {
        if (CellWorxReader.checkSuffix(name, "pnl") || CellWorxReader.checkSuffix(name, "htd")) {
            return super.isThisType(name, open);
        }
        if (!open) {
            return false;
        }
        boolean foundHTD = false;
        Location current = new Location(name).getAbsoluteFile();
        Location parent = current.getParentFile();
        String htdName = current.getName();
        while (htdName.indexOf("_") > 0) {
            if (!new Location(parent, (htdName = htdName.substring(0, htdName.lastIndexOf("_"))) + ".htd").exists() && !new Location(parent, htdName + ".HTD").exists()) continue;
            return true;
        }
        return false;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        int col;
        int row;
        FormatTools.assertId(this.currentId, true, 1);
        Vector<String> files = new Vector<String>();
        files.add(this.currentId);
        if (this.plateLogFile != null && new Location(this.plateLogFile).exists()) {
            files.add(this.plateLogFile);
        }
        if (this.zMapFile != null) {
            files.add(this.zMapFile);
        }
        if (new Location(this.logFiles[row = this.getWellRow(this.getSeries())][col = this.getWellColumn(this.getSeries())]).exists()) {
            files.add(this.logFiles[row][col]);
        }
        if (!noPixels) {
            if (CellWorxReader.checkSuffix(this.wellFiles[row][col][0], "pnl")) {
                if (new Location(this.wellFiles[row][col][0]).exists()) {
                    files.add(this.wellFiles[row][col][0]);
                }
            } else {
                for (String f : this.wellFiles[row][col]) {
                    if (!new Location(f).exists()) continue;
                    files.add(f);
                }
            }
        }
        return files.toArray(new String[files.size()]);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int fieldIndex = this.getSeries() % this.fieldCount;
        String file2 = this.getFile(this.getSeries(), no);
        if (file2 == null) {
            Arrays.fill(buf, (byte)0);
            return buf;
        }
        if (this.lastFile == null || this.lastReader == null || !file2.equals(this.lastFile) || this.lastReader.getCurrentFile() == null) {
            if (this.lastReader != null) {
                this.lastReader.close();
            }
            try {
                this.lastReader = this.getReader(file2);
            }
            catch (IOException e) {
                LOGGER.debug("", (Throwable)e);
                return buf;
            }
            this.lastFile = file2;
        }
        int planeIndex = no;
        if (this.lastReader.getSeriesCount() == this.fieldCount) {
            this.lastReader.setSeries(fieldIndex);
        } else {
            int[] zct = this.getZCTCoords(no);
            planeIndex = zct[0];
        }
        this.lastReader.openBytes(planeIndex, buf, x, y, w, h);
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.fieldMap = null;
            this.wellFiles = null;
            this.logFiles = null;
            this.fieldCount = 0;
            this.plateLogFile = null;
            this.zMapFile = null;
            this.lastFile = null;
            if (this.lastReader != null) {
                this.lastReader.close();
            }
            this.lastReader = null;
            this.doChannels = false;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (!CellWorxReader.checkSuffix(id, "htd")) {
            LOGGER.info("Searching for .htd file");
            String base = new Location(id).getAbsolutePath();
            base = base.substring(0, base.lastIndexOf("_"));
            id = base + ".HTD";
            if (!new Location(id).exists()) {
                String[] list;
                Location parent = new Location(id).getAbsoluteFile().getParentFile();
                for (String f : list = parent.list(true)) {
                    if (!CellWorxReader.checkSuffix(f, "htd")) continue;
                    id = new Location(parent, f).getAbsolutePath();
                    LOGGER.info("Found .htd file {}", (Object)f);
                    break;
                }
            }
        }
        super.initFile(id);
        String plateData = DataTools.readFile(id);
        String[] lines = plateData.split("\n");
        int xWells = 0;
        int yWells = 0;
        int xFields = 0;
        int yFields = 0;
        String[] wavelengths = null;
        int nTimepoints = 1;
        for (String line : lines) {
            int col;
            String[] mapping;
            int row;
            int split = line.indexOf("\",");
            if (split < 1) continue;
            String key = line.substring(1, split).trim();
            String value = line.substring(split + 2).trim();
            if (key.equals("XWells")) {
                xWells = Integer.parseInt(value);
                continue;
            }
            if (key.equals("YWells")) {
                yWells = Integer.parseInt(value);
                this.wellFiles = new String[yWells][xWells][];
                this.logFiles = new String[yWells][xWells];
                continue;
            }
            if (key.startsWith("WellsSelection")) {
                row = Integer.parseInt(key.substring(14)) - 1;
                mapping = value.split(",");
                for (col = 0; col < xWells; ++col) {
                    if (!new Boolean(mapping[col].trim()).booleanValue()) continue;
                    this.wellFiles[row][col] = new String[1];
                }
                continue;
            }
            if (key.equals("XSites")) {
                xFields = Integer.parseInt(value);
                continue;
            }
            if (key.equals("YSites")) {
                yFields = Integer.parseInt(value);
                this.fieldMap = new boolean[yFields][xFields];
                continue;
            }
            if (key.equals("TimePoints")) {
                nTimepoints = Integer.parseInt(value);
                continue;
            }
            if (key.startsWith("SiteSelection")) {
                row = Integer.parseInt(key.substring(13)) - 1;
                mapping = value.split(",");
                for (col = 0; col < xFields; ++col) {
                    this.fieldMap[row][col] = new Boolean(mapping[col].trim());
                }
                continue;
            }
            if (key.equals("Waves")) {
                this.doChannels = new Boolean(value.toLowerCase());
                continue;
            }
            if (key.equals("NWavelengths")) {
                wavelengths = new String[Integer.parseInt(value)];
                continue;
            }
            if (!key.startsWith("WaveName")) continue;
            int index = Integer.parseInt(key.substring(8)) - 1;
            wavelengths[index] = value.replaceAll("\"", "");
        }
        for (int row = 0; row < this.fieldMap.length; ++row) {
            for (int col = 0; col < this.fieldMap[row].length; ++col) {
                if (!this.fieldMap[row][col]) continue;
                ++this.fieldCount;
            }
        }
        String plateName = new Location(id).getAbsolutePath();
        plateName = plateName.substring(0, plateName.lastIndexOf(".")) + "_";
        int wellCount = 0;
        for (int row = 0; row < this.wellFiles.length; ++row) {
            for (int col = 0; col < this.wellFiles[row].length; ++col) {
                if (this.wellFiles[row][col] == null) continue;
                ++wellCount;
                char rowLetter = (char)(row + 65);
                String base = plateName + rowLetter + String.format("%02d", col + 1);
                this.wellFiles[row][col][0] = base + ".pnl";
                this.logFiles[row][col] = base + "_scan.log";
                if (new Location(this.wellFiles[row][col][0]).exists()) continue;
                this.wellFiles[row][col] = this.getTiffFiles(plateName, rowLetter, col, wavelengths.length, nTimepoints);
            }
        }
        this.plateLogFile = plateName + "scan.log";
        String serialNumber = null;
        if (new Location(this.plateLogFile).exists()) {
            String[] f;
            for (String line : f = DataTools.readFile(this.plateLogFile).split("\n")) {
                if (line.trim().startsWith("Z Map File")) {
                    String file2 = line.substring(line.indexOf(":") + 1);
                    file2 = file2.substring(file2.lastIndexOf("/") + 1).trim();
                    String parent = new Location(id).getAbsoluteFile().getParent();
                    this.zMapFile = new Location(parent, file2).getAbsolutePath();
                    continue;
                }
                if (!line.trim().startsWith("Scanner SN")) continue;
                serialNumber = line.substring(line.indexOf(":") + 1).trim();
            }
        }
        this.core = new CoreMetadata[this.fieldCount * wellCount];
        String file3 = this.getFile(0, 0);
        IFormatReader pnl = this.getReader(file3);
        for (int i = 0; i < this.core.length; ++i) {
            this.setSeries(i);
            this.core[i] = new CoreMetadata();
            this.core[i].littleEndian = pnl.isLittleEndian();
            this.core[i].sizeX = pnl.getSizeX();
            this.core[i].sizeY = pnl.getSizeY();
            this.core[i].pixelType = pnl.getPixelType();
            this.core[i].sizeZ = 1;
            this.core[i].sizeT = nTimepoints;
            this.core[i].sizeC = wavelengths.length;
            this.core[i].imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            this.core[i].dimensionOrder = "XYCZT";
            this.core[i].rgb = false;
            this.core[i].interleaved = pnl.isInterleaved();
        }
        OMEXMLMetadata readerMetadata = (OMEXMLMetadata)pnl.getMetadataStore();
        OME root = (OME)readerMetadata.getRoot();
        Instrument instrument = root.getInstrument(0);
        List<Image> images = root.copyImageList();
        OME convertRoot = new OME();
        convertRoot.addInstrument(instrument);
        for (int i = 0; i < this.core.length / images.size(); ++i) {
            for (Image img : images) {
                convertRoot.addImage(img);
            }
        }
        IMetadata convertMetadata = MetadataTools.createOMEXMLMetadata();
        convertMetadata.setRoot(convertRoot);
        pnl.close();
        MetadataStore store = this.makeFilterMetadata();
        MetadataConverter.convertMetadata(convertMetadata, store);
        MetadataTools.populatePixels(store, this);
        String plateID = MetadataTools.createLSID("Plate", 0);
        Location plate = new Location(id).getAbsoluteFile().getParentFile();
        store.setPlateID(plateID, 0);
        store.setPlateName(plate.getName(), 0);
        for (int i = 0; i < this.core.length; ++i) {
            store.setImageID(MetadataTools.createLSID("Image", i), i);
        }
        String plateAcqID = MetadataTools.createLSID("PlateAcquisition", 0, 0);
        store.setPlateAcquisitionID(plateAcqID, 0, 0);
        if (this.fieldMap.length * this.fieldMap[0].length > 0) {
            store.setPlateAcquisitionMaximumFieldCount(new PositiveInteger(this.fieldMap.length * this.fieldMap[0].length), 0, 0);
        } else {
            LOGGER.warn("Expected positive value for MaximumFieldCount; got {}", (Object)(this.fieldMap.length * this.fieldMap[0].length));
        }
        int nextImage = 0;
        for (int row = 0; row < this.wellFiles.length; ++row) {
            for (int col = 0; col < this.wellFiles[row].length; ++col) {
                int wellIndex = row * this.wellFiles[row].length + col;
                String wellID = MetadataTools.createLSID("Well", 0, wellIndex);
                store.setWellID(wellID, 0, wellIndex);
                store.setWellColumn(new NonNegativeInteger(col), 0, wellIndex);
                store.setWellRow(new NonNegativeInteger(row), 0, wellIndex);
                int fieldIndex = 0;
                for (int fieldRow = 0; fieldRow < this.fieldMap.length; ++fieldRow) {
                    for (int fieldCol = 0; fieldCol < this.fieldMap[fieldRow].length; ++fieldCol) {
                        if (!this.fieldMap[fieldRow][fieldCol] || this.wellFiles[row][col] == null) continue;
                        String wellSampleID = MetadataTools.createLSID("WellSample", 0, wellIndex, fieldIndex);
                        store.setWellSampleID(wellSampleID, 0, wellIndex, fieldIndex);
                        String imageID = MetadataTools.createLSID("Image", nextImage);
                        store.setWellSampleImageRef(imageID, 0, wellIndex, fieldIndex);
                        store.setWellSampleIndex(new NonNegativeInteger(nextImage), 0, wellIndex, fieldIndex);
                        store.setPlateAcquisitionWellSampleRef(wellSampleID, 0, 0, nextImage);
                        String well = (char)(row + 65) + String.format("%02d", col + 1);
                        store.setImageName("Well " + well + " Field #" + (fieldIndex + 1), nextImage);
                        ++nextImage;
                        ++fieldIndex;
                    }
                }
            }
        }
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            if (serialNumber != null) {
                store.setMicroscopeSerialNumber(serialNumber, 0);
            }
            for (int well = 0; well < wellCount; ++well) {
                this.parseWellLogFile(well, store);
            }
            for (int i = 0; i < this.core.length; ++i) {
                for (int c = 0; c < this.getSizeC(); ++c) {
                    if (c >= wavelengths.length) continue;
                    store.setChannelName(wavelengths[c], i, c);
                }
            }
        }
    }

    private int getWell(int seriesIndex) {
        int wellIndex = seriesIndex / this.fieldCount;
        int counter = -1;
        for (int row = 0; row < this.wellFiles.length; ++row) {
            for (int col = 0; col < this.wellFiles[row].length; ++col) {
                if (this.wellFiles[row][col] != null) {
                    ++counter;
                }
                if (counter != wellIndex) continue;
                return row * this.wellFiles[row].length + col;
            }
        }
        return -1;
    }

    private int getWellRow(int seriesIndex) {
        int well = this.getWell(seriesIndex);
        return well / this.wellFiles[0].length;
    }

    private int getWellColumn(int seriesIndex) {
        int well = this.getWell(seriesIndex);
        return well % this.wellFiles[0].length;
    }

    private String getFile(int seriesIndex, int no) {
        int row = this.getWellRow(seriesIndex);
        int col = this.getWellColumn(seriesIndex);
        int field = seriesIndex % this.fieldCount;
        if (this.wellFiles[row][col].length == 0) {
            return this.wellFiles[row][col][0];
        }
        int imageCount = this.wellFiles[row][col].length / this.fieldCount;
        if (field * imageCount + no < this.wellFiles[row][col].length) {
            return this.wellFiles[row][col][field * imageCount + no];
        }
        if (field < this.wellFiles[row][col].length) {
            return this.wellFiles[row][col][field];
        }
        if (imageCount == 0 && this.wellFiles[row][col].length == 1) {
            return this.wellFiles[row][col][0];
        }
        return null;
    }

    private void parseWellLogFile(int wellIndex, MetadataStore store) throws IOException {
        String[] lines;
        int seriesIndex = wellIndex * this.fieldCount;
        int row = this.getWellRow(seriesIndex);
        int col = this.getWellColumn(seriesIndex);
        int well = row * this.wellFiles[0].length + col;
        String logFile = this.logFiles[row][col];
        if (!new Location(logFile).exists()) {
            return;
        }
        LOGGER.debug("Parsing log file for well {}{}", (Object)Character.valueOf((char)(row + 65)), (Object)(col + 1));
        int oldSeries = this.getSeries();
        this.setSeries(seriesIndex);
        String data = DataTools.readFile(logFile);
        for (String line : lines = data.split("\n")) {
            String[] tokens;
            int end;
            int separator = (line = line.trim()).indexOf(":");
            if (separator < 0) continue;
            String key = line.substring(0, separator).trim();
            String value = line.substring(separator + 1).trim();
            this.addSeriesMeta(key, value);
            if (key.equals("Date")) {
                String date = DateTools.formatDate(value, DATE_FORMAT);
                for (int field = 0; field < this.fieldCount; ++field) {
                    if (date == null) continue;
                    store.setImageAcquisitionDate(new Timestamp(date), seriesIndex + field);
                }
                continue;
            }
            if (key.equals("Scan Origin")) {
                String[] axes = value.split(",");
                for (int fieldRow = 0; fieldRow < this.fieldMap.length; ++fieldRow) {
                    for (int fieldCol = 0; fieldCol < this.fieldMap[fieldRow].length; ++fieldCol) {
                        if (!this.fieldMap[fieldRow][fieldCol] || this.wellFiles[row][col] == null) continue;
                        int field = fieldRow * this.fieldMap[fieldRow].length + fieldCol;
                        store.setWellSamplePositionX(new Double(axes[0]), 0, well, field);
                        store.setWellSamplePositionY(new Double(axes[1]), 0, well, field);
                        this.addGlobalMeta("X position for position #" + (field + 1), axes[0]);
                        this.addGlobalMeta("Y position for position #" + (field + 1), axes[1]);
                    }
                }
                continue;
            }
            if (key.equals("Scan Area")) {
                int s = value.indexOf("x");
                if (s <= 0) continue;
                end = value.indexOf(" ", s + 2);
                Double xSize = new Double(value.substring(0, s).trim());
                Double ySize = new Double(value.substring(s + 1, end).trim());
                for (int field = 0; field < this.fieldCount; ++field) {
                    int index = seriesIndex + field;
                    if (xSize > 0.0) {
                        store.setPixelsPhysicalSizeX(new PositiveFloat(xSize / (double)this.getSizeX()), index);
                    } else {
                        LOGGER.warn("Expected positive value for PhysicalSizeX; got {}", (Object)(xSize / (double)this.getSizeX()));
                    }
                    if (ySize > 0.0) {
                        store.setPixelsPhysicalSizeY(new PositiveFloat(ySize / (double)this.getSizeY()), index);
                        continue;
                    }
                    LOGGER.warn("Expected positive value for PhysicalSizeY; got {}", (Object)(ySize / (double)this.getSizeY()));
                }
                continue;
            }
            if (!key.startsWith("Channel")) continue;
            int start = key.indexOf(" ") + 1;
            end = key.indexOf(" ", start);
            if (end < 0) {
                end = key.length();
            }
            int index = Integer.parseInt(key.substring(start, end)) - 1;
            for (String token : tokens = value.split(",")) {
                int slash;
                if ((token = token.trim()).startsWith("gain")) {
                    String instrumentID = MetadataTools.createLSID("Instrument", 0);
                    Double gain = new Double(token.replaceAll("gain ", ""));
                    String detectorID = MetadataTools.createLSID("Detector", 0, 0);
                    store.setInstrumentID(instrumentID, 0);
                    store.setDetectorID(detectorID, 0, 0);
                    for (int field = 0; field < this.fieldCount; ++field) {
                        store.setImageInstrumentRef(instrumentID, seriesIndex + field);
                        store.setDetectorSettingsGain(gain, seriesIndex + field, index);
                        store.setDetectorSettingsID(detectorID, seriesIndex + field, index);
                    }
                    continue;
                }
                if (!token.startsWith("EX") || (slash = token.indexOf("/")) <= 0) continue;
                String ex = token.substring(0, slash).trim();
                String em = token.substring(slash + 1).trim();
                if (ex.indexOf(" ") > 0) {
                    ex = ex.substring(ex.indexOf(" ") + 1);
                }
                if (em.indexOf(" ") > 0 && (em = em.substring(em.indexOf(" ") + 1)).indexOf(" ") > 0) {
                    em = em.substring(0, em.indexOf(" "));
                }
                Integer emission = new Integer(em);
                Integer excitation = new Integer(ex);
                for (int field = 0; field < this.fieldCount; ++field) {
                    if (excitation > 0) {
                        store.setChannelExcitationWavelength(new PositiveInteger(excitation), seriesIndex + field, index);
                    } else {
                        LOGGER.warn("Expected positive value for ExcitationWavelength; got {}", (Object)excitation);
                    }
                    if (emission > 0) {
                        store.setChannelEmissionWavelength(new PositiveInteger(emission), seriesIndex + field, index);
                        continue;
                    }
                    LOGGER.warn("Expected positive value for EmissionWavelength; got {}", (Object)emission);
                }
            }
        }
        this.setSeries(oldSeries);
    }

    private IFormatReader getReader(String file2) throws FormatException, IOException {
        FormatReader pnl = new DeltavisionReader();
        if (CellWorxReader.checkSuffix(file2, "tif")) {
            pnl = new MetamorphReader();
        }
        IMetadata metadata = MetadataTools.createOMEXMLMetadata();
        pnl.setMetadataStore(metadata);
        pnl.setId(file2);
        return pnl;
    }

    private String[] getTiffFiles(String plateName, char rowLetter, int col, int channels, int nTimepoints) {
        String base = plateName + rowLetter + String.format("%02d", col + 1);
        String[] files = new String[this.fieldCount * channels * nTimepoints];
        int nextFile = 0;
        for (int field = 0; field < this.fieldCount; ++field) {
            for (int channel = 0; channel < channels; ++channel) {
                int t = 0;
                while (t < nTimepoints) {
                    String file2 = base;
                    if (this.fieldCount > 1) {
                        file2 = file2 + "_s" + (field + 1);
                    }
                    if (this.doChannels || channels > 1) {
                        file2 = file2 + "_w" + (channel + 1);
                    }
                    if (nTimepoints > 1) {
                        file2 = file2 + "_t" + nTimepoints;
                    }
                    files[nextFile] = file2 + ".tif";
                    if (!new Location(files[nextFile]).exists()) {
                        files[nextFile] = file2 + ".TIF";
                    }
                    ++t;
                    ++nextFile;
                }
            }
        }
        boolean noneExist = true;
        for (String file3 : files) {
            if (!new Location(file3).exists()) continue;
            noneExist = false;
            break;
        }
        if (noneExist) {
            nextFile = 0;
            Location parent = new Location(this.currentId).getAbsoluteFile().getParentFile();
            Object[] list = parent.list(true);
            Arrays.sort(list);
            for (Object f : list) {
                String path;
                if (!CellWorxReader.checkSuffix((String)f, new String[]{"tif", "tiff", "pnl"}) || !(path = new Location(parent, (String)f).getAbsolutePath()).startsWith(base)) continue;
                files[nextFile++] = path;
            }
        }
        return files;
    }
}

