/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.POIService;
import loci.formats.tiff.IFD;
import loci.formats.tiff.PhotoInterp;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.Timestamp;

public class IPWReader
extends FormatReader {
    public static final int IPW_MAGIC_BYTES = -791735840;
    private Hashtable<Integer, String> imageFiles;
    private POIService poi;

    public IPWReader() {
        super("Image-Pro Workspace", "ipw");
        this.domains = new String[]{"Unknown"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 4;
        if (!FormatTools.validStream(stream, 4, false)) {
            return false;
        }
        return stream.readInt() == -791735840;
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        RandomAccessInputStream stream = this.poi.getDocumentStream(this.imageFiles.get(0));
        TiffParser tp = new TiffParser(stream);
        IFD firstIFD = tp.getFirstIFD();
        int[] bits = firstIFD.getBitsPerSample();
        if (bits[0] <= 8) {
            int[] colorMap = (int[])firstIFD.getIFDValue(320);
            if (colorMap == null) {
                return null;
            }
            byte[][] table = new byte[3][colorMap.length / 3];
            int next = 0;
            for (int j = 0; j < table.length; ++j) {
                for (int i = 0; i < table[0].length; ++i) {
                    table[j][i] = (byte)(colorMap[next++] >> 8);
                }
            }
            return table;
        }
        return null;
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            RandomAccessInputStream stream = this.poi.getDocumentStream(this.imageFiles.get(0));
            TiffParser tp = new TiffParser(stream);
            IFD ifd = tp.getFirstIFD();
            stream.close();
            return (int)ifd.getTileWidth();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile width", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.debug("Could not retrieve tile height", (Throwable)e);
        }
        return super.getOptimalTileWidth();
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        try {
            RandomAccessInputStream stream = this.poi.getDocumentStream(this.imageFiles.get(0));
            TiffParser tp = new TiffParser(stream);
            IFD ifd = tp.getFirstIFD();
            stream.close();
            return (int)ifd.getTileLength();
        }
        catch (FormatException e) {
            LOGGER.debug("Could not retrieve tile height", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.debug("Could not retrieve tile length", (Throwable)e);
        }
        return super.getOptimalTileHeight();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        RandomAccessInputStream stream = this.poi.getDocumentStream(this.imageFiles.get(no));
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        tp.getSamples(ifd, buf, x, y, w, h);
        stream.close();
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.poi != null) {
                this.poi.close();
            }
            this.poi = null;
            this.imageFiles = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        try {
            ServiceFactory factory = new ServiceFactory();
            this.poi = factory.getInstance(POIService.class);
        }
        catch (DependencyException de) {
            throw new MissingLibraryException("POI library not found", de);
        }
        this.poi.initialize(Location.getMappedId(this.currentId));
        this.imageFiles = new Hashtable();
        Vector<String> fileList = this.poi.getDocumentList();
        String description = null;
        String creationDate = null;
        for (String name : fileList) {
            String relativePath = name.substring(name.lastIndexOf(File.separator) + 1);
            if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
                if (relativePath.equals("CONTENTS")) {
                    this.addGlobalMeta("Version", new String(this.poi.getDocumentBytes(name), "UTF-8").trim());
                } else if (relativePath.equals("FrameRate")) {
                    byte[] b = this.poi.getDocumentBytes(name, 4);
                    this.addGlobalMeta("Frame Rate", DataTools.bytesToInt(b, true));
                } else if (relativePath.equals("FrameInfo")) {
                    RandomAccessInputStream s = this.poi.getDocumentStream(name);
                    s.order(true);
                    int q = 0;
                    while ((long)q < s.length() / 2L) {
                        this.addGlobalMeta("FrameInfo " + q, s.readShort());
                        ++q;
                    }
                    s.close();
                }
            }
            if (relativePath.equals("ImageInfo")) {
                description = new String(this.poi.getDocumentBytes(name), "UTF-8").trim();
                this.addGlobalMeta("Image Description", description);
                String timestamp = null;
                if (description != null) {
                    String[] tokens;
                    for (String token : tokens = description.split("\n")) {
                        String label = "Timestamp";
                        String data = token.trim();
                        if (token.indexOf("=") != -1) {
                            label = token.substring(0, token.indexOf("=")).trim();
                            data = token.substring(token.indexOf("=") + 1).trim();
                        }
                        this.addGlobalMeta(label, data);
                        if (label.equals("frames")) {
                            this.core[0].sizeT = Integer.parseInt(data);
                            continue;
                        }
                        if (label.equals("slices")) {
                            this.core[0].sizeZ = Integer.parseInt(data);
                            continue;
                        }
                        if (label.equals("channels")) {
                            this.core[0].sizeC = Integer.parseInt(data);
                            continue;
                        }
                        if (!label.equals("Timestamp")) continue;
                        timestamp = data;
                    }
                }
                if (timestamp == null) continue;
                if (timestamp.length() > 26) {
                    timestamp = timestamp.substring(timestamp.length() - 26);
                }
                creationDate = DateTools.formatDate(timestamp, "MM/dd/yyyy HH:mm:ss.SSS aa");
                continue;
            }
            if (!relativePath.equals("ImageTIFF")) continue;
            String idx = "0";
            if (!name.substring(0, name.lastIndexOf(File.separator)).equals("Root Entry")) {
                idx = name.substring(21, name.indexOf(File.separator, 22));
            }
            this.imageFiles.put(new Integer(idx), name);
        }
        LOGGER.info("Populating metadata");
        this.core[0].imageCount = this.imageFiles.size();
        RandomAccessInputStream stream = this.poi.getDocumentStream(this.imageFiles.get(0));
        TiffParser tp = new TiffParser(stream);
        IFD firstIFD = tp.getFirstIFD();
        stream.close();
        boolean bl = this.core[0].rgb = firstIFD.getSamplesPerPixel() > 1;
        if (!this.isRGB()) {
            boolean bl2 = this.core[0].indexed = firstIFD.getPhotometricInterpretation() == PhotoInterp.RGB_PALETTE;
        }
        if (this.isIndexed()) {
            this.core[0].sizeC = 1;
            this.core[0].rgb = false;
        }
        this.core[0].littleEndian = firstIFD.isLittleEndian();
        this.addGlobalMeta("slices", "1");
        this.addGlobalMeta("channels", "1");
        this.addGlobalMeta("frames", this.getImageCount());
        this.core[0].sizeX = (int)firstIFD.getImageWidth();
        this.core[0].sizeY = (int)firstIFD.getImageLength();
        String string = this.core[0].dimensionOrder = this.isRGB() ? "XYCZT" : "XYZCT";
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        if (this.getSizeZ() * this.getSizeC() * this.getSizeT() == 1 && this.getImageCount() != 1) {
            this.core[0].sizeZ = this.getImageCount();
        }
        if (this.isRGB()) {
            this.core[0].sizeC *= 3;
        }
        int bitsPerSample = firstIFD.getBitsPerSample()[0];
        this.core[0].pixelType = firstIFD.getPixelType();
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        store.setImageDescription(description, 0);
        if (creationDate != null) {
            store.setImageAcquisitionDate(new Timestamp(creationDate), 0);
        }
    }
}

