/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.NetCDFService;
import ome.xml.model.primitives.PositiveFloat;

public class MINCReader
extends FormatReader {
    private NetCDFService netcdf;
    private byte[][][] pixelData;

    public MINCReader() {
        super("MINC MRI", "mnc");
        this.domains = new String[]{"Medical Imaging"};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        if (no < this.pixelData.length) {
            for (int row = 0; row < h; ++row) {
                int srcRow = this.getSizeY() - (row + y) - 1;
                if (srcRow >= this.pixelData[no].length || x + w > this.pixelData[no][srcRow].length) continue;
                System.arraycopy(this.pixelData[no][srcRow], x * bpp, buf, row * w * bpp, w * bpp);
            }
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            if (this.netcdf != null) {
                this.netcdf.close();
            }
            this.pixelData = null;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        try {
            ServiceFactory factory = new ServiceFactory();
            this.netcdf = factory.getInstance(NetCDFService.class);
            this.netcdf.setFile(id);
        }
        catch (DependencyException e) {
            throw new MissingLibraryException(e);
        }
        Double physicalX = null;
        Double physicalY = null;
        Double physicalZ = null;
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Vector<String> variableList = this.netcdf.getVariableList();
            for (String variable : variableList) {
                Hashtable<String, Object> attributes = this.netcdf.getVariableAttributes(variable);
                Object[] keys = attributes.keySet().toArray(new String[0]);
                Arrays.sort(keys);
                for (Object key : keys) {
                    if (attributes.get(key) instanceof Object[]) {
                        Object[] o;
                        StringBuffer sb = new StringBuffer();
                        for (Object q : o = (Object[])attributes.get(key)) {
                            sb.append(q.toString());
                        }
                        this.addGlobalMeta(variable + " " + (String)key, sb.toString());
                        continue;
                    }
                    this.addGlobalMeta(variable + " " + (String)key, attributes.get(key));
                    if (!((String)key).equals("step")) continue;
                    if (variable.equals("/xspace")) {
                        physicalX = new Double(attributes.get(key).toString());
                        continue;
                    }
                    if (variable.equals("/yspace")) {
                        physicalY = new Double(attributes.get(key).toString());
                        continue;
                    }
                    if (!variable.equals("/zspace")) continue;
                    physicalZ = new Double(attributes.get(key).toString());
                }
            }
        }
        try {
            Object s;
            Object pixels = this.netcdf.getVariableValue("/image");
            if (pixels instanceof byte[][][]) {
                this.core[0].pixelType = 1;
                this.pixelData = (byte[][][])pixels;
            } else if (pixels instanceof byte[][][][]) {
                byte[][][][] actualPixels = (byte[][][][])pixels;
                this.core[0].pixelType = 1;
                this.pixelData = new byte[actualPixels.length * actualPixels[0].length][][];
                int nextPlane = 0;
                for (int t = 0; t < actualPixels.length; ++t) {
                    for (int z = 0; z < actualPixels[t].length; ++z) {
                        this.pixelData[nextPlane++] = actualPixels[t][z];
                    }
                }
            } else if (pixels instanceof short[][][]) {
                this.core[0].pixelType = 3;
                s = (short[][][])pixels;
                this.pixelData = new byte[((short[][][])s).length][][];
                for (int i = 0; i < ((short[][][])s).length; ++i) {
                    this.pixelData[i] = new byte[s[i].length][];
                    for (int j = 0; j < s[i].length; ++j) {
                        this.pixelData[i][j] = DataTools.shortsToBytes(s[i][j], this.isLittleEndian());
                    }
                }
            } else if (pixels instanceof int[][][]) {
                this.core[0].pixelType = 5;
                s = (int[][][])pixels;
                this.pixelData = new byte[((short[][][])s).length][][];
                for (int i = 0; i < ((short[][][])s).length; ++i) {
                    this.pixelData[i] = new byte[s[i].length][];
                    for (int j = 0; j < s[i].length; ++j) {
                        this.pixelData[i][j] = DataTools.intsToBytes(s[i][j], this.isLittleEndian());
                    }
                }
            } else if (pixels instanceof float[][][]) {
                this.core[0].pixelType = 6;
                s = (float[][][])pixels;
                this.pixelData = new byte[((short[][][])s).length][][];
                for (int i = 0; i < ((short[][][])s).length; ++i) {
                    this.pixelData[i] = new byte[s[i].length][];
                    for (int j = 0; j < s[i].length; ++j) {
                        this.pixelData[i][j] = DataTools.floatsToBytes(s[i][j], this.isLittleEndian());
                    }
                }
            } else if (pixels instanceof double[][][]) {
                this.core[0].pixelType = 7;
                s = (double[][][])pixels;
                this.pixelData = new byte[((short[][][])s).length][][];
                for (int i = 0; i < ((short[][][])s).length; ++i) {
                    this.pixelData[i] = new byte[s[i].length][];
                    for (int j = 0; j < s[i].length; ++j) {
                        this.pixelData[i][j] = DataTools.doublesToBytes(s[i][j], this.isLittleEndian());
                    }
                }
            }
        }
        catch (ServiceException e) {
            throw new FormatException(e);
        }
        this.core[0].sizeX = this.netcdf.getDimension("/xspace");
        this.core[0].sizeY = this.netcdf.getDimension("/yspace");
        this.core[0].sizeZ = this.netcdf.getDimension("/zspace");
        try {
            this.core[0].sizeT = this.netcdf.getDimension("/time");
        }
        catch (NullPointerException e) {
            this.core[0].sizeT = 1;
        }
        this.core[0].sizeC = 1;
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
        this.core[0].rgb = false;
        this.core[0].indexed = false;
        this.core[0].dimensionOrder = "XYZCT";
        this.addGlobalMeta("Comment", this.netcdf.getAttributeValue("/history"));
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            store.setImageDescription(this.netcdf.getAttributeValue("/history"), 0);
            if (physicalX != null && physicalX > 0.0) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(physicalX), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeX; got {}", (Object)physicalX);
            }
            if (physicalY != null && physicalY > 0.0) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(physicalY), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeY; got {}", (Object)physicalY);
            }
            if (physicalZ != null && physicalZ > 0.0) {
                store.setPixelsPhysicalSizeZ(new PositiveFloat(physicalZ), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeZ; got {}", (Object)physicalZ);
            }
        }
    }
}

