/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.formats.ClassList;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.UnsupportedCompressionException;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;

public class NRRDReader
extends FormatReader {
    public static final String NRRD_MAGIC_STRING = "NRRD";
    private ImageReader helper;
    private String dataFile;
    private String encoding;
    private long offset;
    private String[] pixelSizes;
    private boolean lookForCompanion = true;

    public NRRDReader() {
        super(NRRD_MAGIC_STRING, new String[]{"nrrd", "nhdr"});
        this.domains = new String[]{"Unknown"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "A single .nrrd file or one .nhdr file and one other file containing the pixels";
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getSizeY();
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return NRRDReader.checkSuffix(id, "nrrd");
    }

    public boolean isThisType(String name, boolean open) {
        if (super.isThisType(name, open)) {
            return true;
        }
        if (!open) {
            return false;
        }
        Location header = new Location(name + ".nhdr");
        if (header.exists()) {
            return true;
        }
        if (name.indexOf(".") >= 0) {
            name = name.substring(0, name.lastIndexOf("."));
        }
        header = new Location(name + ".nhdr");
        return header.exists();
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = NRRD_MAGIC_STRING.length();
        if (!FormatTools.validStream(stream, blockLen, false)) {
            return false;
        }
        return stream.readString(blockLen).startsWith(NRRD_MAGIC_STRING);
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            if (this.dataFile == null) {
                return null;
            }
            return new String[]{this.currentId};
        }
        if (this.dataFile == null) {
            return new String[]{this.currentId};
        }
        return new String[]{this.currentId, this.dataFile};
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        if (this.dataFile == null) {
            if (this.encoding.equals("raw")) {
                long planeSize = FormatTools.getPlaneSize(this);
                this.in.seek(this.offset + (long)no * planeSize);
                this.readPlane(this.in, x, y, w, h, buf);
                return buf;
            }
            throw new UnsupportedCompressionException("Unsupported encoding: " + this.encoding);
        }
        if (this.encoding.equals("raw")) {
            RandomAccessInputStream s = new RandomAccessInputStream(this.dataFile);
            s.seek(this.offset + (long)(no * FormatTools.getPlaneSize(this)));
            this.readPlane(s, x, y, w, h, buf);
            s.close();
            return buf;
        }
        return this.helper.openBytes(no, buf, x, y, w, h);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.helper != null) {
            this.helper.close(fileOnly);
        }
        if (!fileOnly) {
            this.helper = null;
            this.encoding = null;
            this.dataFile = null;
            this.offset = 0L;
            this.pixelSizes = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initFile(String id) throws FormatException, IOException {
        if (!NRRDReader.checkSuffix(id, "nhdr") && !NRRDReader.checkSuffix(id, "nrrd")) {
            if (!new Location(id = id + ".nhdr").exists()) {
                id = id.substring(0, id.lastIndexOf("."));
                id = id.substring(0, id.lastIndexOf("."));
                id = id + ".nhdr";
            }
            id = new Location(id).getAbsolutePath();
        }
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        ClassList<IFormatReader> classes = ImageReader.getDefaultReaderClasses();
        Class<IFormatReader>[] classArray = classes.getClasses();
        ClassList<IFormatReader> newClasses = new ClassList<IFormatReader>(IFormatReader.class);
        for (Class<IFormatReader> c : classArray) {
            if (c.equals(NRRDReader.class)) continue;
            newClasses.addClass(c);
        }
        this.helper = new ImageReader(newClasses);
        int numDimensions = 0;
        this.core[0].sizeX = 1;
        this.core[0].sizeY = 1;
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = 1;
        this.core[0].sizeT = 1;
        this.core[0].dimensionOrder = "XYCZT";
        String line = this.in.readLine();
        while (line != null && line.length() > 0) {
            if (!line.startsWith("#") && !line.startsWith(NRRD_MAGIC_STRING)) {
                String key = line.substring(0, line.indexOf(":")).trim();
                String v = line.substring(line.indexOf(":") + 1).trim();
                this.addGlobalMeta(key, v);
                if (key.equals("type")) {
                    if (v.indexOf("char") != -1 || v.indexOf("8") != -1) {
                        this.core[0].pixelType = 1;
                    } else if (v.indexOf("short") != -1 || v.indexOf("16") != -1) {
                        this.core[0].pixelType = 3;
                    } else if (v.equals("int") || v.equals("signed int") || v.equals("int32") || v.equals("int32_t") || v.equals("uint") || v.equals("unsigned int") || v.equals("uint32") || v.equals("uint32_t")) {
                        this.core[0].pixelType = 5;
                    } else if (v.equals("float")) {
                        this.core[0].pixelType = 6;
                    } else {
                        if (!v.equals("double")) throw new FormatException("Unsupported data type: " + v);
                        this.core[0].pixelType = 7;
                    }
                } else if (key.equals("dimension")) {
                    numDimensions = Integer.parseInt(v);
                } else if (key.equals("sizes")) {
                    String[] tokens = v.split(" ");
                    for (int i = 0; i < numDimensions; ++i) {
                        int size = Integer.parseInt(tokens[i]);
                        if (numDimensions >= 3 && i == 0 && size > 1 && size <= 16) {
                            this.core[0].sizeC = size;
                            continue;
                        }
                        if (i == 0 || this.getSizeC() > 1 && i == 1) {
                            this.core[0].sizeX = size;
                            continue;
                        }
                        if (i == 1 || this.getSizeC() > 1 && i == 2) {
                            this.core[0].sizeY = size;
                            continue;
                        }
                        if (i == 2 || this.getSizeC() > 1 && i == 3) {
                            this.core[0].sizeZ = size;
                            continue;
                        }
                        if (i != 3 && (this.getSizeC() <= 1 || i != 4)) continue;
                        this.core[0].sizeT = size;
                    }
                } else if (key.equals("data file") || key.equals("datafile")) {
                    this.dataFile = v;
                } else if (key.equals("encoding")) {
                    this.encoding = v;
                } else if (key.equals("endian")) {
                    this.core[0].littleEndian = v.equals("little");
                } else if (key.equals("spacings")) {
                    this.pixelSizes = v.split(" ");
                } else if (key.equals("byte skip")) {
                    this.offset = Long.parseLong(v);
                }
            }
            if ((line = this.in.readLine()) == null) continue;
            line = line.trim();
        }
        if (this.dataFile == null) {
            this.offset = this.in.getFilePointer();
        } else {
            Location f = new Location(this.currentId).getAbsoluteFile();
            Location parent = f.getParentFile();
            if (f.exists() && parent != null) {
                this.dataFile = this.dataFile.substring(this.dataFile.indexOf(File.separator) + 1);
                this.dataFile = new Location(parent, this.dataFile).getAbsolutePath();
            }
            if (!this.encoding.equals("raw")) {
                this.helper.setId(this.dataFile);
            }
        }
        this.core[0].rgb = this.getSizeC() > 1;
        this.core[0].interleaved = true;
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT();
        this.core[0].indexed = false;
        this.core[0].falseColor = false;
        this.core[0].metadataComplete = true;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM || this.pixelSizes == null) return;
        for (int i = 0; i < this.pixelSizes.length; ++i) {
            if (this.pixelSizes[i] == null) continue;
            try {
                Double d = new Double(this.pixelSizes[i].trim());
                if (d > 0.0) {
                    if (i == 0) {
                        store.setPixelsPhysicalSizeX(new PositiveFloat(d), 0);
                        continue;
                    }
                    if (i == 1) {
                        store.setPixelsPhysicalSizeY(new PositiveFloat(d), 0);
                        continue;
                    }
                    if (i != 2) continue;
                    store.setPixelsPhysicalSizeZ(new PositiveFloat(d), 0);
                    continue;
                }
                LOGGER.warn("Expected positive value for PhysicalSize; got {}", (Object)d);
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }
}

