/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.PositiveInteger;
import ome.xml.model.primitives.Timestamp;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class PrairieReader
extends FormatReader {
    public static final String[] CFG_SUFFIX = new String[]{"cfg"};
    public static final String[] XML_SUFFIX = new String[]{"xml"};
    public static final String[] PRAIRIE_SUFFIXES = new String[]{"cfg", "xml"};
    private static final int PRAIRIE_TAG_1 = 33628;
    private static final int PRAIRIE_TAG_2 = 33629;
    private static final int PRAIRIE_TAG_3 = 33630;
    private String[] files;
    private TiffReader tiff;
    private String xmlFile;
    private String cfgFile;
    private Vector<String> f;
    private Vector<String> gains;
    private Vector<String> offsets;
    private double pixelSizeX;
    private double pixelSizeY;
    private String date;
    private String laserPower;
    private String microscopeModel;
    private String objectiveManufacturer;
    private PositiveInteger magnification;
    private String immersion;
    private Double lensNA;
    private Double waitTime;
    private Vector<Double> positionX = new Vector();
    private Vector<Double> positionY = new Vector();
    private Vector<Double> positionZ = new Vector();
    private Vector<String> channels = new Vector();
    private boolean invertX;
    private boolean invertY;
    private Hashtable<String, Double> relativeTimes = new Hashtable();
    private Double zoom;
    private boolean timeSeries = false;

    public PrairieReader() {
        super("Prairie TIFF", new String[]{"tif", "tiff", "cfg", "xml"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
        this.datasetDescription = "One .xml file, one .cfg file, and one or more .tif/.tiff files";
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        return false;
    }

    public boolean isThisType(String name, boolean open) {
        if (!open) {
            return false;
        }
        Location file2 = new Location(name).getAbsoluteFile();
        Location parent = file2.getParentFile();
        String prefix = file2.getName();
        if (prefix.indexOf(".") != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        if (PrairieReader.checkSuffix(name, CFG_SUFFIX)) {
            if (prefix.lastIndexOf("Config") == -1) {
                return false;
            }
            prefix = prefix.substring(0, prefix.lastIndexOf("Config"));
        }
        Location xml = new Location(parent, prefix + ".xml");
        while (!xml.exists() && prefix.indexOf("_") != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("_"));
            xml = new Location(parent, prefix + ".xml");
        }
        boolean validXML = false;
        try {
            RandomAccessInputStream xmlStream = new RandomAccessInputStream(xml.getAbsolutePath());
            validXML = this.isThisType(xmlStream);
            xmlStream.close();
        }
        catch (IOException e) {
            LOGGER.trace("Failed to check XML file's type", (Throwable)e);
        }
        return xml.exists() && super.isThisType(name, false) && validXML;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = (int)Math.min(0x100020L, stream.length());
        if (!FormatTools.validStream(stream, blockLen, false)) {
            return false;
        }
        String s = stream.readString(blockLen);
        if (s.indexOf("xml") != -1 && s.indexOf("PV") != -1) {
            return true;
        }
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            return false;
        }
        String software = null;
        try {
            software = ifd.getIFDStringValue(305);
        }
        catch (FormatException exc) {
            return false;
        }
        if (software == null) {
            return false;
        }
        if (software.indexOf("Prairie") < 0) {
            return false;
        }
        return ifd.containsKey(new Integer(33628)) && ifd.containsKey(new Integer(33629)) && ifd.containsKey(new Integer(33630));
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            return new String[]{this.xmlFile, this.cfgFile};
        }
        Vector<String> s = new Vector<String>();
        if (this.files != null) {
            for (String file2 : this.files) {
                s.add(file2);
            }
        }
        if (this.xmlFile != null) {
            s.add(this.xmlFile);
        }
        if (this.cfgFile != null) {
            s.add(this.cfgFile);
        }
        return s.toArray(new String[s.size()]);
    }

    public int getOptimalTileWidth() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiff.getOptimalTileWidth();
    }

    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiff.getOptimalTileHeight();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.tiff.setId(this.files[no]);
        return this.tiff.openBytes(0, buf, x, y, w, h);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.tiff != null) {
            this.tiff.close(fileOnly);
        }
        if (!fileOnly) {
            this.cfgFile = null;
            this.xmlFile = null;
            this.tiff = null;
            this.files = null;
            this.offsets = null;
            this.gains = null;
            this.f = null;
            this.pixelSizeY = 0.0;
            this.pixelSizeX = 0.0;
            this.laserPower = null;
            this.date = null;
            this.microscopeModel = null;
            this.objectiveManufacturer = null;
            this.magnification = null;
            this.immersion = null;
            this.lensNA = null;
            this.positionX.clear();
            this.positionY.clear();
            this.positionZ.clear();
            this.channels.clear();
            this.zoom = null;
            this.waitTime = null;
            this.relativeTimes.clear();
            this.timeSeries = false;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.tiff = new TiffReader();
        this.f = new Vector();
        this.gains = new Vector();
        this.offsets = new Vector();
        if (PrairieReader.checkSuffix(id, XML_SUFFIX)) {
            this.xmlFile = id;
            this.initXML();
            this.findAndParseCFG();
        } else if (PrairieReader.checkSuffix(id, CFG_SUFFIX)) {
            this.cfgFile = id;
            this.initCFG();
            this.findAndParseXML();
        } else if (this.isGroupFiles()) {
            String[] listing;
            LOGGER.info("Finding XML file");
            Location file2 = new Location(id).getAbsoluteFile();
            Location parent = file2.getParentFile();
            for (String name : listing = parent.list()) {
                if (!PrairieReader.checkSuffix(name, PRAIRIE_SUFFIXES)) continue;
                this.initFile(new Location(parent, name).getAbsolutePath());
                return;
            }
        } else {
            this.files = new String[]{id};
            this.tiff.setId(this.files[0]);
            this.core = this.tiff.getCoreMetadata();
            this.metadataStore = this.tiff.getMetadataStore();
            Hashtable<String, Object> globalMetadata = this.tiff.getGlobalMetadata();
            for (String key : globalMetadata.keySet()) {
                this.addGlobalMeta(key.toString(), globalMetadata.get(key));
            }
        }
        this.currentId = this.xmlFile;
        this.populateMetadataStore();
    }

    private void populateMetadataStore() throws FormatException {
        LOGGER.info("Populating OME metadata");
        boolean minimumMetadata = this.getMetadataOptions().getMetadataLevel() == MetadataLevel.MINIMUM;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this, !minimumMetadata);
        if (this.date != null) {
            this.date = DateTools.formatDate(this.date, "MM/dd/yyyy h:mm:ss a");
        }
        if (this.date != null) {
            store.setImageAcquisitionDate(new Timestamp(this.date), 0);
        }
        if (!minimumMetadata) {
            int i;
            String instrumentID = MetadataTools.createLSID("Instrument", 0);
            store.setInstrumentID(instrumentID, 0);
            store.setImageInstrumentRef(instrumentID, 0);
            if (this.pixelSizeX > 0.0) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(this.pixelSizeX), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeX; got {}", (Object)this.pixelSizeX);
            }
            if (this.pixelSizeY > 0.0) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(this.pixelSizeY), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeY; got {}", (Object)this.pixelSizeY);
            }
            store.setPixelsTimeIncrement(this.waitTime, 0);
            for (i = 0; i < this.getSizeC(); ++i) {
                String offset;
                String gain = i < this.gains.size() ? this.gains.get(i) : null;
                String string = offset = i < this.offsets.size() ? this.offsets.get(i) : null;
                if (offset != null) {
                    try {
                        store.setDetectorSettingsOffset(new Double(offset), 0, i);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (gain != null) {
                    try {
                        store.setDetectorSettingsGain(new Double(gain), 0, i);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                String detectorID = MetadataTools.createLSID("Detector", 0, i);
                store.setDetectorID(detectorID, 0, i);
                store.setDetectorSettingsID(detectorID, 0, i);
                store.setDetectorType(this.getDetectorType("Other"), 0, i);
                store.setDetectorZoom(this.zoom, 0, i);
                if (i >= this.channels.size()) continue;
                store.setChannelName(this.channels.get(i), 0, i);
            }
            for (i = 0; i < this.getImageCount(); ++i) {
                int[] zct = this.getZCTCoords(i);
                int index = FormatTools.getIndex(this.getDimensionOrder(), this.getSizeZ(), 1, this.getSizeT(), this.getImageCount() / this.getSizeC(), zct[0], 0, zct[2]);
                double xPos = this.positionX.get(index);
                double yPos = this.positionY.get(index);
                double zPos = this.positionZ.get(index);
                if (!Double.isNaN(xPos)) {
                    store.setPlanePositionX(xPos, 0, i);
                }
                if (!Double.isNaN(yPos)) {
                    store.setPlanePositionY(yPos, 0, i);
                }
                if (!Double.isNaN(zPos)) {
                    store.setPlanePositionZ(zPos, 0, i);
                }
                store.setPlaneDeltaT(this.relativeTimes.get(String.valueOf(i + 1)), 0, i);
            }
            if (this.microscopeModel != null) {
                store.setMicroscopeModel(this.microscopeModel, 0);
            }
            String objective = MetadataTools.createLSID("Objective", 0, 0);
            store.setObjectiveID(objective, 0, 0);
            store.setObjectiveSettingsID(objective, 0);
            if (this.magnification != null) {
                store.setObjectiveNominalMagnification(this.magnification, 0, 0);
            }
            store.setObjectiveManufacturer(this.objectiveManufacturer, 0, 0);
            store.setObjectiveImmersion(this.getImmersion(this.immersion), 0, 0);
            store.setObjectiveCorrection(this.getCorrection("Other"), 0, 0);
            store.setObjectiveLensNA(this.lensNA, 0, 0);
            if (this.laserPower != null) {
                String laser = MetadataTools.createLSID("LightSource", 0, 0);
                store.setLaserID(laser, 0, 0);
                try {
                    store.setLaserPower(new Double(this.laserPower), 0, 0);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }

    private void initXML() throws FormatException, IOException {
        LOGGER.info("Parsing XML file");
        String xml = XMLTools.sanitizeXML(DataTools.readFile(this.xmlFile)).trim();
        PrairieHandler handler = new PrairieHandler();
        XMLTools.parseXML(xml, (DefaultHandler)handler);
        this.core[0].sizeT = this.getImageCount() / (this.getSizeZ() * this.getSizeC());
        if (this.timeSeries && this.getSizeT() == 1 && this.getSizeZ() > 1) {
            this.core[0].sizeT = this.getSizeZ();
            this.core[0].sizeZ = 1;
        }
        this.files = new String[this.f.size()];
        this.f.copyInto(this.files);
        this.tiff.setId(this.files[0]);
        LOGGER.info("Populating metadata");
        if (this.getSizeZ() == 0) {
            this.core[0].sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        this.core[0].dimensionOrder = "XYCZT";
        this.core[0].pixelType = 3;
        this.core[0].rgb = false;
        this.core[0].interleaved = false;
        this.core[0].littleEndian = this.tiff.isLittleEndian();
        this.core[0].indexed = this.tiff.isIndexed();
        this.core[0].falseColor = false;
    }

    private void initCFG() throws FormatException, IOException {
        LOGGER.info("Parsing CFG file");
        String xml = XMLTools.sanitizeXML(DataTools.readFile(this.cfgFile)).trim();
        PrairieHandler handler = new PrairieHandler();
        XMLTools.parseXML(xml, (DefaultHandler)handler);
    }

    private String find(String[] suffix) {
        String[] listing;
        File file2 = new File(this.currentId).getAbsoluteFile();
        File parent = file2.getParentFile();
        for (String name : listing = file2.exists() ? parent.list() : Location.getIdMap().keySet().toArray(new String[0])) {
            if (!PrairieReader.checkSuffix(name, suffix)) continue;
            String dir = "";
            if (file2.exists() && !(dir = parent.getPath()).endsWith(File.separator)) {
                dir = dir + File.separator;
            }
            return dir + name;
        }
        return null;
    }

    private void findAndParseCFG() throws FormatException, IOException {
        this.cfgFile = this.find(CFG_SUFFIX);
        this.initCFG();
    }

    private void findAndParseXML() throws FormatException, IOException {
        this.xmlFile = this.find(XML_SUFFIX);
        this.initXML();
    }

    public class PrairieHandler
    extends BaseHandler {
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            block29: {
                block33: {
                    String value;
                    String key;
                    block49: {
                        block48: {
                            block47: {
                                block46: {
                                    block45: {
                                        block44: {
                                            block43: {
                                                block42: {
                                                    block41: {
                                                        block40: {
                                                            block39: {
                                                                block38: {
                                                                    block37: {
                                                                        block36: {
                                                                            block35: {
                                                                                block34: {
                                                                                    block32: {
                                                                                        int cIndex;
                                                                                        block31: {
                                                                                            int zIndex;
                                                                                            block30: {
                                                                                                block28: {
                                                                                                    if (!qName.equals("PVScan")) break block28;
                                                                                                    PrairieReader.this.date = attributes.getValue("date");
                                                                                                    break block29;
                                                                                                }
                                                                                                if (!qName.equals("Sequence")) break block30;
                                                                                                String type = attributes.getValue("type");
                                                                                                PrairieReader.this.timeSeries = "TSeries Timed Element".equals(type);
                                                                                                break block29;
                                                                                            }
                                                                                            if (!qName.equals("Frame")) break block31;
                                                                                            String index = attributes.getValue("index");
                                                                                            if (index != null && (zIndex = Integer.parseInt(index)) > PrairieReader.this.getSizeZ()) {
                                                                                                ++((PrairieReader)PrairieReader.this).core[0].sizeZ;
                                                                                            }
                                                                                            PrairieReader.this.relativeTimes.put(index, new Double(attributes.getValue("relativeTime")));
                                                                                            break block29;
                                                                                        }
                                                                                        if (!qName.equals("File")) break block32;
                                                                                        ++((PrairieReader)PrairieReader.this).core[0].imageCount;
                                                                                        File current = new File(PrairieReader.this.currentId).getAbsoluteFile();
                                                                                        String dir = "";
                                                                                        if (current.exists()) {
                                                                                            dir = current.getPath();
                                                                                            dir = dir.substring(0, dir.lastIndexOf(File.separator) + 1);
                                                                                        }
                                                                                        PrairieReader.this.f.add(dir + attributes.getValue("filename"));
                                                                                        String ch = attributes.getValue("channel");
                                                                                        String channelName = attributes.getValue("channelName");
                                                                                        if (channelName == null) {
                                                                                            channelName = ch;
                                                                                        }
                                                                                        if (ch == null || (cIndex = Integer.parseInt(ch)) <= PrairieReader.this.getSizeC() || PrairieReader.this.channels.contains(channelName)) break block29;
                                                                                        ++((PrairieReader)PrairieReader.this).core[0].sizeC;
                                                                                        PrairieReader.this.channels.add(channelName);
                                                                                        break block29;
                                                                                    }
                                                                                    if (!qName.equals("Key")) break block33;
                                                                                    key = attributes.getValue("key");
                                                                                    value = attributes.getValue("value");
                                                                                    PrairieReader.this.addGlobalMeta(key, value);
                                                                                    if (!key.equals("pixelsPerLine")) break block34;
                                                                                    ((PrairieReader)PrairieReader.this).core[0].sizeX = Integer.parseInt(value);
                                                                                    break block29;
                                                                                }
                                                                                if (!key.equals("linesPerFrame")) break block35;
                                                                                ((PrairieReader)PrairieReader.this).core[0].sizeY = Integer.parseInt(value);
                                                                                break block29;
                                                                            }
                                                                            if (!key.equals("micronsPerPixel_XAxis")) break block36;
                                                                            try {
                                                                                PrairieReader.this.pixelSizeX = Double.parseDouble(value);
                                                                            }
                                                                            catch (NumberFormatException e) {}
                                                                            break block29;
                                                                        }
                                                                        if (!key.equals("micronsPerPixel_YAxis")) break block37;
                                                                        try {
                                                                            PrairieReader.this.pixelSizeY = Double.parseDouble(value);
                                                                        }
                                                                        catch (NumberFormatException e) {}
                                                                        break block29;
                                                                    }
                                                                    if (!key.equals("objectiveLens")) break block38;
                                                                    String[] tokens = value.split(" ");
                                                                    if (tokens.length > 0) {
                                                                        PrairieReader.this.objectiveManufacturer = tokens[0];
                                                                    }
                                                                    if (tokens.length > 1) {
                                                                        String mag = tokens[1].toLowerCase().replaceAll("x", "");
                                                                        try {
                                                                            Integer m = new Integer(mag);
                                                                            if (m > 0) {
                                                                                PrairieReader.this.magnification = new PositiveInteger(m);
                                                                            } else {
                                                                                LOGGER.warn("Expected positive value for NominalMagnification; got {}", (Object)m);
                                                                            }
                                                                        }
                                                                        catch (NumberFormatException e) {
                                                                            // empty catch block
                                                                        }
                                                                    }
                                                                    if (tokens.length <= 2) break block29;
                                                                    PrairieReader.this.immersion = tokens[2];
                                                                    break block29;
                                                                }
                                                                if (!key.equals("objectiveLensNA")) break block39;
                                                                try {
                                                                    PrairieReader.this.lensNA = new Double(value);
                                                                }
                                                                catch (NumberFormatException e) {}
                                                                break block29;
                                                            }
                                                            if (!key.equals("imagingDevice")) break block40;
                                                            PrairieReader.this.microscopeModel = value;
                                                            break block29;
                                                        }
                                                        if (!key.startsWith("pmtGain_")) break block41;
                                                        PrairieReader.this.gains.add(value);
                                                        break block29;
                                                    }
                                                    if (!key.startsWith("pmtOffset_")) break block42;
                                                    PrairieReader.this.offsets.add(value);
                                                    break block29;
                                                }
                                                if (!key.equals("laserPower_0")) break block43;
                                                PrairieReader.this.laserPower = value;
                                                break block29;
                                            }
                                            if (!key.equals("positionCurrent_XAxis")) break block44;
                                            try {
                                                Double xPos = new Double(value);
                                                PrairieReader.this.positionX.add(PrairieReader.this.invertX ? -xPos.doubleValue() : xPos);
                                                PrairieReader.this.addGlobalMeta("X position for position #" + PrairieReader.this.positionX.size(), xPos);
                                            }
                                            catch (NumberFormatException e) {
                                                PrairieReader.this.positionX.add(Double.NaN);
                                            }
                                            break block29;
                                        }
                                        if (!key.equals("positionCurrent_YAxis")) break block45;
                                        try {
                                            Double yPos = new Double(value);
                                            PrairieReader.this.positionY.add(PrairieReader.this.invertY ? -yPos.doubleValue() : yPos);
                                            PrairieReader.this.addGlobalMeta("Y position for position #" + PrairieReader.this.positionY.size(), yPos);
                                        }
                                        catch (NumberFormatException e) {
                                            PrairieReader.this.positionY.add(Double.NaN);
                                        }
                                        break block29;
                                    }
                                    if (!key.equals("positionCurrent_ZAxis")) break block46;
                                    try {
                                        Double zPos = new Double(value);
                                        PrairieReader.this.positionZ.add(zPos);
                                        PrairieReader.this.addGlobalMeta("Z position for position #" + PrairieReader.this.positionZ.size(), zPos);
                                    }
                                    catch (NumberFormatException e) {
                                        PrairieReader.this.positionZ.add(Double.NaN);
                                    }
                                    break block29;
                                }
                                if (!key.equals("opticalZoom")) break block47;
                                try {
                                    PrairieReader.this.zoom = new Double(value);
                                }
                                catch (NumberFormatException e) {}
                                break block29;
                            }
                            if (!key.equals("bitDepth")) break block48;
                            ((PrairieReader)PrairieReader.this).core[0].bitsPerPixel = Integer.parseInt(value);
                            break block29;
                        }
                        if (!key.equals("xYStageXPositionIncreasesLeftToRight")) break block49;
                        PrairieReader.this.invertX = value.equals("True");
                        if (!PrairieReader.this.invertX) break block29;
                        for (int i = 0; i < PrairieReader.this.positionX.size(); ++i) {
                            Double xPos = (Double)PrairieReader.this.positionX.get(i);
                            if (xPos == null || xPos.isNaN()) continue;
                            PrairieReader.this.positionX.set(i, -xPos.doubleValue());
                        }
                        break block29;
                    }
                    if (!key.equals("xYStageYPositionIncreasesBottomToTop")) break block29;
                    PrairieReader.this.invertY = value.equals("True");
                    if (PrairieReader.this.invertY) {
                        for (int i = 0; i < PrairieReader.this.positionY.size(); ++i) {
                            Double yPos = (Double)PrairieReader.this.positionY.get(i);
                            if (yPos == null || yPos.isNaN()) continue;
                            PrairieReader.this.positionY.set(i, -yPos.doubleValue());
                        }
                    }
                    break block29;
                }
                if (!qName.equals("PVTSeriesElementWait")) break block29;
                try {
                    PrairieReader.this.waitTime = new Double(attributes.getValue("waitTime"));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
    }
}

