/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import loci.common.DataTools;
import loci.common.DateTools;
import loci.common.Location;
import loci.common.RandomAccessInputStream;
import loci.common.xml.XMLTools;
import loci.formats.AxisGuesser;
import loci.formats.CoreMetadata;
import loci.formats.FilePattern;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.LeicaHandler;
import loci.formats.in.MetadataLevel;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataStore;
import loci.formats.tiff.IFD;
import loci.formats.tiff.IFDList;
import loci.formats.tiff.TiffParser;
import ome.xml.model.primitives.PositiveFloat;
import org.xml.sax.helpers.DefaultHandler;

public class TCSReader
extends FormatReader {
    public static final String DATE_FORMAT = "yyyy:MM:dd HH:mm:ss.SSS";
    public static final String PREFIX = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><LEICA>";
    public static final String SUFFIX = "</LEICA>";
    public static final String[] XML_SUFFIX = new String[]{"xml"};
    private Vector<String> tiffs;
    private TiffReader[] tiffReaders;
    private TiffParser tiffParser;
    private int lastPlane = 0;
    private long datestamp;
    private String xmlFile;
    private double voxelX;
    private double voxelY;
    private double voxelZ;

    public TCSReader() {
        super("Leica TCS TIFF", new String[]{"tif", "tiff", "xml"});
        this.domains = new String[]{"Light Microscopy"};
        this.hasCompanionFiles = true;
    }

    public boolean isSingleFile(String id) throws FormatException, IOException {
        String[] list;
        if (TCSReader.checkSuffix(id, "xml")) {
            return false;
        }
        Location file2 = new Location(id);
        for (String f : list = file2.getParentFile().list()) {
            if (!TCSReader.checkSuffix(f, "xml") || !DataTools.samePrefix(file2.getName(), f)) continue;
            return false;
        }
        return true;
    }

    public boolean isThisType(String name, boolean open) {
        Location lei;
        if (!open) {
            return false;
        }
        String prefix = name;
        if (prefix.indexOf(".") != -1) {
            prefix = prefix.substring(0, prefix.lastIndexOf("."));
        }
        if (!(lei = new Location(prefix + ".lei")).exists()) {
            lei = new Location(prefix + ".LEI");
            while (!lei.exists() && prefix.indexOf("_") != -1) {
                lei = new Location((prefix = prefix.substring(0, prefix.lastIndexOf("_"))) + ".lei");
                if (lei.exists()) continue;
                lei = new Location(prefix + ".LEI");
            }
        }
        if (lei.exists()) {
            return false;
        }
        try {
            RandomAccessInputStream s = new RandomAccessInputStream(name);
            boolean isThisType = this.isThisType(s);
            s.close();
            return isThisType;
        }
        catch (IOException e) {
            LOGGER.debug("", (Throwable)e);
            return false;
        }
    }

    public int fileGroupOption(String id) throws FormatException, IOException {
        return 0;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        String software;
        TiffParser tp = new TiffParser(stream);
        IFD ifd = tp.getFirstIFD();
        if (ifd == null) {
            stream.seek(0L);
            return stream.readString(6).equals("<Data>");
        }
        String document = ifd.getIFDTextValue(269);
        if (document == null) {
            document = "";
        }
        if ((software = ifd.getIFDTextValue(305)) == null) {
            software = "";
        }
        software = software.trim();
        return document.startsWith("CHANNEL") || software.startsWith("TCS");
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReaders[this.lastPlane].get8BitLookupTable();
    }

    public short[][] get16BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.tiffReaders[this.lastPlane].get16BitLookupTable();
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        int n = no;
        for (int i = 0; i < this.series; ++i) {
            n += this.core[i].imageCount;
        }
        if (this.tiffReaders.length == 1) {
            return this.tiffReaders[0].openBytes(n, buf, x, y, w, h);
        }
        int plane = 0;
        if (this.tiffReaders[0].getImageCount() > 1) {
            plane = (n /= this.tiffReaders.length) % this.tiffReaders.length;
        }
        if (this.lastPlane != 0) {
            this.tiffReaders[this.lastPlane].close();
        }
        this.lastPlane = n;
        this.tiffReaders[n].setId(this.tiffs.get(n));
        return this.tiffReaders[n].openBytes(plane, buf, x, y, w, h);
    }

    public String[] getSeriesUsedFiles(boolean noPixels) {
        FormatTools.assertId(this.currentId, true, 1);
        if (noPixels) {
            String[] stringArray;
            if (this.xmlFile == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.xmlFile;
            }
            return stringArray;
        }
        Vector<String> v = new Vector<String>();
        v.addAll(this.tiffs);
        if (this.xmlFile != null) {
            v.add(this.xmlFile);
        }
        return v.toArray(new String[v.size()]);
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.tiffs = null;
            if (this.tiffReaders != null) {
                for (TiffReader r : this.tiffReaders) {
                    if (r == null) continue;
                    r.close();
                }
            }
            this.tiffReaders = null;
            this.tiffParser = null;
            this.datestamp = 0L;
            this.xmlFile = null;
            this.lastPlane = 0;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int i;
        Location l = new Location(id).getAbsoluteFile();
        Location parent = l.getParentFile();
        Object[] list = parent.list();
        Arrays.sort(list);
        boolean isXML = TCSReader.checkSuffix(id, XML_SUFFIX);
        if (list != null) {
            for (Object file2 : list) {
                if (TCSReader.checkSuffix((String)file2, XML_SUFFIX) && !isXML && this.isGroupFiles()) {
                    this.xmlFile = new Location(parent, (String)file2).getAbsolutePath();
                    break;
                }
                if (!TCSReader.checkSuffix((String)file2, TiffReader.TIFF_SUFFIXES) || !isXML) continue;
                this.initFile(new Location(parent, (String)file2).getAbsolutePath());
                return;
            }
        }
        if (isXML) {
            this.xmlFile = l.getAbsolutePath();
        }
        super.initFile(id);
        MetadataStore store = this.makeFilterMetadata();
        this.in = new RandomAccessInputStream(id);
        this.tiffParser = new TiffParser(this.in);
        this.tiffs = new Vector();
        IFDList ifds = this.tiffParser.getIFDs();
        String date = ((IFD)ifds.get(0)).getIFDStringValue(306);
        if (date != null) {
            this.datestamp = DateTools.getTime(date, "yyyy:MM:dd HH:mm:ss");
        }
        this.groupFiles();
        this.addGlobalMeta("Number of image files", this.tiffs.size());
        this.tiffReaders = new TiffReader[this.tiffs.size()];
        for (int i2 = 0; i2 < this.tiffReaders.length; ++i2) {
            this.tiffReaders[i2] = new TiffReader();
        }
        this.tiffReaders[0].setId(this.tiffs.get(0));
        int[] ch = new int[ifds.size()];
        int[] idx = new int[ifds.size()];
        long[] stamp = new long[ifds.size()];
        int channelCount = 0;
        this.core[0].sizeZ = 1;
        this.core[0].sizeC = this.tiffReaders[0].getSizeC();
        String string = this.core[0].dimensionOrder = this.isRGB() ? "XYC" : "XY";
        if (this.isGroupFiles()) {
            try {
                FilePattern fp = new FilePattern(new Location(this.currentId).getAbsoluteFile());
                AxisGuesser guesser = new AxisGuesser(fp, "XYTZC", 1, ifds.size(), 1, true);
                int[] axisTypes = guesser.getAxisTypes();
                int[] count = fp.getCount();
                for (i = axisTypes.length - 1; i >= 0; --i) {
                    if (axisTypes[i] == 1) {
                        if (this.getDimensionOrder().indexOf("Z") == -1) {
                            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
                        }
                        this.core[0].sizeZ *= count[i];
                        continue;
                    }
                    if (axisTypes[i] != 3) continue;
                    if (this.getDimensionOrder().indexOf("C") == -1) {
                        this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
                    }
                    this.core[0].sizeC *= count[i];
                }
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
        for (int i3 = 0; i3 < ifds.size(); ++i3) {
            int space;
            String document = ((IFD)ifds.get(i3)).getIFDStringValue(269);
            if (document == null) continue;
            int index = document.indexOf("INDEX");
            String s = document.substring(8, index).trim();
            ch[i3] = Integer.parseInt(s);
            if (ch[i3] > channelCount) {
                channelCount = ch[i3];
            }
            if ((space = document.indexOf(" ", index + 6)) < 0) continue;
            String n = document.substring(index + 6, space).trim();
            idx[i3] = Integer.parseInt(n);
            date = document.substring(space, document.indexOf("FORMAT")).trim();
            stamp[i3] = DateTools.getTime(date, DATE_FORMAT);
            this.addGlobalMeta("Timestamp for plane #" + i3, stamp[i3]);
        }
        this.core[0].sizeT = 0;
        boolean unique = true;
        for (int i4 = 0; i4 < stamp.length; ++i4) {
            for (int j = i4 + 1; j < stamp.length; ++j) {
                if (stamp[j] != stamp[i4]) continue;
                unique = false;
                break;
            }
            if (unique) {
                ++this.core[0].sizeT;
                if (this.getDimensionOrder().indexOf("T") < 0) {
                    this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
                }
            } else if (i4 > 0) {
                if (ch[i4] != ch[i4 - 1] && this.getDimensionOrder().indexOf("C") < 0) {
                    this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
                } else if (this.getDimensionOrder().indexOf("Z") < 0) {
                    this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
                }
            }
            unique = true;
        }
        if (this.getDimensionOrder().indexOf("Z") < 0) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "Z";
        }
        if (this.getDimensionOrder().indexOf("C") < 0) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "C";
        }
        if (this.getDimensionOrder().indexOf("T") < 0) {
            this.core[0].dimensionOrder = this.core[0].dimensionOrder + "T";
        }
        if (this.getSizeC() == 0) {
            this.core[0].sizeC = 1;
        }
        if (this.getSizeT() == 0) {
            this.core[0].sizeT = 1;
        }
        if (channelCount == 0) {
            channelCount = 1;
        }
        if (this.getSizeZ() <= 1) {
            this.core[0].sizeZ = ifds.size() / (this.getSizeT() * channelCount);
        }
        this.core[0].sizeC *= channelCount;
        this.core[0].imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
        String comment = ((IFD)ifds.get(0)).getComment();
        if (comment != null && comment.startsWith("[") && this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            String[] lines;
            for (String line : lines = comment.split("\n")) {
                int eq;
                if (line.startsWith("[") || (eq = line.indexOf("=")) < 0) continue;
                String key = line.substring(0, eq).trim();
                String value = line.substring(eq + 1).trim();
                if (key.equals("VoxelSizeX")) {
                    try {
                        this.voxelX = Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {}
                } else if (key.equals("VoxelSizeY")) {
                    try {
                        this.voxelY = Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {}
                } else if (key.equals("VoxelSizeZ")) {
                    try {
                        this.voxelZ = Double.parseDouble(value);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                this.addGlobalMeta(key, value);
            }
            this.metadata.remove("Comment");
        }
        this.core[0].sizeX = this.tiffReaders[0].getSizeX();
        this.core[0].sizeY = this.tiffReaders[0].getSizeY();
        this.core[0].rgb = this.tiffReaders[0].isRGB();
        this.core[0].pixelType = this.tiffReaders[0].getPixelType();
        this.core[0].littleEndian = this.tiffReaders[0].isLittleEndian();
        this.core[0].interleaved = this.tiffReaders[0].isInterleaved();
        this.core[0].falseColor = true;
        this.core[0].indexed = this.tiffReaders[0].isIndexed();
        if (this.isRGB()) {
            this.core[0].imageCount /= this.getSizeC() / channelCount;
        }
        if (this.getSizeZ() * this.getSizeT() * this.getEffectiveSizeC() != ifds.size() * this.tiffReaders.length) {
            int c = this.getEffectiveSizeC();
            if (c == 0) {
                c = 1;
            }
            this.core[0].sizeT = ifds.size() * this.tiffReaders.length / (c * this.getSizeZ());
            this.core[0].imageCount = this.getSizeT() * c * this.getSizeZ();
            if (this.getSizeT() == 0) {
                this.core[0].sizeT = 1;
                this.core[0].imageCount = ifds.size() * this.tiffReaders.length;
            }
        }
        if (this.getImageCount() == ifds.size() * this.getSizeZ() * this.getSizeT() && ifds.size() > 1) {
            if (this.getSizeZ() == 1) {
                this.core[0].sizeZ = ifds.size();
            } else if (this.getSizeT() == 1) {
                this.core[0].sizeT = ifds.size();
            } else {
                this.core[0].sizeZ *= ifds.size();
            }
        }
        if (this.xmlFile != null) {
            String xml = DataTools.readFile(this.xmlFile);
            xml = XMLTools.sanitizeXML(PREFIX + xml + SUFFIX);
            LeicaHandler handler = new LeicaHandler(store, this.getMetadataOptions().getMetadataLevel());
            XMLTools.parseXML(xml, (DefaultHandler)handler);
            this.metadata = handler.getGlobalMetadata();
            MetadataTools.merge(handler.getGlobalMetadata(), this.metadata, "");
            this.core = handler.getCoreMetadata().toArray(new CoreMetadata[0]);
            for (i = 0; i < this.getSeriesCount(); ++i) {
                if (this.tiffs.size() < this.core[i].imageCount) {
                    int div = this.core[i].imageCount / this.core[i].sizeC;
                    this.core[i].imageCount = this.tiffs.size();
                    if (div >= this.core[i].sizeZ) {
                        this.core[i].sizeZ /= div;
                    } else if (div >= this.core[i].sizeT) {
                        this.core[i].sizeT /= div;
                    }
                }
                this.core[i].dimensionOrder = this.getSizeZ() > this.getSizeT() ? "XYCZT" : "XYCTZ";
                this.core[i].rgb = false;
                this.core[i].interleaved = false;
                this.core[i].indexed = this.tiffReaders[0].isIndexed();
            }
        }
        MetadataTools.populatePixels(store, this, true);
        if (this.voxelX > 0.0) {
            store.setPixelsPhysicalSizeX(new PositiveFloat(this.voxelX), 0);
        } else {
            LOGGER.warn("Expected positive value for PhysicalSizeX; got {}", (Object)this.voxelX);
        }
        if (this.voxelY > 0.0) {
            store.setPixelsPhysicalSizeY(new PositiveFloat(this.voxelY), 0);
        } else {
            LOGGER.warn("Expected positive value for PhysicalSizeY; got {}", (Object)this.voxelY);
        }
        if (this.voxelZ > 0.0) {
            store.setPixelsPhysicalSizeZ(new PositiveFloat(this.voxelZ), 0);
        } else {
            LOGGER.warn("Expected positive value for PhysicalSizeZ; got {}", (Object)this.voxelZ);
        }
    }

    private void groupFiles() throws FormatException, IOException {
        Location current = new Location(this.currentId).getAbsoluteFile();
        if (!TCSReader.checkSuffix(this.currentId, XML_SUFFIX)) {
            this.tiffs.add(current.getAbsolutePath());
        }
        if (!this.isGroupFiles()) {
            return;
        }
        Location parent = current.getParentFile();
        Object[] list = parent.list();
        Arrays.sort(list);
        HashMap<Object, Long> timestamps = new HashMap<Object, Long>();
        RandomAccessInputStream s = new RandomAccessInputStream(current.getAbsolutePath());
        TiffParser p = new TiffParser(s);
        IFD ifd = (IFD)p.getIFDs().get(0);
        s.close();
        int expectedIFDCount = p.getIFDs().size();
        long width = ifd.getImageWidth();
        long height = ifd.getImageLength();
        int samples = ifd.getSamplesPerPixel();
        for (Object file2 : list) {
            RandomAccessInputStream rais;
            TiffParser tp;
            if (((String)(file2 = new Location(parent, (String)file2).getAbsolutePath())).length() != current.getAbsolutePath().length() || !(tp = new TiffParser(rais = new RandomAccessInputStream((String)file2))).isValidHeader()) continue;
            ifd = (IFD)tp.getIFDs().get(0);
            if (tp.getIFDs().size() != expectedIFDCount || ifd.getImageWidth() != width || ifd.getImageLength() != height || ifd.getSamplesPerPixel() != samples) continue;
            String date = ifd.getIFDStringValue(306);
            if (date != null) {
                long stamp = DateTools.getTime(date, "yyyy:MM:dd HH:mm:ss");
                String software = ifd.getIFDStringValue(305);
                if (software != null && software.trim().startsWith("TCS")) {
                    timestamps.put(file2, new Long(stamp));
                }
            }
            rais.close();
        }
        Object[] files = timestamps.keySet().toArray(new String[timestamps.size()]);
        Arrays.sort(files);
        for (Object file3 : files) {
            long thisStamp = (Long)timestamps.get(file3);
            boolean match = false;
            for (String tiff : this.tiffs) {
                s = new RandomAccessInputStream(tiff);
                TiffParser parser = new TiffParser(s);
                ifd = (IFD)parser.getIFDs().get(0);
                s.close();
                String date = ifd.getIFDStringValue(306);
                long nextStamp = DateTools.getTime(date, "yyyy:MM:dd HH:mm:ss");
                if (Math.abs(thisStamp - nextStamp) >= 600000L) continue;
                match = true;
                break;
            }
            if (!match || this.tiffs.contains(file3)) continue;
            this.tiffs.add((String)file3);
        }
    }
}

