/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DateTools;
import loci.common.RandomAccessInputStream;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.xml.model.primitives.PositiveFloat;
import ome.xml.model.primitives.Timestamp;

public class WATOPReader
extends FormatReader {
    private static final int HEADER_SIZE = 4864;
    private static final String WAT_MAGIC_STRING = "0TOPSystem W.A.Technology";

    public WATOPReader() {
        super("WA Technology TOP", "wat");
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 25;
        if (!FormatTools.validStream(stream, 25, false)) {
            return false;
        }
        return stream.readString(25).equals(WAT_MAGIC_STRING);
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h);
        this.in.seek(4864L);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.core[0].littleEndian = true;
        this.in.order(this.isLittleEndian());
        String comment = null;
        MetadataLevel level = this.getMetadataOptions().getMetadataLevel();
        if (level != MetadataLevel.MINIMUM) {
            this.in.seek(49L);
            comment = this.in.readString(33);
        }
        this.in.seek(211L);
        int year = this.in.readInt();
        int month = this.in.readInt();
        int day = this.in.readInt();
        int hour = this.in.readInt();
        int min = this.in.readInt();
        String date = year + "-" + month + "-" + day + "T" + hour + ":" + min;
        date = DateTools.formatDate(date, "yyyy-MM-dd'T'HH:mm");
        this.in.skipBytes(8);
        double xSize = (double)this.in.readInt() / 100.0;
        double ySize = (double)this.in.readInt() / 100.0;
        double zSize = (double)this.in.readInt() / 100.0;
        this.core[0].sizeX = this.in.readInt();
        this.core[0].sizeY = this.in.readInt();
        if (level != MetadataLevel.MINIMUM) {
            double tunnelCurrent = (double)this.in.readInt() / 1000.0;
            double sampleVolts = (double)this.in.readInt() / 1000.0;
            this.in.skipBytes(180);
            int originalZMax = this.in.readInt();
            int originalZMin = this.in.readInt();
            int zMax = this.in.readInt();
            int zMin = this.in.readInt();
            this.addGlobalMeta("Comment", comment);
            this.addGlobalMeta("X size (in um)", xSize);
            this.addGlobalMeta("Y size (in um)", ySize);
            this.addGlobalMeta("Z size (in um)", zSize);
            this.addGlobalMeta("Tunnel current (in amps)", tunnelCurrent);
            this.addGlobalMeta("Sample volts", sampleVolts);
            this.addGlobalMeta("Acquisition date", date);
        }
        this.core[0].pixelType = 2;
        this.core[0].sizeC = 1;
        this.core[0].sizeZ = 1;
        this.core[0].sizeT = 1;
        this.core[0].imageCount = 1;
        this.core[0].dimensionOrder = "XYZCT";
        this.core[0].rgb = false;
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
        if (date != null) {
            store.setImageAcquisitionDate(new Timestamp(date), 0);
        }
        if (level != MetadataLevel.MINIMUM) {
            store.setImageDescription(comment, 0);
            if (xSize > 0.0) {
                store.setPixelsPhysicalSizeX(new PositiveFloat(xSize / (double)this.getSizeX()), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeX; got {}", (Object)(xSize / (double)this.getSizeX()));
            }
            if (ySize > 0.0) {
                store.setPixelsPhysicalSizeY(new PositiveFloat(ySize / (double)this.getSizeY()), 0);
            } else {
                LOGGER.warn("Expected positive value for PhysicalSizeY; got {}", (Object)(ySize / (double)this.getSizeY()));
            }
        }
    }
}

