/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model.enums;

import ome.xml.model.enums.Enumeration;
import ome.xml.model.enums.EnumerationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LaserType implements Enumeration
{
    EXCIMER("Excimer"),
    GAS("Gas"),
    METALVAPOR("MetalVapor"),
    SOLIDSTATE("SolidState"),
    DYE("Dye"),
    SEMICONDUCTOR("Semiconductor"),
    FREEELECTRON("FreeElectron"),
    OTHER("Other");

    private final String value;

    private LaserType(String value) {
        this.value = value;
    }

    public static LaserType fromString(String value) throws EnumerationException {
        if ("Excimer".equals(value)) {
            return EXCIMER;
        }
        if ("Gas".equals(value)) {
            return GAS;
        }
        if ("MetalVapor".equals(value)) {
            return METALVAPOR;
        }
        if ("SolidState".equals(value)) {
            return SOLIDSTATE;
        }
        if ("Dye".equals(value)) {
            return DYE;
        }
        if ("Semiconductor".equals(value)) {
            return SEMICONDUCTOR;
        }
        if ("FreeElectron".equals(value)) {
            return FREEELECTRON;
        }
        if ("Other".equals(value)) {
            return OTHER;
        }
        String s = String.format("%s not a supported value of %s", value, LaserType.class);
        throw new EnumerationException(s);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

